/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkACL
extends ConfigObject {
    public static final Integer GRANT_ALL = 0;
    public static final Integer DENY_ALL = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer defaultMode;

    public NetworkACL() {
        this(true);
    }

    public NetworkACL(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(52, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(54, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "NetworkACL";
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public String getDefaultModeValue() throws ValidationException {
        if (this.defaultMode == null) {
            return null;
        }
        String s = null;
        switch (this.defaultMode) {
            case 0: {
                s = "GRANT_ALL";
                break;
            }
            case 1: {
                s = "DENY_ALL";
                break;
            }
            default: {
                throw new ValidationException("NetworkACL/DefaultMode: invalid attribute value:" + this.defaultMode + "!");
            }
        }
        return s;
    }

    public void setDefaultMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.defaultMode = value;
    }

    public void setDefaultModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("GRANT_ALL".equals(value)) {
            this.defaultMode = GRANT_ALL;
        } else if ("DENY_ALL".equals(value)) {
            this.defaultMode = DENY_ALL;
        } else {
            throw new ValidationException("NetworkACL/DefaultMode: invalid attribute value:" + value + "!");
        }
    }

    public void addIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IpAddress> getIpAddress() {
        Vector<IpAddress> v = new Vector<IpAddress>();
        for (Transportable child : (ChildGroup)this.children.get(52)) {
            v.add((IpAddress)child);
        }
        return v;
    }

    public int getIpAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return childGroup.size();
    }

    public IpAddress getIpAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return (IpAddress)childGroup.get(index);
    }

    public void setIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpAddress(IpAddress value) {
        this.removeChild(value);
    }

    public void addSubNet(SubNet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSubNet(int index, SubNet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SubNet> getSubNet() {
        Vector<SubNet> v = new Vector<SubNet>();
        for (Transportable child : (ChildGroup)this.children.get(54)) {
            v.add((SubNet)child);
        }
        return v;
    }

    public int getSubNetCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(54);
        return childGroup.size();
    }

    public SubNet getSubNet(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(54);
        return (SubNet)childGroup.get(index);
    }

    public void setSubNet(int index, SubNet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSubNet(SubNet value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 51;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.defaultMode == null) {
            throw new ValidationException("NetworkACL/DefaultMode: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.addIpAddress((IpAddress)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SubNet) {
            try {
                this.addSubNet((SubNet)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("DefaultMode")) == null) {
                throw new ValidationException("NetworkACL/DefaultMode: attribute is required!");
            }
            this.setDefaultModeValue(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getIpAddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpAddress(i).setReadonly();
        }
        objCnt = this.getSubNetCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSubNet(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"NetworkACL".equals(element.getNodeName())) {
            throw new ValidationException("NetworkACL: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DefaultMode")) == null) {
            throw new ValidationException("NetworkACL/DefaultMode: attribute is required!");
        }
        this.setDefaultModeValue(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IpAddress");
        for (i = 0; i < v.size(); ++i) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(i));
            this.addIpAddress(ipAddressObj);
        }
        v = XMLHelper.getChildElementByName(element, "SubNet");
        for (i = 0; i < v.size(); ++i) {
            SubNet subNetObj = new SubNet();
            subNetObj.importFromElement(v.get(i));
            this.addSubNet(subNetObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("NetworkACL/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("NetworkACL/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("NetworkACL");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.defaultMode != null) {
            element.setAttribute("DefaultMode", this.getDefaultModeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NetworkACL ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.defaultMode != null) {
                strAttrs.append("DefaultMode=\"").append(this.getDefaultModeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NetworkACL>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

