/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MasterSwitchButton
extends ConfigObject {
    public static final Integer ALL_TRAFFIC = 0;
    public static final Integer OUTBOUND_ONLY = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer allowDisableBlocking;
    private Integer allowedAttempts;
    private Integer activeTimer;

    public MasterSwitchButton() {
        this(true);
    }

    public MasterSwitchButton(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "MasterSwitchButton";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefAllowDisableBlocking() {
        return ALL_TRAFFIC;
    }

    public Integer getOptAllowDisableBlocking() {
        return this.allowDisableBlocking;
    }

    public String getOptAllowDisableBlockingValue() throws ValidationException {
        if (this.allowDisableBlocking == null) {
            return null;
        }
        String s = null;
        switch (this.allowDisableBlocking) {
            case 0: {
                s = "ALL_TRAFFIC";
                break;
            }
            case 1: {
                s = "OUTBOUND_ONLY";
                break;
            }
            default: {
                throw new ValidationException("MasterSwitchButton/AllowDisableBlocking: invalid attribute value:" + this.allowDisableBlocking + "!");
            }
        }
        return s;
    }

    public void setOptAllowDisableBlocking(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowDisableBlocking = value;
    }

    public void setOptAllowDisableBlockingValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.allowDisableBlocking = null;
            return;
        }
        if ("ALL_TRAFFIC".equals(value)) {
            this.allowDisableBlocking = ALL_TRAFFIC;
        } else if ("OUTBOUND_ONLY".equals(value)) {
            this.allowDisableBlocking = OUTBOUND_ONLY;
        } else {
            throw new ValidationException("MasterSwitchButton/AllowDisableBlocking: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefAllowedAttempts() {
        return 0;
    }

    public Integer getOptAllowedAttempts() {
        return this.allowedAttempts;
    }

    public void setOptAllowedAttempts(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedAttempts = value;
    }

    public Integer getActiveTimer() {
        return this.activeTimer;
    }

    public void setActiveTimer(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.activeTimer = value;
    }

    @Override
    public int getObjectType() {
        return 225;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.activeTimer == null) {
            throw new ValidationException("MasterSwitchButton/ActiveTimer: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("AllowDisableBlocking")) != null) {
                this.setOptAllowDisableBlockingValue(value);
            }
            if ((value = attris.getValue("AllowedAttempts")) != null) {
                try {
                    this.allowedAttempts = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("MasterSwitchButton/AllowedAttempts: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("MasterSwitchButton/AllowedAttempts: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ActiveTimer")) == null) {
                throw new ValidationException("MasterSwitchButton/ActiveTimer: attribute is required!");
            }
            try {
                this.activeTimer = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("MasterSwitchButton/ActiveTimer: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("MasterSwitchButton/ActiveTimer: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"MasterSwitchButton".equals(element.getNodeName())) {
            throw new ValidationException("MasterSwitchButton: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowDisableBlocking")) != null) {
            this.setOptAllowDisableBlockingValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedAttempts")) != null) {
            try {
                this.allowedAttempts = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("MasterSwitchButton/AllowedAttempts: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ActiveTimer")) == null) {
            throw new ValidationException("MasterSwitchButton/ActiveTimer: attribute is required!");
        }
        try {
            this.activeTimer = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("MasterSwitchButton/ActiveTimer: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("MasterSwitchButton/ActiveTimer: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("MasterSwitchButton/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("MasterSwitchButton/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("MasterSwitchButton");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.allowDisableBlocking != null) {
            element.setAttribute("AllowDisableBlocking", this.getOptAllowDisableBlockingValue());
        }
        if (this.allowedAttempts != null) {
            element.setAttribute("AllowedAttempts", this.allowedAttempts.toString());
        }
        if (this.activeTimer != null) {
            element.setAttribute("ActiveTimer", this.activeTimer.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<MasterSwitchButton ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowDisableBlocking != null) {
                strAttrs.append("AllowDisableBlocking=\"").append(this.getOptAllowDisableBlockingValue()).append("\" ");
            }
            if (this.allowedAttempts != null) {
                strAttrs.append("AllowedAttempts=\"").append(this.allowedAttempts.toString()).append("\" ");
            }
            if (this.activeTimer != null) {
                strAttrs.append("ActiveTimer=\"").append(this.activeTimer.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</MasterSwitchButton>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

