/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MacGeneralScanSettings
extends ConfigObject {
    public static final Integer SHOW_ONLY_WHEN_INFECTED_FILES_FOUND = 0;
    public static final Integer SHOW_ALL_SCHEDULED_SCAN_RESULTS = 1;
    private static final long serialVersionUID = 1L;
    private Boolean allowScanSnooze;
    private Boolean allowScanCancel;
    private Integer scanResultsDisplay;
    private Boolean autoRepairInfectedFiles;
    private Boolean quarantineUnrepairableFiles;

    public MacGeneralScanSettings() {
        this(true);
    }

    public MacGeneralScanSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(627, new ChildGroup(0, 1));
        this.children.put(616, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "MacGeneralScanSettings";
    }

    public Boolean getDefAllowScanSnooze() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowScanSnooze() {
        return this.allowScanSnooze;
    }

    public void setOptAllowScanSnooze(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowScanSnooze = value;
    }

    public Boolean getDefAllowScanCancel() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowScanCancel() {
        return this.allowScanCancel;
    }

    public void setOptAllowScanCancel(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowScanCancel = value;
    }

    public Integer getDefScanResultsDisplay() {
        return SHOW_ONLY_WHEN_INFECTED_FILES_FOUND;
    }

    public Integer getOptScanResultsDisplay() {
        return this.scanResultsDisplay;
    }

    public String getOptScanResultsDisplayValue() throws ValidationException {
        if (this.scanResultsDisplay == null) {
            return null;
        }
        String s = null;
        switch (this.scanResultsDisplay) {
            case 0: {
                s = "SHOW_ONLY_WHEN_INFECTED_FILES_FOUND";
                break;
            }
            case 1: {
                s = "SHOW_ALL_SCHEDULED_SCAN_RESULTS";
                break;
            }
            default: {
                throw new ValidationException("MacGeneralScanSettings/ScanResultsDisplay: invalid attribute value:" + this.scanResultsDisplay + "!");
            }
        }
        return s;
    }

    public void setOptScanResultsDisplay(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanResultsDisplay = value;
    }

    public void setOptScanResultsDisplayValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanResultsDisplay = null;
            return;
        }
        if ("SHOW_ONLY_WHEN_INFECTED_FILES_FOUND".equals(value)) {
            this.scanResultsDisplay = SHOW_ONLY_WHEN_INFECTED_FILES_FOUND;
        } else if ("SHOW_ALL_SCHEDULED_SCAN_RESULTS".equals(value)) {
            this.scanResultsDisplay = SHOW_ALL_SCHEDULED_SCAN_RESULTS;
        } else {
            throw new ValidationException("MacGeneralScanSettings/ScanResultsDisplay: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefAutoRepairInfectedFiles() {
        return Boolean.FALSE;
    }

    public Boolean getOptAutoRepairInfectedFiles() {
        return this.autoRepairInfectedFiles;
    }

    public void setOptAutoRepairInfectedFiles(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.autoRepairInfectedFiles = value;
    }

    public Boolean getDefQuarantineUnrepairableFiles() {
        return Boolean.TRUE;
    }

    public Boolean getOptQuarantineUnrepairableFiles() {
        return this.quarantineUnrepairableFiles;
    }

    public void setOptQuarantineUnrepairableFiles(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.quarantineUnrepairableFiles = value;
    }

    public CompressedFiles getOptCompressedFiles() {
        ChildGroup childGroup = (ChildGroup)this.children.get(627);
        if (childGroup.size() > 0) {
            return (CompressedFiles)childGroup.get(0);
        }
        return null;
    }

    public void setOptCompressedFiles(CompressedFiles value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CompressedFiles obj = this.getOptCompressedFiles();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ApActions getOptApActions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(616);
        if (childGroup.size() > 0) {
            return (ApActions)childGroup.get(0);
        }
        return null;
    }

    public void setOptApActions(ApActions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ApActions obj = this.getOptApActions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 663;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof CompressedFiles) {
            try {
                this.setOptCompressedFiles((CompressedFiles)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ApActions) {
            try {
                this.setOptApActions((ApActions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AllowScanSnooze");
            if (value != null) {
                this.allowScanSnooze = "1".equals(value);
            }
            if ((value = attris.getValue("AllowScanCancel")) != null) {
                this.allowScanCancel = "1".equals(value);
            }
            if ((value = attris.getValue("ScanResultsDisplay")) != null) {
                this.setOptScanResultsDisplayValue(value);
            }
            if ((value = attris.getValue("AutoRepairInfectedFiles")) != null) {
                this.autoRepairInfectedFiles = "1".equals(value);
            }
            if ((value = attris.getValue("QuarantineUnrepairableFiles")) != null) {
                this.quarantineUnrepairableFiles = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptCompressedFiles() != null) {
            this.getOptCompressedFiles().setReadonly();
        }
        if (this.getOptApActions() != null) {
            this.getOptApActions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"MacGeneralScanSettings".equals(element.getNodeName())) {
            throw new ValidationException("MacGeneralScanSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AllowScanSnooze");
        if (value != null) {
            this.allowScanSnooze = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowScanCancel")) != null) {
            this.allowScanCancel = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ScanResultsDisplay")) != null) {
            this.setOptScanResultsDisplayValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AutoRepairInfectedFiles")) != null) {
            this.autoRepairInfectedFiles = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "QuarantineUnrepairableFiles")) != null) {
            this.quarantineUnrepairableFiles = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "CompressedFiles")).size() > 0) {
            CompressedFiles compressedFilesObj = new CompressedFiles();
            compressedFilesObj.importFromElement(v.get(0));
            this.setOptCompressedFiles(compressedFilesObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ApActions")).size() > 0) {
            ApActions apActionsObj = new ApActions();
            apActionsObj.importFromElement(v.get(0));
            this.setOptApActions(apActionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("MacGeneralScanSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("MacGeneralScanSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("MacGeneralScanSettings");
        if (this.allowScanSnooze != null) {
            element.setAttribute("AllowScanSnooze", this.allowScanSnooze != false ? "1" : "0");
        }
        if (this.allowScanCancel != null) {
            element.setAttribute("AllowScanCancel", this.allowScanCancel != false ? "1" : "0");
        }
        if (this.scanResultsDisplay != null) {
            element.setAttribute("ScanResultsDisplay", this.getOptScanResultsDisplayValue());
        }
        if (this.autoRepairInfectedFiles != null) {
            element.setAttribute("AutoRepairInfectedFiles", this.autoRepairInfectedFiles != false ? "1" : "0");
        }
        if (this.quarantineUnrepairableFiles != null) {
            element.setAttribute("QuarantineUnrepairableFiles", this.quarantineUnrepairableFiles != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<MacGeneralScanSettings ");
            if (this.allowScanSnooze != null) {
                strAttrs.append("AllowScanSnooze=").append(this.allowScanSnooze != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowScanCancel != null) {
                strAttrs.append("AllowScanCancel=").append(this.allowScanCancel != false ? "\"1\" " : "\"0\" ");
            }
            if (this.scanResultsDisplay != null) {
                strAttrs.append("ScanResultsDisplay=\"").append(this.getOptScanResultsDisplayValue()).append("\" ");
            }
            if (this.autoRepairInfectedFiles != null) {
                strAttrs.append("AutoRepairInfectedFiles=").append(this.autoRepairInfectedFiles != false ? "\"1\" " : "\"0\" ");
            }
            if (this.quarantineUnrepairableFiles != null) {
                strAttrs.append("QuarantineUnrepairableFiles=").append(this.quarantineUnrepairableFiles != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</MacGeneralScanSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

