/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.MacGeneralScanSettings;
import com.sygate.scm.common.configobject.schema.MacScanNotification;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MacAvScanPolicy
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public MacAvScanPolicy() {
        this(true);
    }

    public MacAvScanPolicy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(663, new ChildGroup(0, 1));
        this.children.put(659, new ChildGroup(0, 1));
        this.children.put(661, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "MacAvScanPolicy";
    }

    public void addObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ObjReference> getObjReference() {
        Vector<ObjReference> v = new Vector<ObjReference>();
        for (Transportable child : (ChildGroup)this.children.get(3)) {
            v.add((ObjReference)child);
        }
        return v;
    }

    public int getObjReferenceCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return childGroup.size();
    }

    public ObjReference getObjReference(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return (ObjReference)childGroup.get(index);
    }

    public ObjReference getObjReferenceByType(String type) {
        if (type == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType())) continue;
            return reference;
        }
        return null;
    }

    public ObjReference getObjReferenceByTypeAndName(String type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType()) || !name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    public void setObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeObjReference(ObjReference value) {
        this.removeChild(value);
    }

    public MacGeneralScanSettings getOptMacGeneralScanSettings() {
        ChildGroup childGroup = (ChildGroup)this.children.get(663);
        if (childGroup.size() > 0) {
            return (MacGeneralScanSettings)childGroup.get(0);
        }
        return null;
    }

    public void setOptMacGeneralScanSettings(MacGeneralScanSettings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MacGeneralScanSettings obj = this.getOptMacGeneralScanSettings();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public MacCommandScan getOptMacCommandScan() {
        ChildGroup childGroup = (ChildGroup)this.children.get(659);
        if (childGroup.size() > 0) {
            return (MacCommandScan)childGroup.get(0);
        }
        return null;
    }

    public void setOptMacCommandScan(MacCommandScan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MacCommandScan obj = this.getOptMacCommandScan();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public MacScanNotification getOptMacScanNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(661);
        if (childGroup.size() > 0) {
            return (MacScanNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptMacScanNotification(MacScanNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MacScanNotification obj = this.getOptMacScanNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 658;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.addObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof MacGeneralScanSettings) {
            try {
                this.setOptMacGeneralScanSettings((MacGeneralScanSettings)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof MacCommandScan) {
            try {
                this.setOptMacCommandScan((MacCommandScan)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof MacScanNotification) {
            try {
                this.setOptMacScanNotification((MacScanNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getObjReferenceCount();
        for (i = 0; i < objCnt; ++i) {
            this.getObjReference(i).setReadonly();
        }
        if (this.getOptMacGeneralScanSettings() != null) {
            this.getOptMacGeneralScanSettings().setReadonly();
        }
        if (this.getOptMacCommandScan() != null) {
            this.getOptMacCommandScan().setReadonly();
        }
        if (this.getOptMacScanNotification() != null) {
            this.getOptMacScanNotification().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"MacAvScanPolicy".equals(element.getNodeName())) {
            throw new ValidationException("MacAvScanPolicy: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ObjReference");
        for (int i = 0; i < v.size(); ++i) {
            ObjReference objReferenceObj = new ObjReference();
            objReferenceObj.importFromElement(v.get(i));
            this.addObjReference(objReferenceObj);
        }
        v = XMLHelper.getChildElementByName(element, "MacGeneralScanSettings");
        if (v.size() > 0) {
            MacGeneralScanSettings macGeneralScanSettingsObj = new MacGeneralScanSettings();
            macGeneralScanSettingsObj.importFromElement(v.get(0));
            this.setOptMacGeneralScanSettings(macGeneralScanSettingsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "MacCommandScan")).size() > 0) {
            MacCommandScan macCommandScanObj = new MacCommandScan();
            macCommandScanObj.importFromElement(v.get(0));
            this.setOptMacCommandScan(macCommandScanObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "MacScanNotification")).size() > 0) {
            MacScanNotification macScanNotificationObj = new MacScanNotification();
            macScanNotificationObj.importFromElement(v.get(0));
            this.setOptMacScanNotification(macScanNotificationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("MacAvScanPolicy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("MacAvScanPolicy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("MacAvScanPolicy");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<MacAvScanPolicy ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</MacAvScanPolicy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

