/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.Throttling;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MacAdminDefinedScanDetails
extends ConfigObject {
    public static final Integer DRIVES = 0;
    public static final Integer FOLDERS = 1;
    private static final long serialVersionUID = 1L;
    private Integer scanSelection;
    private String scanDirectories;
    private Boolean hardDrives;
    private Boolean removableDrives;
    private Boolean idleTimeScan;

    public MacAdminDefinedScanDetails() {
        this(true);
    }

    public MacAdminDefinedScanDetails(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(673, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "MacAdminDefinedScanDetails";
    }

    public Integer getDefScanSelection() {
        return DRIVES;
    }

    public Integer getOptScanSelection() {
        return this.scanSelection;
    }

    public String getOptScanSelectionValue() throws ValidationException {
        if (this.scanSelection == null) {
            return null;
        }
        String s = null;
        switch (this.scanSelection) {
            case 0: {
                s = "DRIVES";
                break;
            }
            case 1: {
                s = "FOLDERS";
                break;
            }
            default: {
                throw new ValidationException("MacAdminDefinedScanDetails/ScanSelection: invalid attribute value:" + this.scanSelection + "!");
            }
        }
        return s;
    }

    public void setOptScanSelection(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanSelection = value;
    }

    public void setOptScanSelectionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanSelection = null;
            return;
        }
        if ("DRIVES".equals(value)) {
            this.scanSelection = DRIVES;
        } else if ("FOLDERS".equals(value)) {
            this.scanSelection = FOLDERS;
        } else {
            throw new ValidationException("MacAdminDefinedScanDetails/ScanSelection: invalid attribute value:" + value + "!");
        }
    }

    public String getOptScanDirectories() {
        return this.scanDirectories;
    }

    public void setOptScanDirectories(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanDirectories = value;
    }

    public Boolean getDefHardDrives() {
        return Boolean.TRUE;
    }

    public Boolean getOptHardDrives() {
        return this.hardDrives;
    }

    public void setOptHardDrives(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hardDrives = value;
    }

    public Boolean getDefRemovableDrives() {
        return Boolean.TRUE;
    }

    public Boolean getOptRemovableDrives() {
        return this.removableDrives;
    }

    public void setOptRemovableDrives(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.removableDrives = value;
    }

    public Boolean getDefIdleTimeScan() {
        return Boolean.TRUE;
    }

    public Boolean getOptIdleTimeScan() {
        return this.idleTimeScan;
    }

    public void setOptIdleTimeScan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.idleTimeScan = value;
    }

    public Throttling getOptThrottling() {
        ChildGroup childGroup = (ChildGroup)this.children.get(673);
        if (childGroup.size() > 0) {
            return (Throttling)childGroup.get(0);
        }
        return null;
    }

    public void setOptThrottling(Throttling value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Throttling obj = this.getOptThrottling();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 662;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof Throttling) {
            try {
                this.setOptThrottling((Throttling)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ScanSelection");
            if (value != null) {
                this.setOptScanSelectionValue(value);
            }
            if ((value = attris.getValue("ScanDirectories")) != null) {
                this.scanDirectories = value;
            }
            if ((value = attris.getValue("HardDrives")) != null) {
                this.hardDrives = "1".equals(value);
            }
            if ((value = attris.getValue("RemovableDrives")) != null) {
                this.removableDrives = "1".equals(value);
            }
            if ((value = attris.getValue("IdleTimeScan")) != null) {
                this.idleTimeScan = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptThrottling() != null) {
            this.getOptThrottling().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"MacAdminDefinedScanDetails".equals(element.getNodeName())) {
            throw new ValidationException("MacAdminDefinedScanDetails: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ScanSelection");
        if (value != null) {
            this.setOptScanSelectionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ScanDirectories")) != null) {
            this.scanDirectories = value;
        }
        if ((value = XMLHelper.getAttribute(element, "HardDrives")) != null) {
            this.hardDrives = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RemovableDrives")) != null) {
            this.removableDrives = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "IdleTimeScan")) != null) {
            this.idleTimeScan = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Throttling")).size() > 0) {
            Throttling throttlingObj = new Throttling();
            throttlingObj.importFromElement(v.get(0));
            this.setOptThrottling(throttlingObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("MacAdminDefinedScanDetails/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("MacAdminDefinedScanDetails/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("MacAdminDefinedScanDetails");
        if (this.scanSelection != null) {
            element.setAttribute("ScanSelection", this.getOptScanSelectionValue());
        }
        if (this.scanDirectories != null) {
            element.setAttribute("ScanDirectories", this.scanDirectories);
        }
        if (this.hardDrives != null) {
            element.setAttribute("HardDrives", this.hardDrives != false ? "1" : "0");
        }
        if (this.removableDrives != null) {
            element.setAttribute("RemovableDrives", this.removableDrives != false ? "1" : "0");
        }
        if (this.idleTimeScan != null) {
            element.setAttribute("IdleTimeScan", this.idleTimeScan != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<MacAdminDefinedScanDetails ");
            if (this.scanSelection != null) {
                strAttrs.append("ScanSelection=\"").append(this.getOptScanSelectionValue()).append("\" ");
            }
            if (this.scanDirectories != null) {
                strAttrs.append("ScanDirectories=\"").append(AbstractSchema.checkXMLContent(this.scanDirectories)).append("\" ");
            }
            if (this.hardDrives != null) {
                strAttrs.append("HardDrives=").append(this.hardDrives != false ? "\"1\" " : "\"0\" ");
            }
            if (this.removableDrives != null) {
                strAttrs.append("RemovableDrives=").append(this.removableDrives != false ? "\"1\" " : "\"0\" ");
            }
            if (this.idleTimeScan != null) {
                strAttrs.append("IdleTimeScan=").append(this.idleTimeScan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</MacAdminDefinedScanDetails>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

