/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuState
extends ConfigObject {
    public static final Integer NOT_RUNNING = 0;
    public static final Integer IS_RUNNING = 1;
    public static final Integer SUCCESS = 0;
    public static final Integer FAIL = 1;
    public static final Integer START = 2;
    public static final Integer RETRYFAIL = 3;
    private static final long serialVersionUID = 1L;
    private String serverID;
    private Integer status;
    private Integer result;
    private Long lastUpdateTime;
    private Long startTime;
    private Long nextStartTime;
    private String lastRunServerVersion;

    public LuState() {
        this(true);
    }

    public LuState(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "LuState";
    }

    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverID = value;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusValue() throws ValidationException {
        if (this.status == null) {
            return null;
        }
        String s = null;
        switch (this.status) {
            case 0: {
                s = "NOT_RUNNING";
                break;
            }
            case 1: {
                s = "IS_RUNNING";
                break;
            }
            default: {
                throw new ValidationException("LuState/Status: invalid attribute value:" + this.status + "!");
            }
        }
        return s;
    }

    public void setStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.status = value;
    }

    public void setStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NOT_RUNNING".equals(value)) {
            this.status = NOT_RUNNING;
        } else if ("IS_RUNNING".equals(value)) {
            this.status = IS_RUNNING;
        } else {
            throw new ValidationException("LuState/Status: invalid attribute value:" + value + "!");
        }
    }

    public Integer getResult() {
        return this.result;
    }

    public String getResultValue() throws ValidationException {
        if (this.result == null) {
            return null;
        }
        String s = null;
        switch (this.result) {
            case 0: {
                s = "SUCCESS";
                break;
            }
            case 1: {
                s = "FAIL";
                break;
            }
            case 2: {
                s = "START";
                break;
            }
            case 3: {
                s = "RETRYFAIL";
                break;
            }
            default: {
                throw new ValidationException("LuState/Result: invalid attribute value:" + this.result + "!");
            }
        }
        return s;
    }

    public void setResult(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.result = value;
    }

    public void setResultValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("SUCCESS".equals(value)) {
            this.result = SUCCESS;
        } else if ("FAIL".equals(value)) {
            this.result = FAIL;
        } else if ("START".equals(value)) {
            this.result = START;
        } else if ("RETRYFAIL".equals(value)) {
            this.result = RETRYFAIL;
        } else {
            throw new ValidationException("LuState/Result: invalid attribute value:" + value + "!");
        }
    }

    public Long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastUpdateTime = value;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startTime = value;
    }

    public Long getNextStartTime() {
        return this.nextStartTime;
    }

    public void setNextStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.nextStartTime = value;
    }

    public String getOptLastRunServerVersion() {
        return this.lastRunServerVersion;
    }

    public void setOptLastRunServerVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastRunServerVersion = value;
    }

    @Override
    public int getObjectType() {
        return 189;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.serverID == null) {
            throw new ValidationException("LuState/ServerID: attribute is required!");
        }
        if (this.status == null) {
            throw new ValidationException("LuState/Status: attribute is required!");
        }
        if (this.result == null) {
            throw new ValidationException("LuState/Result: attribute is required!");
        }
        if (this.lastUpdateTime == null) {
            throw new ValidationException("LuState/LastUpdateTime: attribute is required!");
        }
        if (this.startTime == null) {
            throw new ValidationException("LuState/StartTime: attribute is required!");
        }
        if (this.nextStartTime == null) {
            throw new ValidationException("LuState/NextStartTime: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ServerID");
            if (value == null) {
                throw new ValidationException("LuState/ServerID: attribute is required!");
            }
            this.serverID = value;
            value = attris.getValue("Status");
            if (value == null) {
                throw new ValidationException("LuState/Status: attribute is required!");
            }
            this.setStatusValue(value);
            value = attris.getValue("Result");
            if (value == null) {
                throw new ValidationException("LuState/Result: attribute is required!");
            }
            this.setResultValue(value);
            value = attris.getValue("LastUpdateTime");
            if (value == null) {
                throw new ValidationException("LuState/LastUpdateTime: attribute is required!");
            }
            try {
                this.lastUpdateTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("LuState/LastUpdateTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("LuState/LastUpdateTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("StartTime");
            if (value == null) {
                throw new ValidationException("LuState/StartTime: attribute is required!");
            }
            try {
                this.startTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("LuState/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("LuState/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("NextStartTime");
            if (value == null) {
                throw new ValidationException("LuState/NextStartTime: attribute is required!");
            }
            try {
                this.nextStartTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("LuState/NextStartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("LuState/NextStartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("LastRunServerVersion");
            if (value != null) {
                this.lastRunServerVersion = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuState".equals(element.getNodeName())) {
            throw new ValidationException("LuState: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ServerID");
        if (value == null) {
            throw new ValidationException("LuState/ServerID: attribute is required!");
        }
        this.serverID = value;
        value = XMLHelper.getAttribute(element, "Status");
        if (value == null) {
            throw new ValidationException("LuState/Status: attribute is required!");
        }
        this.setStatusValue(value);
        value = XMLHelper.getAttribute(element, "Result");
        if (value == null) {
            throw new ValidationException("LuState/Result: attribute is required!");
        }
        this.setResultValue(value);
        value = XMLHelper.getAttribute(element, "LastUpdateTime");
        if (value == null) {
            throw new ValidationException("LuState/LastUpdateTime: attribute is required!");
        }
        try {
            this.lastUpdateTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("LuState/LastUpdateTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("LuState/LastUpdateTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "StartTime");
        if (value == null) {
            throw new ValidationException("LuState/StartTime: attribute is required!");
        }
        try {
            this.startTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("LuState/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("LuState/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "NextStartTime");
        if (value == null) {
            throw new ValidationException("LuState/NextStartTime: attribute is required!");
        }
        try {
            this.nextStartTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("LuState/NextStartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("LuState/NextStartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "LastRunServerVersion");
        if (value != null) {
            this.lastRunServerVersion = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuState/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuState/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuState");
        if (this.serverID != null) {
            element.setAttribute("ServerID", this.serverID);
        }
        if (this.status != null) {
            element.setAttribute("Status", this.getStatusValue());
        }
        if (this.result != null) {
            element.setAttribute("Result", this.getResultValue());
        }
        if (this.lastUpdateTime != null) {
            element.setAttribute("LastUpdateTime", this.lastUpdateTime.toString());
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.nextStartTime != null) {
            element.setAttribute("NextStartTime", this.nextStartTime.toString());
        }
        if (this.lastRunServerVersion != null) {
            element.setAttribute("LastRunServerVersion", this.lastRunServerVersion);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuState ");
            if (this.serverID != null) {
                strAttrs.append("ServerID=\"").append(AbstractSchema.checkXMLContent(this.serverID)).append("\" ");
            }
            if (this.status != null) {
                strAttrs.append("Status=\"").append(this.getStatusValue()).append("\" ");
            }
            if (this.result != null) {
                strAttrs.append("Result=\"").append(this.getResultValue()).append("\" ");
            }
            if (this.lastUpdateTime != null) {
                strAttrs.append("LastUpdateTime=\"").append(this.lastUpdateTime.toString()).append("\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(this.startTime.toString()).append("\" ");
            }
            if (this.nextStartTime != null) {
                strAttrs.append("NextStartTime=\"").append(this.nextStartTime.toString()).append("\" ");
            }
            if (this.lastRunServerVersion != null) {
                strAttrs.append("LastRunServerVersion=\"").append(AbstractSchema.checkXMLContent(this.lastRunServerVersion)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuState>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

