/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuServerRegistration
extends ConfigObject {
    public static final Integer NONE = 0;
    public static final Integer MDEF25 = 1;
    public static final Integer MDEF25_DIRECT_DELTA_ONLY = 2;
    public static final Integer DEFUTILS = 0;
    public static final Integer TEMPHOSTUTILS = 1;
    public static final Integer PATCHMANAGEMENT = 2;
    public static final Integer UNMANAGED = 3;
    private static final long serialVersionUID = 1L;
    private String product;
    private String version;
    private String language;
    private String moniker;
    private Integer deltaType;
    private String shortName;
    private Boolean registerComClassId;
    private String groupMoniker;
    private String hubMoniker;
    private Integer managedBy;

    public LuServerRegistration() {
        this(true);
    }

    public LuServerRegistration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "LuServerRegistration";
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.product = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.language = value;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.moniker = value;
    }

    public Integer getDefDeltaType() {
        return NONE;
    }

    public Integer getOptDeltaType() {
        return this.deltaType;
    }

    public String getOptDeltaTypeValue() throws ValidationException {
        if (this.deltaType == null) {
            return null;
        }
        String s = null;
        switch (this.deltaType) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "MDEF25";
                break;
            }
            case 2: {
                s = "MDEF25_DIRECT_DELTA_ONLY";
                break;
            }
            default: {
                throw new ValidationException("LuServerRegistration/DeltaType: invalid attribute value:" + this.deltaType + "!");
            }
        }
        return s;
    }

    public void setOptDeltaType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deltaType = value;
    }

    public void setOptDeltaTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.deltaType = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.deltaType = NONE;
        } else if ("MDEF25".equals(value)) {
            this.deltaType = MDEF25;
        } else if ("MDEF25_DIRECT_DELTA_ONLY".equals(value)) {
            this.deltaType = MDEF25_DIRECT_DELTA_ONLY;
        } else {
            throw new ValidationException("LuServerRegistration/DeltaType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptShortName() {
        return this.shortName;
    }

    public void setOptShortName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.shortName = value;
    }

    public Boolean getDefRegisterComClassId() {
        return Boolean.FALSE;
    }

    public Boolean getOptRegisterComClassId() {
        return this.registerComClassId;
    }

    public void setOptRegisterComClassId(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.registerComClassId = value;
    }

    public String getOptGroupMoniker() {
        return this.groupMoniker;
    }

    public void setOptGroupMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.groupMoniker = value;
    }

    public String getOptHubMoniker() {
        return this.hubMoniker;
    }

    public void setOptHubMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hubMoniker = value;
    }

    public Integer getDefManagedBy() {
        return UNMANAGED;
    }

    public Integer getOptManagedBy() {
        return this.managedBy;
    }

    public String getOptManagedByValue() throws ValidationException {
        if (this.managedBy == null) {
            return null;
        }
        String s = null;
        switch (this.managedBy) {
            case 0: {
                s = "DEFUTILS";
                break;
            }
            case 1: {
                s = "TEMPHOSTUTILS";
                break;
            }
            case 2: {
                s = "PATCHMANAGEMENT";
                break;
            }
            case 3: {
                s = "UNMANAGED";
                break;
            }
            default: {
                throw new ValidationException("LuServerRegistration/ManagedBy: invalid attribute value:" + this.managedBy + "!");
            }
        }
        return s;
    }

    public void setOptManagedBy(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.managedBy = value;
    }

    public void setOptManagedByValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.managedBy = null;
            return;
        }
        if ("DEFUTILS".equals(value)) {
            this.managedBy = DEFUTILS;
        } else if ("TEMPHOSTUTILS".equals(value)) {
            this.managedBy = TEMPHOSTUTILS;
        } else if ("PATCHMANAGEMENT".equals(value)) {
            this.managedBy = PATCHMANAGEMENT;
        } else if ("UNMANAGED".equals(value)) {
            this.managedBy = UNMANAGED;
        } else {
            throw new ValidationException("LuServerRegistration/ManagedBy: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 756;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.product == null) {
            throw new ValidationException("LuServerRegistration/Product: attribute is required!");
        }
        if (this.version == null) {
            throw new ValidationException("LuServerRegistration/Version: attribute is required!");
        }
        if (this.language == null) {
            throw new ValidationException("LuServerRegistration/Language: attribute is required!");
        }
        if (this.moniker == null) {
            throw new ValidationException("LuServerRegistration/Moniker: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Product");
            if (value == null) {
                throw new ValidationException("LuServerRegistration/Product: attribute is required!");
            }
            this.product = value;
            value = attris.getValue("Version");
            if (value == null) {
                throw new ValidationException("LuServerRegistration/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("Language");
            if (value == null) {
                throw new ValidationException("LuServerRegistration/Language: attribute is required!");
            }
            this.language = value;
            value = attris.getValue("Moniker");
            if (value == null) {
                throw new ValidationException("LuServerRegistration/Moniker: attribute is required!");
            }
            this.moniker = value;
            value = attris.getValue("DeltaType");
            if (value != null) {
                this.setOptDeltaTypeValue(value);
            }
            if ((value = attris.getValue("ShortName")) != null) {
                this.shortName = value;
            }
            if ((value = attris.getValue("RegisterComClassId")) != null) {
                this.registerComClassId = "1".equals(value);
            }
            if ((value = attris.getValue("GroupMoniker")) != null) {
                this.groupMoniker = value;
            }
            if ((value = attris.getValue("HubMoniker")) != null) {
                this.hubMoniker = value;
            }
            if ((value = attris.getValue("ManagedBy")) != null) {
                this.setOptManagedByValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuServerRegistration".equals(element.getNodeName())) {
            throw new ValidationException("LuServerRegistration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Product");
        if (value == null) {
            throw new ValidationException("LuServerRegistration/Product: attribute is required!");
        }
        this.product = value;
        value = XMLHelper.getAttribute(element, "Version");
        if (value == null) {
            throw new ValidationException("LuServerRegistration/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "Language");
        if (value == null) {
            throw new ValidationException("LuServerRegistration/Language: attribute is required!");
        }
        this.language = value;
        value = XMLHelper.getAttribute(element, "Moniker");
        if (value == null) {
            throw new ValidationException("LuServerRegistration/Moniker: attribute is required!");
        }
        this.moniker = value;
        value = XMLHelper.getAttribute(element, "DeltaType");
        if (value != null) {
            this.setOptDeltaTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ShortName")) != null) {
            this.shortName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RegisterComClassId")) != null) {
            this.registerComClassId = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "GroupMoniker")) != null) {
            this.groupMoniker = value;
        }
        if ((value = XMLHelper.getAttribute(element, "HubMoniker")) != null) {
            this.hubMoniker = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ManagedBy")) != null) {
            this.setOptManagedByValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuServerRegistration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuServerRegistration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuServerRegistration");
        if (this.product != null) {
            element.setAttribute("Product", this.product);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.language != null) {
            element.setAttribute("Language", this.language);
        }
        if (this.moniker != null) {
            element.setAttribute("Moniker", this.moniker);
        }
        if (this.deltaType != null) {
            element.setAttribute("DeltaType", this.getOptDeltaTypeValue());
        }
        if (this.shortName != null) {
            element.setAttribute("ShortName", this.shortName);
        }
        if (this.registerComClassId != null) {
            element.setAttribute("RegisterComClassId", this.registerComClassId != false ? "1" : "0");
        }
        if (this.groupMoniker != null) {
            element.setAttribute("GroupMoniker", this.groupMoniker);
        }
        if (this.hubMoniker != null) {
            element.setAttribute("HubMoniker", this.hubMoniker);
        }
        if (this.managedBy != null) {
            element.setAttribute("ManagedBy", this.getOptManagedByValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuServerRegistration ");
            if (this.product != null) {
                strAttrs.append("Product=\"").append(AbstractSchema.checkXMLContent(this.product)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.language != null) {
                strAttrs.append("Language=\"").append(AbstractSchema.checkXMLContent(this.language)).append("\" ");
            }
            if (this.moniker != null) {
                strAttrs.append("Moniker=\"").append(AbstractSchema.checkXMLContent(this.moniker)).append("\" ");
            }
            if (this.deltaType != null) {
                strAttrs.append("DeltaType=\"").append(this.getOptDeltaTypeValue()).append("\" ");
            }
            if (this.shortName != null) {
                strAttrs.append("ShortName=\"").append(AbstractSchema.checkXMLContent(this.shortName)).append("\" ");
            }
            if (this.registerComClassId != null) {
                strAttrs.append("RegisterComClassId=").append(this.registerComClassId != false ? "\"1\" " : "\"0\" ");
            }
            if (this.groupMoniker != null) {
                strAttrs.append("GroupMoniker=\"").append(AbstractSchema.checkXMLContent(this.groupMoniker)).append("\" ");
            }
            if (this.hubMoniker != null) {
                strAttrs.append("HubMoniker=\"").append(AbstractSchema.checkXMLContent(this.hubMoniker)).append("\" ");
            }
            if (this.managedBy != null) {
                strAttrs.append("ManagedBy=\"").append(this.getOptManagedByValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuServerRegistration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

