/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LocalizedStrings;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuServerRegistration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuRegistration
extends ConfigObject {
    public static final Integer ALL = 0;
    public static final Integer EE = 1;
    public static final Integer SBE = 2;
    public static final Integer REDUCED = 0;
    public static final Integer STANDARD = 1;
    public static final Integer ANY = 2;
    private static final long serialVersionUID = 1L;
    private Boolean suspended;
    private String targetClientPlatform;
    private Integer targetProduct;
    private Boolean obsolete;
    private Integer targetSize;

    public LuRegistration() {
        this(true);
    }

    public LuRegistration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(759, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(756, new ChildGroup(1, 1));
        this.children.put(757, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuRegistration";
    }

    public Boolean getDefSuspended() {
        return Boolean.FALSE;
    }

    public Boolean getOptSuspended() {
        return this.suspended;
    }

    public void setOptSuspended(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.suspended = value;
    }

    public String getDefTargetClientPlatform() {
        return "All";
    }

    public String getOptTargetClientPlatform() {
        return this.targetClientPlatform;
    }

    public void setOptTargetClientPlatform(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetClientPlatform = value;
    }

    public Integer getDefTargetProduct() {
        return ALL;
    }

    public Integer getOptTargetProduct() {
        return this.targetProduct;
    }

    public String getOptTargetProductValue() throws ValidationException {
        if (this.targetProduct == null) {
            return null;
        }
        String s = null;
        switch (this.targetProduct) {
            case 0: {
                s = "ALL";
                break;
            }
            case 1: {
                s = "EE";
                break;
            }
            case 2: {
                s = "SBE";
                break;
            }
            default: {
                throw new ValidationException("LuRegistration/TargetProduct: invalid attribute value:" + this.targetProduct + "!");
            }
        }
        return s;
    }

    public void setOptTargetProduct(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetProduct = value;
    }

    public void setOptTargetProductValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.targetProduct = null;
            return;
        }
        if ("ALL".equals(value)) {
            this.targetProduct = ALL;
        } else if ("EE".equals(value)) {
            this.targetProduct = EE;
        } else if ("SBE".equals(value)) {
            this.targetProduct = SBE;
        } else {
            throw new ValidationException("LuRegistration/TargetProduct: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefObsolete() {
        return Boolean.FALSE;
    }

    public Boolean getOptObsolete() {
        return this.obsolete;
    }

    public void setOptObsolete(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.obsolete = value;
    }

    public Integer getDefTargetSize() {
        return ANY;
    }

    public Integer getOptTargetSize() {
        return this.targetSize;
    }

    public String getOptTargetSizeValue() throws ValidationException {
        if (this.targetSize == null) {
            return null;
        }
        String s = null;
        switch (this.targetSize) {
            case 0: {
                s = "REDUCED";
                break;
            }
            case 1: {
                s = "STANDARD";
                break;
            }
            case 2: {
                s = "ANY";
                break;
            }
            default: {
                throw new ValidationException("LuRegistration/TargetSize: invalid attribute value:" + this.targetSize + "!");
            }
        }
        return s;
    }

    public void setOptTargetSize(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetSize = value;
    }

    public void setOptTargetSizeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.targetSize = null;
            return;
        }
        if ("REDUCED".equals(value)) {
            this.targetSize = REDUCED;
        } else if ("STANDARD".equals(value)) {
            this.targetSize = STANDARD;
        } else if ("ANY".equals(value)) {
            this.targetSize = ANY;
        } else {
            throw new ValidationException("LuRegistration/TargetSize: invalid attribute value:" + value + "!");
        }
    }

    public void addLocalizedStrings(LocalizedStrings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLocalizedStrings(int index, LocalizedStrings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LocalizedStrings> getLocalizedStrings() {
        Vector<LocalizedStrings> v = new Vector<LocalizedStrings>();
        for (Transportable child : (ChildGroup)this.children.get(759)) {
            v.add((LocalizedStrings)child);
        }
        return v;
    }

    public int getLocalizedStringsCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(759);
        return childGroup.size();
    }

    public LocalizedStrings getLocalizedStrings(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(759);
        return (LocalizedStrings)childGroup.get(index);
    }

    public void setLocalizedStrings(int index, LocalizedStrings value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLocalizedStrings(LocalizedStrings value) {
        this.removeChild(value);
    }

    public LuServerRegistration getLuServerRegistration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(756);
        if (childGroup.size() > 0) {
            return (LuServerRegistration)childGroup.get(0);
        }
        return null;
    }

    public void setLuServerRegistration(LuServerRegistration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuServerRegistration obj = this.getLuServerRegistration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuClientRegistration getOptLuClientRegistration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(757);
        if (childGroup.size() > 0) {
            return (LuClientRegistration)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuClientRegistration(LuClientRegistration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuClientRegistration obj = this.getOptLuClientRegistration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 755;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getLuServerRegistration() == null) {
            throw new ValidationException("LuRegistration/LuServerRegistration: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LocalizedStrings) {
            try {
                this.addLocalizedStrings((LocalizedStrings)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuServerRegistration) {
            try {
                this.setLuServerRegistration((LuServerRegistration)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuClientRegistration) {
            try {
                this.setOptLuClientRegistration((LuClientRegistration)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Suspended");
            if (value != null) {
                this.suspended = "1".equals(value);
            }
            if ((value = attris.getValue("TargetClientPlatform")) != null) {
                this.targetClientPlatform = value;
            }
            if ((value = attris.getValue("TargetProduct")) != null) {
                this.setOptTargetProductValue(value);
            }
            if ((value = attris.getValue("Obsolete")) != null) {
                this.obsolete = "1".equals(value);
            }
            if ((value = attris.getValue("TargetSize")) != null) {
                this.setOptTargetSizeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getLocalizedStringsCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLocalizedStrings(i).setReadonly();
        }
        if (this.getLuServerRegistration() != null) {
            this.getLuServerRegistration().setReadonly();
        }
        if (this.getOptLuClientRegistration() != null) {
            this.getOptLuClientRegistration().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(756)).size();
        }
        catch (Throwable t) {
            throw new SAXException("LuRegistration: can't import element == LuServerRegistration!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuRegistration".equals(element.getNodeName())) {
            throw new ValidationException("LuRegistration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Suspended");
        if (value != null) {
            this.suspended = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TargetClientPlatform")) != null) {
            this.targetClientPlatform = value;
        }
        if ((value = XMLHelper.getAttribute(element, "TargetProduct")) != null) {
            this.setOptTargetProductValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Obsolete")) != null) {
            this.obsolete = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TargetSize")) != null) {
            this.setOptTargetSizeValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "LocalizedStrings");
        for (int i = 0; i < v.size(); ++i) {
            LocalizedStrings localizedStringsObj = new LocalizedStrings();
            localizedStringsObj.importFromElement(v.get(i));
            this.addLocalizedStrings(localizedStringsObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuServerRegistration");
        if (v.size() != 1) {
            throw new ValidationException("LuRegistration/LuServerRegistration: element is require!");
        }
        LuServerRegistration luServerRegistrationObj = new LuServerRegistration();
        luServerRegistrationObj.importFromElement(v.get(0));
        this.setLuServerRegistration(luServerRegistrationObj);
        v = XMLHelper.getChildElementByName(element, "LuClientRegistration");
        if (v.size() > 0) {
            LuClientRegistration luClientRegistrationObj = new LuClientRegistration();
            luClientRegistrationObj.importFromElement(v.get(0));
            this.setOptLuClientRegistration(luClientRegistrationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuRegistration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuRegistration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuRegistration");
        if (this.suspended != null) {
            element.setAttribute("Suspended", this.suspended != false ? "1" : "0");
        }
        if (this.targetClientPlatform != null) {
            element.setAttribute("TargetClientPlatform", this.targetClientPlatform);
        }
        if (this.targetProduct != null) {
            element.setAttribute("TargetProduct", this.getOptTargetProductValue());
        }
        if (this.obsolete != null) {
            element.setAttribute("Obsolete", this.obsolete != false ? "1" : "0");
        }
        if (this.targetSize != null) {
            element.setAttribute("TargetSize", this.getOptTargetSizeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuRegistration ");
            if (this.suspended != null) {
                strAttrs.append("Suspended=").append(this.suspended != false ? "\"1\" " : "\"0\" ");
            }
            if (this.targetClientPlatform != null) {
                strAttrs.append("TargetClientPlatform=\"").append(AbstractSchema.checkXMLContent(this.targetClientPlatform)).append("\" ");
            }
            if (this.targetProduct != null) {
                strAttrs.append("TargetProduct=\"").append(this.getOptTargetProductValue()).append("\" ");
            }
            if (this.obsolete != null) {
                strAttrs.append("Obsolete=").append(this.obsolete != false ? "\"1\" " : "\"0\" ");
            }
            if (this.targetSize != null) {
                strAttrs.append("TargetSize=\"").append(this.getOptTargetSizeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuRegistration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

