/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SecurityFixContentInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuPackageContent
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String serverMoniker;
    private String clientMoniker;
    private String sequenceNum;
    private String sequenceTag;
    private String serverVersion;
    private String serverProduct;
    private String serverLanguage;

    public LuPackageContent() {
        this(true);
    }

    public LuPackageContent(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, 1));
        this.children.put(736, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "LuPackageContent";
    }

    public String getServerMoniker() {
        return this.serverMoniker;
    }

    public void setServerMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverMoniker = value;
    }

    public String getOptClientMoniker() {
        return this.clientMoniker;
    }

    public void setOptClientMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientMoniker = value;
    }

    public String getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sequenceNum = value;
    }

    public String getOptSequenceTag() {
        return this.sequenceTag;
    }

    public void setOptSequenceTag(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sequenceTag = value;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverVersion = value;
    }

    public String getServerProduct() {
        return this.serverProduct;
    }

    public void setServerProduct(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverProduct = value;
    }

    public String getServerLanguage() {
        return this.serverLanguage;
    }

    public void setServerLanguage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverLanguage = value;
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addSecurityFixContentInfo(SecurityFixContentInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSecurityFixContentInfo(int index, SecurityFixContentInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SecurityFixContentInfo> getSecurityFixContentInfo() {
        Vector<SecurityFixContentInfo> v = new Vector<SecurityFixContentInfo>();
        for (Transportable child : (ChildGroup)this.children.get(736)) {
            v.add((SecurityFixContentInfo)child);
        }
        return v;
    }

    public int getSecurityFixContentInfoCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(736);
        return childGroup.size();
    }

    public SecurityFixContentInfo getSecurityFixContentInfo(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(736);
        return (SecurityFixContentInfo)childGroup.get(index);
    }

    public void setSecurityFixContentInfo(int index, SecurityFixContentInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSecurityFixContentInfo(SecurityFixContentInfo value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 735;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.serverMoniker == null) {
            throw new ValidationException("LuPackageContent/ServerMoniker: attribute is required!");
        }
        if (this.sequenceNum == null) {
            throw new ValidationException("LuPackageContent/SequenceNum: attribute is required!");
        }
        if (this.serverVersion == null) {
            throw new ValidationException("LuPackageContent/ServerVersion: attribute is required!");
        }
        if (this.serverProduct == null) {
            throw new ValidationException("LuPackageContent/ServerProduct: attribute is required!");
        }
        if (this.serverLanguage == null) {
            throw new ValidationException("LuPackageContent/ServerLanguage: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("LuPackageContent/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SecurityFixContentInfo) {
            try {
                this.addSecurityFixContentInfo((SecurityFixContentInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ServerMoniker");
            if (value == null) {
                throw new ValidationException("LuPackageContent/ServerMoniker: attribute is required!");
            }
            this.serverMoniker = value;
            value = attris.getValue("ClientMoniker");
            if (value != null) {
                this.clientMoniker = value;
            }
            if ((value = attris.getValue("SequenceNum")) == null) {
                throw new ValidationException("LuPackageContent/SequenceNum: attribute is required!");
            }
            this.sequenceNum = value;
            value = attris.getValue("SequenceTag");
            if (value != null) {
                this.sequenceTag = value;
            }
            if ((value = attris.getValue("ServerVersion")) == null) {
                throw new ValidationException("LuPackageContent/ServerVersion: attribute is required!");
            }
            this.serverVersion = value;
            value = attris.getValue("ServerProduct");
            if (value == null) {
                throw new ValidationException("LuPackageContent/ServerProduct: attribute is required!");
            }
            this.serverProduct = value;
            value = attris.getValue("ServerLanguage");
            if (value == null) {
                throw new ValidationException("LuPackageContent/ServerLanguage: attribute is required!");
            }
            this.serverLanguage = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        int objCnt = this.getSecurityFixContentInfoCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSecurityFixContentInfo(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("LuPackageContent: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuPackageContent".equals(element.getNodeName())) {
            throw new ValidationException("LuPackageContent: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ServerMoniker");
        if (value == null) {
            throw new ValidationException("LuPackageContent/ServerMoniker: attribute is required!");
        }
        this.serverMoniker = value;
        value = XMLHelper.getAttribute(element, "ClientMoniker");
        if (value != null) {
            this.clientMoniker = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SequenceNum")) == null) {
            throw new ValidationException("LuPackageContent/SequenceNum: attribute is required!");
        }
        this.sequenceNum = value;
        value = XMLHelper.getAttribute(element, "SequenceTag");
        if (value != null) {
            this.sequenceTag = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ServerVersion")) == null) {
            throw new ValidationException("LuPackageContent/ServerVersion: attribute is required!");
        }
        this.serverVersion = value;
        value = XMLHelper.getAttribute(element, "ServerProduct");
        if (value == null) {
            throw new ValidationException("LuPackageContent/ServerProduct: attribute is required!");
        }
        this.serverProduct = value;
        value = XMLHelper.getAttribute(element, "ServerLanguage");
        if (value == null) {
            throw new ValidationException("LuPackageContent/ServerLanguage: attribute is required!");
        }
        this.serverLanguage = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ObjReference");
        if (v.size() != 1) {
            throw new ValidationException("LuPackageContent/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        v = XMLHelper.getChildElementByName(element, "SecurityFixContentInfo");
        for (int i = 0; i < v.size(); ++i) {
            SecurityFixContentInfo securityFixContentInfoObj = new SecurityFixContentInfo();
            securityFixContentInfoObj.importFromElement(v.get(i));
            this.addSecurityFixContentInfo(securityFixContentInfoObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuPackageContent/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuPackageContent/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuPackageContent");
        if (this.serverMoniker != null) {
            element.setAttribute("ServerMoniker", this.serverMoniker);
        }
        if (this.clientMoniker != null) {
            element.setAttribute("ClientMoniker", this.clientMoniker);
        }
        if (this.sequenceNum != null) {
            element.setAttribute("SequenceNum", this.sequenceNum);
        }
        if (this.sequenceTag != null) {
            element.setAttribute("SequenceTag", this.sequenceTag);
        }
        if (this.serverVersion != null) {
            element.setAttribute("ServerVersion", this.serverVersion);
        }
        if (this.serverProduct != null) {
            element.setAttribute("ServerProduct", this.serverProduct);
        }
        if (this.serverLanguage != null) {
            element.setAttribute("ServerLanguage", this.serverLanguage);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuPackageContent ");
            if (this.serverMoniker != null) {
                strAttrs.append("ServerMoniker=\"").append(AbstractSchema.checkXMLContent(this.serverMoniker)).append("\" ");
            }
            if (this.clientMoniker != null) {
                strAttrs.append("ClientMoniker=\"").append(AbstractSchema.checkXMLContent(this.clientMoniker)).append("\" ");
            }
            if (this.sequenceNum != null) {
                strAttrs.append("SequenceNum=\"").append(AbstractSchema.checkXMLContent(this.sequenceNum)).append("\" ");
            }
            if (this.sequenceTag != null) {
                strAttrs.append("SequenceTag=\"").append(AbstractSchema.checkXMLContent(this.sequenceTag)).append("\" ");
            }
            if (this.serverVersion != null) {
                strAttrs.append("ServerVersion=\"").append(AbstractSchema.checkXMLContent(this.serverVersion)).append("\" ");
            }
            if (this.serverProduct != null) {
                strAttrs.append("ServerProduct=\"").append(AbstractSchema.checkXMLContent(this.serverProduct)).append("\" ");
            }
            if (this.serverLanguage != null) {
                strAttrs.append("ServerLanguage=\"").append(AbstractSchema.checkXMLContent(this.serverLanguage)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuPackageContent>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

