/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuHttpsProxy
extends ConfigObject {
    public static final Integer NONE = 0;
    public static final Integer SYSTEM = 1;
    public static final Integer CUSTOM = 2;
    public static final Integer BASIC = 0;
    public static final Integer NTLM = 1;
    private static final long serialVersionUID = 1L;
    private Integer mode;
    private Boolean lockMode;
    private String host;
    private String port;
    private Boolean requireAuthentication;
    private Integer authenticationType;
    private String userName;
    private String password;
    private String ntlmUserName;
    private String ntlmPassword;
    private String ntlmDomainName;

    public LuHttpsProxy() {
        this(true);
    }

    public LuHttpsProxy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "LuHttpsProxy";
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "SYSTEM";
                break;
            }
            case 2: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("LuHttpsProxy/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NONE".equals(value)) {
            this.mode = NONE;
        } else if ("SYSTEM".equals(value)) {
            this.mode = SYSTEM;
        } else if ("CUSTOM".equals(value)) {
            this.mode = CUSTOM;
        } else {
            throw new ValidationException("LuHttpsProxy/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockMode() {
        return this.lockMode;
    }

    public void setOptLockMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockMode = value;
    }

    public String getOptHost() {
        return this.host;
    }

    public void setOptHost(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.host = value;
    }

    public String getOptPort() {
        return this.port;
    }

    public void setOptPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public Boolean getDefRequireAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireAuthentication() {
        return this.requireAuthentication;
    }

    public void setOptRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.requireAuthentication = value;
    }

    public Integer getDefAuthenticationType() {
        return BASIC;
    }

    public Integer getOptAuthenticationType() {
        return this.authenticationType;
    }

    public String getOptAuthenticationTypeValue() throws ValidationException {
        if (this.authenticationType == null) {
            return null;
        }
        String s = null;
        switch (this.authenticationType) {
            case 0: {
                s = "BASIC";
                break;
            }
            case 1: {
                s = "NTLM";
                break;
            }
            default: {
                throw new ValidationException("LuHttpsProxy/AuthenticationType: invalid attribute value:" + this.authenticationType + "!");
            }
        }
        return s;
    }

    public void setOptAuthenticationType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authenticationType = value;
    }

    public void setOptAuthenticationTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.authenticationType = null;
            return;
        }
        if ("BASIC".equals(value)) {
            this.authenticationType = BASIC;
        } else if ("NTLM".equals(value)) {
            this.authenticationType = NTLM;
        } else {
            throw new ValidationException("LuHttpsProxy/AuthenticationType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userName = value;
    }

    public String getOptPassword() {
        try {
            return Utility.decrypt(this.password);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.password = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOptNtlmUserName() {
        return this.ntlmUserName;
    }

    public void setOptNtlmUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.ntlmUserName = value;
    }

    public String getOptNtlmPassword() {
        try {
            return Utility.decrypt(this.ntlmPassword);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptNtlmPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.ntlmPassword = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOptNtlmDomainName() {
        return this.ntlmDomainName;
    }

    public void setOptNtlmDomainName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.ntlmDomainName = value;
    }

    @Override
    public int getObjectType() {
        return 712;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.mode == null) {
            throw new ValidationException("LuHttpsProxy/Mode: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value == null) {
                throw new ValidationException("LuHttpsProxy/Mode: attribute is required!");
            }
            this.setModeValue(value);
            value = attris.getValue("LockMode");
            if (value != null) {
                this.lockMode = "1".equals(value);
            }
            if ((value = attris.getValue("Host")) != null) {
                this.host = value;
            }
            if ((value = attris.getValue("Port")) != null) {
                this.port = value;
            }
            if ((value = attris.getValue("RequireAuthentication")) != null) {
                this.requireAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("AuthenticationType")) != null) {
                this.setOptAuthenticationTypeValue(value);
            }
            if ((value = attris.getValue("UserName")) != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("NtlmUserName")) != null) {
                this.ntlmUserName = value;
            }
            if ((value = attris.getValue("NtlmPassword")) != null) {
                this.ntlmPassword = value;
            }
            if ((value = attris.getValue("NtlmDomainName")) != null) {
                this.ntlmDomainName = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuHttpsProxy".equals(element.getNodeName())) {
            throw new ValidationException("LuHttpsProxy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value == null) {
            throw new ValidationException("LuHttpsProxy/Mode: attribute is required!");
        }
        this.setModeValue(value);
        value = XMLHelper.getAttribute(element, "LockMode");
        if (value != null) {
            this.lockMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Host")) != null) {
            this.host = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            this.port = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RequireAuthentication")) != null) {
            this.requireAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AuthenticationType")) != null) {
            this.setOptAuthenticationTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserName")) != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmUserName")) != null) {
            this.ntlmUserName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmPassword")) != null) {
            this.ntlmPassword = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmDomainName")) != null) {
            this.ntlmDomainName = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuHttpsProxy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuHttpsProxy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuHttpsProxy");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getModeValue());
        }
        if (this.lockMode != null) {
            element.setAttribute("LockMode", this.lockMode != false ? "1" : "0");
        }
        if (this.host != null) {
            element.setAttribute("Host", this.host);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port);
        }
        if (this.requireAuthentication != null) {
            element.setAttribute("RequireAuthentication", this.requireAuthentication != false ? "1" : "0");
        }
        if (this.authenticationType != null) {
            element.setAttribute("AuthenticationType", this.getOptAuthenticationTypeValue());
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.ntlmUserName != null) {
            element.setAttribute("NtlmUserName", this.ntlmUserName);
        }
        if (this.ntlmPassword != null) {
            element.setAttribute("NtlmPassword", this.ntlmPassword);
        }
        if (this.ntlmDomainName != null) {
            element.setAttribute("NtlmDomainName", this.ntlmDomainName);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuHttpsProxy ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getModeValue()).append("\" ");
            }
            if (this.lockMode != null) {
                strAttrs.append("LockMode=").append(this.lockMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.host != null) {
                strAttrs.append("Host=\"").append(AbstractSchema.checkXMLContent(this.host)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(AbstractSchema.checkXMLContent(this.port)).append("\" ");
            }
            if (this.requireAuthentication != null) {
                strAttrs.append("RequireAuthentication=").append(this.requireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.authenticationType != null) {
                strAttrs.append("AuthenticationType=\"").append(this.getOptAuthenticationTypeValue()).append("\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.ntlmUserName != null) {
                strAttrs.append("NtlmUserName=\"").append(AbstractSchema.checkXMLContent(this.ntlmUserName)).append("\" ");
            }
            if (this.ntlmPassword != null) {
                strAttrs.append("NtlmPassword=\"").append(AbstractSchema.checkXMLContent(this.ntlmPassword)).append("\" ");
            }
            if (this.ntlmDomainName != null) {
                strAttrs.append("NtlmDomainName=\"").append(AbstractSchema.checkXMLContent(this.ntlmDomainName)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuHttpsProxy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

