/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuGeneralConfig
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean allowLocalScheduleChange;
    private Boolean allowManualLiveUpdate;
    private Boolean allowLocalProxySettingChange;
    private Boolean allowPatchByLiveUpdate;
    private Boolean standardHttpHeaders;
    private Boolean allowClientPatchDownload;
    private Boolean useLiveUpdateServerForSmallerAVContentPackages;

    public LuGeneralConfig() {
        this(true);
    }

    public LuGeneralConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "LuGeneralConfig";
    }

    public Boolean getDefAllowLocalScheduleChange() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowLocalScheduleChange() {
        return this.allowLocalScheduleChange;
    }

    public void setOptAllowLocalScheduleChange(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowLocalScheduleChange = value;
    }

    public Boolean getDefAllowManualLiveUpdate() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowManualLiveUpdate() {
        return this.allowManualLiveUpdate;
    }

    public void setOptAllowManualLiveUpdate(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowManualLiveUpdate = value;
    }

    public Boolean getDefAllowLocalProxySettingChange() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowLocalProxySettingChange() {
        return this.allowLocalProxySettingChange;
    }

    public void setOptAllowLocalProxySettingChange(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowLocalProxySettingChange = value;
    }

    public Boolean getDefAllowPatchByLiveUpdate() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowPatchByLiveUpdate() {
        return this.allowPatchByLiveUpdate;
    }

    public void setOptAllowPatchByLiveUpdate(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowPatchByLiveUpdate = value;
    }

    public Boolean getDefStandardHttpHeaders() {
        return Boolean.TRUE;
    }

    public Boolean getOptStandardHttpHeaders() {
        return this.standardHttpHeaders;
    }

    public void setOptStandardHttpHeaders(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.standardHttpHeaders = value;
    }

    public Boolean getDefAllowClientPatchDownload() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowClientPatchDownload() {
        return this.allowClientPatchDownload;
    }

    public void setOptAllowClientPatchDownload(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowClientPatchDownload = value;
    }

    public Boolean getDefUseLiveUpdateServerForSmallerAVContentPackages() {
        return Boolean.TRUE;
    }

    public Boolean getOptUseLiveUpdateServerForSmallerAVContentPackages() {
        return this.useLiveUpdateServerForSmallerAVContentPackages;
    }

    public void setOptUseLiveUpdateServerForSmallerAVContentPackages(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useLiveUpdateServerForSmallerAVContentPackages = value;
    }

    @Override
    public int getObjectType() {
        return 729;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AllowLocalScheduleChange");
            if (value != null) {
                this.allowLocalScheduleChange = "1".equals(value);
            }
            if ((value = attris.getValue("AllowManualLiveUpdate")) != null) {
                this.allowManualLiveUpdate = "1".equals(value);
            }
            if ((value = attris.getValue("AllowLocalProxySettingChange")) != null) {
                this.allowLocalProxySettingChange = "1".equals(value);
            }
            if ((value = attris.getValue("AllowPatchByLiveUpdate")) != null) {
                this.allowPatchByLiveUpdate = "1".equals(value);
            }
            if ((value = attris.getValue("StandardHttpHeaders")) != null) {
                this.standardHttpHeaders = "1".equals(value);
            }
            if ((value = attris.getValue("AllowClientPatchDownload")) != null) {
                this.allowClientPatchDownload = "1".equals(value);
            }
            if ((value = attris.getValue("UseLiveUpdateServerForSmallerAVContentPackages")) != null) {
                this.useLiveUpdateServerForSmallerAVContentPackages = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuGeneralConfig".equals(element.getNodeName())) {
            throw new ValidationException("LuGeneralConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AllowLocalScheduleChange");
        if (value != null) {
            this.allowLocalScheduleChange = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowManualLiveUpdate")) != null) {
            this.allowManualLiveUpdate = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowLocalProxySettingChange")) != null) {
            this.allowLocalProxySettingChange = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowPatchByLiveUpdate")) != null) {
            this.allowPatchByLiveUpdate = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "StandardHttpHeaders")) != null) {
            this.standardHttpHeaders = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowClientPatchDownload")) != null) {
            this.allowClientPatchDownload = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UseLiveUpdateServerForSmallerAVContentPackages")) != null) {
            this.useLiveUpdateServerForSmallerAVContentPackages = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuGeneralConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuGeneralConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuGeneralConfig");
        if (this.allowLocalScheduleChange != null) {
            element.setAttribute("AllowLocalScheduleChange", this.allowLocalScheduleChange != false ? "1" : "0");
        }
        if (this.allowManualLiveUpdate != null) {
            element.setAttribute("AllowManualLiveUpdate", this.allowManualLiveUpdate != false ? "1" : "0");
        }
        if (this.allowLocalProxySettingChange != null) {
            element.setAttribute("AllowLocalProxySettingChange", this.allowLocalProxySettingChange != false ? "1" : "0");
        }
        if (this.allowPatchByLiveUpdate != null) {
            element.setAttribute("AllowPatchByLiveUpdate", this.allowPatchByLiveUpdate != false ? "1" : "0");
        }
        if (this.standardHttpHeaders != null) {
            element.setAttribute("StandardHttpHeaders", this.standardHttpHeaders != false ? "1" : "0");
        }
        if (this.allowClientPatchDownload != null) {
            element.setAttribute("AllowClientPatchDownload", this.allowClientPatchDownload != false ? "1" : "0");
        }
        if (this.useLiveUpdateServerForSmallerAVContentPackages != null) {
            element.setAttribute("UseLiveUpdateServerForSmallerAVContentPackages", this.useLiveUpdateServerForSmallerAVContentPackages != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuGeneralConfig ");
            if (this.allowLocalScheduleChange != null) {
                strAttrs.append("AllowLocalScheduleChange=").append(this.allowLocalScheduleChange != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowManualLiveUpdate != null) {
                strAttrs.append("AllowManualLiveUpdate=").append(this.allowManualLiveUpdate != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowLocalProxySettingChange != null) {
                strAttrs.append("AllowLocalProxySettingChange=").append(this.allowLocalProxySettingChange != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowPatchByLiveUpdate != null) {
                strAttrs.append("AllowPatchByLiveUpdate=").append(this.allowPatchByLiveUpdate != false ? "\"1\" " : "\"0\" ");
            }
            if (this.standardHttpHeaders != null) {
                strAttrs.append("StandardHttpHeaders=").append(this.standardHttpHeaders != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowClientPatchDownload != null) {
                strAttrs.append("AllowClientPatchDownload=").append(this.allowClientPatchDownload != false ? "\"1\" " : "\"0\" ");
            }
            if (this.useLiveUpdateServerForSmallerAVContentPackages != null) {
                strAttrs.append("UseLiveUpdateServerForSmallerAVContentPackages=").append(this.useLiveUpdateServerForSmallerAVContentPackages != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuGeneralConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

