/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.FullFileInfo;
import com.sygate.scm.common.configobject.schema.IncrementalForwardDelta;
import com.sygate.scm.common.configobject.schema.IncrementalReverseDelta;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuDownloadedContent
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer HI = 1;
    public static final Integer SECURITY_FIX = 2;
    private static final long serialVersionUID = 1L;
    private String serverMoniker;
    private String clientMoniker;
    private String sequenceNum;
    private String engineNum;
    private String sequenceTag;
    private Integer type;
    private Boolean distributable;

    public LuDownloadedContent() {
        this(true);
    }

    public LuDownloadedContent(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(0, 1));
        this.children.put(182, new ChildGroup(0, 1));
        this.children.put(733, new ChildGroup(0, 1));
        this.children.put(734, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuDownloadedContent";
    }

    public String getServerMoniker() {
        return this.serverMoniker;
    }

    public void setServerMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverMoniker = value;
    }

    public String getOptClientMoniker() {
        return this.clientMoniker;
    }

    public void setOptClientMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientMoniker = value;
    }

    public String getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sequenceNum = value;
    }

    public String getOptEngineNum() {
        return this.engineNum;
    }

    public void setOptEngineNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.engineNum = value;
    }

    public String getOptSequenceTag() {
        return this.sequenceTag;
    }

    public void setOptSequenceTag(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sequenceTag = value;
    }

    public Integer getDefType() {
        return NORMAL;
    }

    public Integer getOptType() {
        return this.type;
    }

    public String getOptTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "HI";
                break;
            }
            case 2: {
                s = "SECURITY_FIX";
                break;
            }
            default: {
                throw new ValidationException("LuDownloadedContent/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setOptType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    public void setOptTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.type = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.type = NORMAL;
        } else if ("HI".equals(value)) {
            this.type = HI;
        } else if ("SECURITY_FIX".equals(value)) {
            this.type = SECURITY_FIX;
        } else {
            throw new ValidationException("LuDownloadedContent/Type: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefDistributable() {
        return Boolean.TRUE;
    }

    public Boolean getOptDistributable() {
        return this.distributable;
    }

    public void setOptDistributable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.distributable = value;
    }

    public ObjReference getOptObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setOptObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getOptObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public FullFileInfo getOptFullFileInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(182);
        if (childGroup.size() > 0) {
            return (FullFileInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptFullFileInfo(FullFileInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FullFileInfo obj = this.getOptFullFileInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public IncrementalForwardDelta getOptIncrementalForwardDelta() {
        ChildGroup childGroup = (ChildGroup)this.children.get(733);
        if (childGroup.size() > 0) {
            return (IncrementalForwardDelta)childGroup.get(0);
        }
        return null;
    }

    public void setOptIncrementalForwardDelta(IncrementalForwardDelta value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IncrementalForwardDelta obj = this.getOptIncrementalForwardDelta();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public IncrementalReverseDelta getOptIncrementalReverseDelta() {
        ChildGroup childGroup = (ChildGroup)this.children.get(734);
        if (childGroup.size() > 0) {
            return (IncrementalReverseDelta)childGroup.get(0);
        }
        return null;
    }

    public void setOptIncrementalReverseDelta(IncrementalReverseDelta value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IncrementalReverseDelta obj = this.getOptIncrementalReverseDelta();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 732;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.serverMoniker == null) {
            throw new ValidationException("LuDownloadedContent/ServerMoniker: attribute is required!");
        }
        if (this.sequenceNum == null) {
            throw new ValidationException("LuDownloadedContent/SequenceNum: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setOptObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof FullFileInfo) {
            try {
                this.setOptFullFileInfo((FullFileInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IncrementalForwardDelta) {
            try {
                this.setOptIncrementalForwardDelta((IncrementalForwardDelta)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IncrementalReverseDelta) {
            try {
                this.setOptIncrementalReverseDelta((IncrementalReverseDelta)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ServerMoniker");
            if (value == null) {
                throw new ValidationException("LuDownloadedContent/ServerMoniker: attribute is required!");
            }
            this.serverMoniker = value;
            value = attris.getValue("ClientMoniker");
            if (value != null) {
                this.clientMoniker = value;
            }
            if ((value = attris.getValue("SequenceNum")) == null) {
                throw new ValidationException("LuDownloadedContent/SequenceNum: attribute is required!");
            }
            this.sequenceNum = value;
            value = attris.getValue("EngineNum");
            if (value != null) {
                this.engineNum = value;
            }
            if ((value = attris.getValue("SequenceTag")) != null) {
                this.sequenceTag = value;
            }
            if ((value = attris.getValue("Type")) != null) {
                this.setOptTypeValue(value);
            }
            if ((value = attris.getValue("Distributable")) != null) {
                this.distributable = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptObjReference() != null) {
            this.getOptObjReference().setReadonly();
        }
        if (this.getOptFullFileInfo() != null) {
            this.getOptFullFileInfo().setReadonly();
        }
        if (this.getOptIncrementalForwardDelta() != null) {
            this.getOptIncrementalForwardDelta().setReadonly();
        }
        if (this.getOptIncrementalReverseDelta() != null) {
            this.getOptIncrementalReverseDelta().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"LuDownloadedContent".equals(element.getNodeName())) {
            throw new ValidationException("LuDownloadedContent: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ServerMoniker");
        if (value == null) {
            throw new ValidationException("LuDownloadedContent/ServerMoniker: attribute is required!");
        }
        this.serverMoniker = value;
        value = XMLHelper.getAttribute(element, "ClientMoniker");
        if (value != null) {
            this.clientMoniker = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SequenceNum")) == null) {
            throw new ValidationException("LuDownloadedContent/SequenceNum: attribute is required!");
        }
        this.sequenceNum = value;
        value = XMLHelper.getAttribute(element, "EngineNum");
        if (value != null) {
            this.engineNum = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SequenceTag")) != null) {
            this.sequenceTag = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Type")) != null) {
            this.setOptTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Distributable")) != null) {
            this.distributable = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() > 0) {
            ObjReference objReferenceObj = new ObjReference();
            objReferenceObj.importFromElement(v.get(0));
            this.setOptObjReference(objReferenceObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "FullFileInfo")).size() > 0) {
            FullFileInfo fullFileInfoObj = new FullFileInfo();
            fullFileInfoObj.importFromElement(v.get(0));
            this.setOptFullFileInfo(fullFileInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IncrementalForwardDelta")).size() > 0) {
            IncrementalForwardDelta incrementalForwardDeltaObj = new IncrementalForwardDelta();
            incrementalForwardDeltaObj.importFromElement(v.get(0));
            this.setOptIncrementalForwardDelta(incrementalForwardDeltaObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IncrementalReverseDelta")).size() > 0) {
            IncrementalReverseDelta incrementalReverseDeltaObj = new IncrementalReverseDelta();
            incrementalReverseDeltaObj.importFromElement(v.get(0));
            this.setOptIncrementalReverseDelta(incrementalReverseDeltaObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuDownloadedContent/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuDownloadedContent/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuDownloadedContent");
        if (this.serverMoniker != null) {
            element.setAttribute("ServerMoniker", this.serverMoniker);
        }
        if (this.clientMoniker != null) {
            element.setAttribute("ClientMoniker", this.clientMoniker);
        }
        if (this.sequenceNum != null) {
            element.setAttribute("SequenceNum", this.sequenceNum);
        }
        if (this.engineNum != null) {
            element.setAttribute("EngineNum", this.engineNum);
        }
        if (this.sequenceTag != null) {
            element.setAttribute("SequenceTag", this.sequenceTag);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.getOptTypeValue());
        }
        if (this.distributable != null) {
            element.setAttribute("Distributable", this.distributable != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuDownloadedContent ");
            if (this.serverMoniker != null) {
                strAttrs.append("ServerMoniker=\"").append(AbstractSchema.checkXMLContent(this.serverMoniker)).append("\" ");
            }
            if (this.clientMoniker != null) {
                strAttrs.append("ClientMoniker=\"").append(AbstractSchema.checkXMLContent(this.clientMoniker)).append("\" ");
            }
            if (this.sequenceNum != null) {
                strAttrs.append("SequenceNum=\"").append(AbstractSchema.checkXMLContent(this.sequenceNum)).append("\" ");
            }
            if (this.engineNum != null) {
                strAttrs.append("EngineNum=\"").append(AbstractSchema.checkXMLContent(this.engineNum)).append("\" ");
            }
            if (this.sequenceTag != null) {
                strAttrs.append("SequenceTag=\"").append(AbstractSchema.checkXMLContent(this.sequenceTag)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getOptTypeValue()).append("\" ");
            }
            if (this.distributable != null) {
                strAttrs.append("Distributable=").append(this.distributable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuDownloadedContent>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

