/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LUScheduleAdditionalOptions;
import com.sygate.scm.common.configobject.schema.LuDownloadRandomness;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuDownloadSchedule
extends ConfigObject {
    public static final Integer CONTINUOUS = 0;
    public static final Integer HOURLY = 1;
    public static final Integer DAILY = 2;
    public static final Integer WEEKLY = 3;
    public static final Integer SUNDAY = 0;
    public static final Integer MONDAY = 1;
    public static final Integer TUESDAY = 2;
    public static final Integer WEDNESDAY = 3;
    public static final Integer THURSDAY = 4;
    public static final Integer FRIDAY = 5;
    public static final Integer SATURDA = 6;
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Integer frequency;
    private Integer frequencyInterval;
    private Boolean specifyTimeRange;
    private Long startTime;
    private Long endTime;
    private Integer dayOfWeek;
    private Boolean allowRetry;
    private Integer retryWindow;
    private Integer retryInterval;
    private Boolean isChangedByConsole;
    private Boolean idleDetection;

    public LuDownloadSchedule() {
        this(true);
    }

    public LuDownloadSchedule(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(725, new ChildGroup(0, 1));
        this.children.put(726, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuDownloadSchedule";
    }

    public Boolean getDefEnabled() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public Integer getDefFrequency() {
        return HOURLY;
    }

    public Integer getOptFrequency() {
        return this.frequency;
    }

    public String getOptFrequencyValue() throws ValidationException {
        if (this.frequency == null) {
            return null;
        }
        String s = null;
        switch (this.frequency) {
            case 0: {
                s = "CONTINUOUS";
                break;
            }
            case 1: {
                s = "HOURLY";
                break;
            }
            case 2: {
                s = "DAILY";
                break;
            }
            case 3: {
                s = "WEEKLY";
                break;
            }
            default: {
                throw new ValidationException("LuDownloadSchedule/Frequency: invalid attribute value:" + this.frequency + "!");
            }
        }
        return s;
    }

    public void setOptFrequency(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.frequency = value;
    }

    public void setOptFrequencyValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.frequency = null;
            return;
        }
        if ("CONTINUOUS".equals(value)) {
            this.frequency = CONTINUOUS;
        } else if ("HOURLY".equals(value)) {
            this.frequency = HOURLY;
        } else if ("DAILY".equals(value)) {
            this.frequency = DAILY;
        } else if ("WEEKLY".equals(value)) {
            this.frequency = WEEKLY;
        } else {
            throw new ValidationException("LuDownloadSchedule/Frequency: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefFrequencyInterval() {
        return 240;
    }

    public Integer getOptFrequencyInterval() {
        return this.frequencyInterval;
    }

    public void setOptFrequencyInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.frequencyInterval = value;
    }

    public Boolean getOptSpecifyTimeRange() {
        return this.specifyTimeRange;
    }

    public void setOptSpecifyTimeRange(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.specifyTimeRange = value;
    }

    public Long getOptStartTime() {
        return this.startTime;
    }

    public void setOptStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startTime = value;
    }

    public Long getOptEndTime() {
        return this.endTime;
    }

    public void setOptEndTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.endTime = value;
    }

    public Integer getOptDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getOptDayOfWeekValue() throws ValidationException {
        if (this.dayOfWeek == null) {
            return null;
        }
        String s = null;
        switch (this.dayOfWeek) {
            case 0: {
                s = "SUNDAY";
                break;
            }
            case 1: {
                s = "MONDAY";
                break;
            }
            case 2: {
                s = "TUESDAY";
                break;
            }
            case 3: {
                s = "WEDNESDAY";
                break;
            }
            case 4: {
                s = "THURSDAY";
                break;
            }
            case 5: {
                s = "FRIDAY";
                break;
            }
            case 6: {
                s = "SATURDA";
                break;
            }
            default: {
                throw new ValidationException("LuDownloadSchedule/DayOfWeek: invalid attribute value:" + this.dayOfWeek + "!");
            }
        }
        return s;
    }

    public void setOptDayOfWeek(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dayOfWeek = value;
    }

    public void setOptDayOfWeekValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.dayOfWeek = null;
            return;
        }
        if ("SUNDAY".equals(value)) {
            this.dayOfWeek = SUNDAY;
        } else if ("MONDAY".equals(value)) {
            this.dayOfWeek = MONDAY;
        } else if ("TUESDAY".equals(value)) {
            this.dayOfWeek = TUESDAY;
        } else if ("WEDNESDAY".equals(value)) {
            this.dayOfWeek = WEDNESDAY;
        } else if ("THURSDAY".equals(value)) {
            this.dayOfWeek = THURSDAY;
        } else if ("FRIDAY".equals(value)) {
            this.dayOfWeek = FRIDAY;
        } else if ("SATURDA".equals(value)) {
            this.dayOfWeek = SATURDA;
        } else {
            throw new ValidationException("LuDownloadSchedule/DayOfWeek: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefAllowRetry() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowRetry() {
        return this.allowRetry;
    }

    public void setOptAllowRetry(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowRetry = value;
    }

    public Integer getDefRetryWindow() {
        return 1;
    }

    public Integer getOptRetryWindow() {
        return this.retryWindow;
    }

    public void setOptRetryWindow(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.retryWindow = value;
    }

    public Integer getDefRetryInterval() {
        return 15;
    }

    public Integer getOptRetryInterval() {
        return this.retryInterval;
    }

    public void setOptRetryInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.retryInterval = value;
    }

    public Boolean getDefIsChangedByConsole() {
        return Boolean.FALSE;
    }

    public Boolean getOptIsChangedByConsole() {
        return this.isChangedByConsole;
    }

    public void setOptIsChangedByConsole(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.isChangedByConsole = value;
    }

    public Boolean getDefIdleDetection() {
        return Boolean.TRUE;
    }

    public Boolean getOptIdleDetection() {
        return this.idleDetection;
    }

    public void setOptIdleDetection(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.idleDetection = value;
    }

    public LuDownloadRandomness getOptLuDownloadRandomness() {
        ChildGroup childGroup = (ChildGroup)this.children.get(725);
        if (childGroup.size() > 0) {
            return (LuDownloadRandomness)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuDownloadRandomness(LuDownloadRandomness value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuDownloadRandomness obj = this.getOptLuDownloadRandomness();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LUScheduleAdditionalOptions getOptLUScheduleAdditionalOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(726);
        if (childGroup.size() > 0) {
            return (LUScheduleAdditionalOptions)childGroup.get(0);
        }
        return null;
    }

    public void setOptLUScheduleAdditionalOptions(LUScheduleAdditionalOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LUScheduleAdditionalOptions obj = this.getOptLUScheduleAdditionalOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 724;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LuDownloadRandomness) {
            try {
                this.setOptLuDownloadRandomness((LuDownloadRandomness)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LUScheduleAdditionalOptions) {
            try {
                this.setOptLUScheduleAdditionalOptions((LUScheduleAdditionalOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("Frequency")) != null) {
                this.setOptFrequencyValue(value);
            }
            if ((value = attris.getValue("FrequencyInterval")) != null) {
                try {
                    this.frequencyInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuDownloadSchedule/FrequencyInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuDownloadSchedule/FrequencyInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SpecifyTimeRange")) != null) {
                this.specifyTimeRange = "1".equals(value);
            }
            if ((value = attris.getValue("StartTime")) != null) {
                try {
                    this.startTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuDownloadSchedule/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuDownloadSchedule/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("EndTime")) != null) {
                try {
                    this.endTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuDownloadSchedule/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuDownloadSchedule/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DayOfWeek")) != null) {
                this.setOptDayOfWeekValue(value);
            }
            if ((value = attris.getValue("AllowRetry")) != null) {
                this.allowRetry = "1".equals(value);
            }
            if ((value = attris.getValue("RetryWindow")) != null) {
                try {
                    this.retryWindow = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuDownloadSchedule/RetryWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuDownloadSchedule/RetryWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RetryInterval")) != null) {
                try {
                    this.retryInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuDownloadSchedule/RetryInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuDownloadSchedule/RetryInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("IsChangedByConsole")) != null) {
                this.isChangedByConsole = "1".equals(value);
            }
            if ((value = attris.getValue("IdleDetection")) != null) {
                this.idleDetection = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptLuDownloadRandomness() != null) {
            this.getOptLuDownloadRandomness().setReadonly();
        }
        if (this.getOptLUScheduleAdditionalOptions() != null) {
            this.getOptLUScheduleAdditionalOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"LuDownloadSchedule".equals(element.getNodeName())) {
            throw new ValidationException("LuDownloadSchedule: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Frequency")) != null) {
            this.setOptFrequencyValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "FrequencyInterval")) != null) {
            try {
                this.frequencyInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuDownloadSchedule/FrequencyInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SpecifyTimeRange")) != null) {
            this.specifyTimeRange = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "StartTime")) != null) {
            try {
                this.startTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuDownloadSchedule/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EndTime")) != null) {
            try {
                this.endTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuDownloadSchedule/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DayOfWeek")) != null) {
            this.setOptDayOfWeekValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowRetry")) != null) {
            this.allowRetry = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RetryWindow")) != null) {
            try {
                this.retryWindow = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuDownloadSchedule/RetryWindow: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RetryInterval")) != null) {
            try {
                this.retryInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuDownloadSchedule/RetryInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "IsChangedByConsole")) != null) {
            this.isChangedByConsole = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "IdleDetection")) != null) {
            this.idleDetection = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuDownloadRandomness")).size() > 0) {
            LuDownloadRandomness luDownloadRandomnessObj = new LuDownloadRandomness();
            luDownloadRandomnessObj.importFromElement(v.get(0));
            this.setOptLuDownloadRandomness(luDownloadRandomnessObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LUScheduleAdditionalOptions")).size() > 0) {
            LUScheduleAdditionalOptions lUScheduleAdditionalOptionsObj = new LUScheduleAdditionalOptions();
            lUScheduleAdditionalOptionsObj.importFromElement(v.get(0));
            this.setOptLUScheduleAdditionalOptions(lUScheduleAdditionalOptionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuDownloadSchedule/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuDownloadSchedule/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuDownloadSchedule");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.frequency != null) {
            element.setAttribute("Frequency", this.getOptFrequencyValue());
        }
        if (this.frequencyInterval != null) {
            element.setAttribute("FrequencyInterval", this.frequencyInterval.toString());
        }
        if (this.specifyTimeRange != null) {
            element.setAttribute("SpecifyTimeRange", this.specifyTimeRange != false ? "1" : "0");
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.endTime != null) {
            element.setAttribute("EndTime", this.endTime.toString());
        }
        if (this.dayOfWeek != null) {
            element.setAttribute("DayOfWeek", this.getOptDayOfWeekValue());
        }
        if (this.allowRetry != null) {
            element.setAttribute("AllowRetry", this.allowRetry != false ? "1" : "0");
        }
        if (this.retryWindow != null) {
            element.setAttribute("RetryWindow", this.retryWindow.toString());
        }
        if (this.retryInterval != null) {
            element.setAttribute("RetryInterval", this.retryInterval.toString());
        }
        if (this.isChangedByConsole != null) {
            element.setAttribute("IsChangedByConsole", this.isChangedByConsole != false ? "1" : "0");
        }
        if (this.idleDetection != null) {
            element.setAttribute("IdleDetection", this.idleDetection != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuDownloadSchedule ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.frequency != null) {
                strAttrs.append("Frequency=\"").append(this.getOptFrequencyValue()).append("\" ");
            }
            if (this.frequencyInterval != null) {
                strAttrs.append("FrequencyInterval=\"").append(this.frequencyInterval.toString()).append("\" ");
            }
            if (this.specifyTimeRange != null) {
                strAttrs.append("SpecifyTimeRange=").append(this.specifyTimeRange != false ? "\"1\" " : "\"0\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(this.startTime.toString()).append("\" ");
            }
            if (this.endTime != null) {
                strAttrs.append("EndTime=\"").append(this.endTime.toString()).append("\" ");
            }
            if (this.dayOfWeek != null) {
                strAttrs.append("DayOfWeek=\"").append(this.getOptDayOfWeekValue()).append("\" ");
            }
            if (this.allowRetry != null) {
                strAttrs.append("AllowRetry=").append(this.allowRetry != false ? "\"1\" " : "\"0\" ");
            }
            if (this.retryWindow != null) {
                strAttrs.append("RetryWindow=\"").append(this.retryWindow.toString()).append("\" ");
            }
            if (this.retryInterval != null) {
                strAttrs.append("RetryInterval=\"").append(this.retryInterval.toString()).append("\" ");
            }
            if (this.isChangedByConsole != null) {
                strAttrs.append("IsChangedByConsole=").append(this.isChangedByConsole != false ? "\"1\" " : "\"0\" ");
            }
            if (this.idleDetection != null) {
                strAttrs.append("IdleDetection=").append(this.idleDetection != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuDownloadSchedule>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

