/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.ExplicitGupMapping;
import com.sygate.scm.common.configobject.schema.GupRuleSets;
import com.sygate.scm.common.configobject.schema.LuFtpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuContentSourceInfo
extends ConfigObject {
    public static final Integer SYMANTEC = 0;
    public static final Integer INTERNAL = 1;
    public static final Integer EAS = 2;
    public static final Integer ACTIVE = 0;
    public static final Integer PASSIVE = 1;
    private static final long serialVersionUID = 1L;
    private Boolean useManagementServer;
    private Boolean useLiveUpdateServer;
    private Integer liveUpdateServerType;
    private Boolean useMasterClient;
    private String masterClientHost;
    private String masterClientPort;
    private Boolean staticGupSelected;
    private Boolean dynamicGupSelected;
    private Boolean explicitGupSelected;
    private Long masterClientBypassTime;
    private Integer masterClientMaxDiskCache;
    private Long masterClientDeleteUnusedContentsTime;
    private Integer masterClientThreadCount;
    private Integer masterClientThrottling;
    private Integer clientThrottling;
    private Boolean enabled3rdPartyManagement;
    private Integer fTPMode;
    private Boolean httpsTrusted;
    private Boolean legacyLuaSupport;

    public LuContentSourceInfo() {
        this(true);
    }

    public LuContentSourceInfo(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(710, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(711, new ChildGroup(0, 1));
        this.children.put(713, new ChildGroup(0, 1));
        this.children.put(716, new ChildGroup(0, 1));
        this.children.put(718, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuContentSourceInfo";
    }

    public Boolean getDefUseManagementServer() {
        return Boolean.TRUE;
    }

    public Boolean getOptUseManagementServer() {
        return this.useManagementServer;
    }

    public void setOptUseManagementServer(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useManagementServer = value;
    }

    public Boolean getDefUseLiveUpdateServer() {
        return Boolean.FALSE;
    }

    public Boolean getOptUseLiveUpdateServer() {
        return this.useLiveUpdateServer;
    }

    public void setOptUseLiveUpdateServer(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useLiveUpdateServer = value;
    }

    public Integer getDefLiveUpdateServerType() {
        return SYMANTEC;
    }

    public Integer getOptLiveUpdateServerType() {
        return this.liveUpdateServerType;
    }

    public String getOptLiveUpdateServerTypeValue() throws ValidationException {
        if (this.liveUpdateServerType == null) {
            return null;
        }
        String s = null;
        switch (this.liveUpdateServerType) {
            case 0: {
                s = "SYMANTEC";
                break;
            }
            case 1: {
                s = "INTERNAL";
                break;
            }
            case 2: {
                s = "EAS";
                break;
            }
            default: {
                throw new ValidationException("LuContentSourceInfo/LiveUpdateServerType: invalid attribute value:" + this.liveUpdateServerType + "!");
            }
        }
        return s;
    }

    public void setOptLiveUpdateServerType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.liveUpdateServerType = value;
    }

    public void setOptLiveUpdateServerTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.liveUpdateServerType = null;
            return;
        }
        if ("SYMANTEC".equals(value)) {
            this.liveUpdateServerType = SYMANTEC;
        } else if ("INTERNAL".equals(value)) {
            this.liveUpdateServerType = INTERNAL;
        } else if ("EAS".equals(value)) {
            this.liveUpdateServerType = EAS;
        } else {
            throw new ValidationException("LuContentSourceInfo/LiveUpdateServerType: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefUseMasterClient() {
        return Boolean.FALSE;
    }

    public Boolean getOptUseMasterClient() {
        return this.useMasterClient;
    }

    public void setOptUseMasterClient(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useMasterClient = value;
    }

    public String getDefMasterClientHost() {
        return "";
    }

    public String getOptMasterClientHost() {
        return this.masterClientHost;
    }

    public void setOptMasterClientHost(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientHost = value;
    }

    public String getDefMasterClientPort() {
        return "2967";
    }

    public String getOptMasterClientPort() {
        return this.masterClientPort;
    }

    public void setOptMasterClientPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientPort = value;
    }

    public Boolean getDefStaticGupSelected() {
        return Boolean.FALSE;
    }

    public Boolean getOptStaticGupSelected() {
        return this.staticGupSelected;
    }

    public void setOptStaticGupSelected(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.staticGupSelected = value;
    }

    public Boolean getDefDynamicGupSelected() {
        return Boolean.FALSE;
    }

    public Boolean getOptDynamicGupSelected() {
        return this.dynamicGupSelected;
    }

    public void setOptDynamicGupSelected(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dynamicGupSelected = value;
    }

    public Boolean getDefExplicitGupSelected() {
        return Boolean.FALSE;
    }

    public Boolean getOptExplicitGupSelected() {
        return this.explicitGupSelected;
    }

    public void setOptExplicitGupSelected(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.explicitGupSelected = value;
    }

    public Long getDefMasterClientBypassTime() {
        return -1L;
    }

    public Long getOptMasterClientBypassTime() {
        return this.masterClientBypassTime;
    }

    public void setOptMasterClientBypassTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientBypassTime = value;
    }

    public Integer getDefMasterClientMaxDiskCache() {
        return 2000;
    }

    public Integer getOptMasterClientMaxDiskCache() {
        return this.masterClientMaxDiskCache;
    }

    public void setOptMasterClientMaxDiskCache(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientMaxDiskCache = value;
    }

    public Long getDefMasterClientDeleteUnusedContentsTime() {
        return 259200L;
    }

    public Long getOptMasterClientDeleteUnusedContentsTime() {
        return this.masterClientDeleteUnusedContentsTime;
    }

    public void setOptMasterClientDeleteUnusedContentsTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientDeleteUnusedContentsTime = value;
    }

    public Integer getDefMasterClientThreadCount() {
        return 10;
    }

    public Integer getOptMasterClientThreadCount() {
        return this.masterClientThreadCount;
    }

    public void setOptMasterClientThreadCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientThreadCount = value;
    }

    public Integer getDefMasterClientThrottling() {
        return -1;
    }

    public Integer getOptMasterClientThrottling() {
        return this.masterClientThrottling;
    }

    public void setOptMasterClientThrottling(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.masterClientThrottling = value;
    }

    public Integer getDefClientThrottling() {
        return -1;
    }

    public Integer getOptClientThrottling() {
        return this.clientThrottling;
    }

    public void setOptClientThrottling(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientThrottling = value;
    }

    public Boolean getDefEnabled3rdPartyManagement() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabled3rdPartyManagement() {
        return this.enabled3rdPartyManagement;
    }

    public void setOptEnabled3rdPartyManagement(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled3rdPartyManagement = value;
    }

    public Integer getDefFTPMode() {
        return ACTIVE;
    }

    public Integer getOptFTPMode() {
        return this.fTPMode;
    }

    public String getOptFTPModeValue() throws ValidationException {
        if (this.fTPMode == null) {
            return null;
        }
        String s = null;
        switch (this.fTPMode) {
            case 0: {
                s = "ACTIVE";
                break;
            }
            case 1: {
                s = "PASSIVE";
                break;
            }
            default: {
                throw new ValidationException("LuContentSourceInfo/FTPMode: invalid attribute value:" + this.fTPMode + "!");
            }
        }
        return s;
    }

    public void setOptFTPMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fTPMode = value;
    }

    public void setOptFTPModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.fTPMode = null;
            return;
        }
        if ("ACTIVE".equals(value)) {
            this.fTPMode = ACTIVE;
        } else if ("PASSIVE".equals(value)) {
            this.fTPMode = PASSIVE;
        } else {
            throw new ValidationException("LuContentSourceInfo/FTPMode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefHttpsTrusted() {
        return Boolean.TRUE;
    }

    public Boolean getOptHttpsTrusted() {
        return this.httpsTrusted;
    }

    public void setOptHttpsTrusted(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.httpsTrusted = value;
    }

    public Boolean getDefLegacyLuaSupport() {
        return Boolean.FALSE;
    }

    public Boolean getOptLegacyLuaSupport() {
        return this.legacyLuaSupport;
    }

    public void setOptLegacyLuaSupport(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.legacyLuaSupport = value;
    }

    public void addCentralLuServer(CentralLuServer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addCentralLuServer(int index, CentralLuServer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<CentralLuServer> getCentralLuServer() {
        Vector<CentralLuServer> v = new Vector<CentralLuServer>();
        for (Transportable child : (ChildGroup)this.children.get(710)) {
            v.add((CentralLuServer)child);
        }
        return v;
    }

    public int getCentralLuServerCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(710);
        return childGroup.size();
    }

    public CentralLuServer getCentralLuServer(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(710);
        return (CentralLuServer)childGroup.get(index);
    }

    public void setCentralLuServer(int index, CentralLuServer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeCentralLuServer(CentralLuServer value) {
        this.removeChild(value);
    }

    public LuHttpProxy getOptLuHttpProxy() {
        ChildGroup childGroup = (ChildGroup)this.children.get(711);
        if (childGroup.size() > 0) {
            return (LuHttpProxy)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuHttpProxy(LuHttpProxy value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuHttpProxy obj = this.getOptLuHttpProxy();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuFtpProxy getOptLuFtpProxy() {
        ChildGroup childGroup = (ChildGroup)this.children.get(713);
        if (childGroup.size() > 0) {
            return (LuFtpProxy)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuFtpProxy(LuFtpProxy value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuFtpProxy obj = this.getOptLuFtpProxy();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public GupRuleSets getOptGupRuleSets() {
        ChildGroup childGroup = (ChildGroup)this.children.get(716);
        if (childGroup.size() > 0) {
            return (GupRuleSets)childGroup.get(0);
        }
        return null;
    }

    public void setOptGupRuleSets(GupRuleSets value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            GupRuleSets obj = this.getOptGupRuleSets();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ExplicitGupMapping getOptExplicitGupMapping() {
        ChildGroup childGroup = (ChildGroup)this.children.get(718);
        if (childGroup.size() > 0) {
            return (ExplicitGupMapping)childGroup.get(0);
        }
        return null;
    }

    public void setOptExplicitGupMapping(ExplicitGupMapping value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ExplicitGupMapping obj = this.getOptExplicitGupMapping();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 709;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof CentralLuServer) {
            try {
                this.addCentralLuServer((CentralLuServer)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuHttpProxy) {
            try {
                this.setOptLuHttpProxy((LuHttpProxy)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuFtpProxy) {
            try {
                this.setOptLuFtpProxy((LuFtpProxy)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof GupRuleSets) {
            try {
                this.setOptGupRuleSets((GupRuleSets)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ExplicitGupMapping) {
            try {
                this.setOptExplicitGupMapping((ExplicitGupMapping)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("UseManagementServer");
            if (value != null) {
                this.useManagementServer = "1".equals(value);
            }
            if ((value = attris.getValue("UseLiveUpdateServer")) != null) {
                this.useLiveUpdateServer = "1".equals(value);
            }
            if ((value = attris.getValue("LiveUpdateServerType")) != null) {
                this.setOptLiveUpdateServerTypeValue(value);
            }
            if ((value = attris.getValue("UseMasterClient")) != null) {
                this.useMasterClient = "1".equals(value);
            }
            if ((value = attris.getValue("MasterClientHost")) != null) {
                this.masterClientHost = value;
            }
            if ((value = attris.getValue("MasterClientPort")) != null) {
                this.masterClientPort = value;
            }
            if ((value = attris.getValue("StaticGupSelected")) != null) {
                this.staticGupSelected = "1".equals(value);
            }
            if ((value = attris.getValue("DynamicGupSelected")) != null) {
                this.dynamicGupSelected = "1".equals(value);
            }
            if ((value = attris.getValue("ExplicitGupSelected")) != null) {
                this.explicitGupSelected = "1".equals(value);
            }
            if ((value = attris.getValue("MasterClientBypassTime")) != null) {
                try {
                    this.masterClientBypassTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientBypassTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientBypassTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("MasterClientMaxDiskCache")) != null) {
                try {
                    this.masterClientMaxDiskCache = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientMaxDiskCache: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientMaxDiskCache: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("MasterClientDeleteUnusedContentsTime")) != null) {
                try {
                    this.masterClientDeleteUnusedContentsTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientDeleteUnusedContentsTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientDeleteUnusedContentsTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("MasterClientThreadCount")) != null) {
                try {
                    this.masterClientThreadCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientThreadCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientThreadCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("MasterClientThrottling")) != null) {
                try {
                    this.masterClientThrottling = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/MasterClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ClientThrottling")) != null) {
                try {
                    this.clientThrottling = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuContentSourceInfo/ClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuContentSourceInfo/ClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Enabled3rdPartyManagement")) != null) {
                this.enabled3rdPartyManagement = "1".equals(value);
            }
            if ((value = attris.getValue("FTPMode")) != null) {
                this.setOptFTPModeValue(value);
            }
            if ((value = attris.getValue("HttpsTrusted")) != null) {
                this.httpsTrusted = "1".equals(value);
            }
            if ((value = attris.getValue("LegacyLuaSupport")) != null) {
                this.legacyLuaSupport = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getCentralLuServerCount();
        for (i = 0; i < objCnt; ++i) {
            this.getCentralLuServer(i).setReadonly();
        }
        if (this.getOptLuHttpProxy() != null) {
            this.getOptLuHttpProxy().setReadonly();
        }
        if (this.getOptLuFtpProxy() != null) {
            this.getOptLuFtpProxy().setReadonly();
        }
        if (this.getOptGupRuleSets() != null) {
            this.getOptGupRuleSets().setReadonly();
        }
        if (this.getOptExplicitGupMapping() != null) {
            this.getOptExplicitGupMapping().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuContentSourceInfo".equals(element.getNodeName())) {
            throw new ValidationException("LuContentSourceInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "UseManagementServer");
        if (value != null) {
            this.useManagementServer = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UseLiveUpdateServer")) != null) {
            this.useLiveUpdateServer = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LiveUpdateServerType")) != null) {
            this.setOptLiveUpdateServerTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UseMasterClient")) != null) {
            this.useMasterClient = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientHost")) != null) {
            this.masterClientHost = value;
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientPort")) != null) {
            this.masterClientPort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "StaticGupSelected")) != null) {
            this.staticGupSelected = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DynamicGupSelected")) != null) {
            this.dynamicGupSelected = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ExplicitGupSelected")) != null) {
            this.explicitGupSelected = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientBypassTime")) != null) {
            try {
                this.masterClientBypassTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/MasterClientBypassTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientMaxDiskCache")) != null) {
            try {
                this.masterClientMaxDiskCache = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/MasterClientMaxDiskCache: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientDeleteUnusedContentsTime")) != null) {
            try {
                this.masterClientDeleteUnusedContentsTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/MasterClientDeleteUnusedContentsTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientThreadCount")) != null) {
            try {
                this.masterClientThreadCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/MasterClientThreadCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MasterClientThrottling")) != null) {
            try {
                this.masterClientThrottling = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/MasterClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ClientThrottling")) != null) {
            try {
                this.clientThrottling = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuContentSourceInfo/ClientThrottling: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Enabled3rdPartyManagement")) != null) {
            this.enabled3rdPartyManagement = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "FTPMode")) != null) {
            this.setOptFTPModeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsTrusted")) != null) {
            this.httpsTrusted = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LegacyLuaSupport")) != null) {
            this.legacyLuaSupport = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "CentralLuServer");
        for (int i = 0; i < v.size(); ++i) {
            CentralLuServer centralLuServerObj = new CentralLuServer();
            centralLuServerObj.importFromElement(v.get(i));
            this.addCentralLuServer(centralLuServerObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuHttpProxy");
        if (v.size() > 0) {
            LuHttpProxy luHttpProxyObj = new LuHttpProxy();
            luHttpProxyObj.importFromElement(v.get(0));
            this.setOptLuHttpProxy(luHttpProxyObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuFtpProxy")).size() > 0) {
            LuFtpProxy luFtpProxyObj = new LuFtpProxy();
            luFtpProxyObj.importFromElement(v.get(0));
            this.setOptLuFtpProxy(luFtpProxyObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "GupRuleSets")).size() > 0) {
            GupRuleSets gupRuleSetsObj = new GupRuleSets();
            gupRuleSetsObj.importFromElement(v.get(0));
            this.setOptGupRuleSets(gupRuleSetsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ExplicitGupMapping")).size() > 0) {
            ExplicitGupMapping explicitGupMappingObj = new ExplicitGupMapping();
            explicitGupMappingObj.importFromElement(v.get(0));
            this.setOptExplicitGupMapping(explicitGupMappingObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuContentSourceInfo/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuContentSourceInfo/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuContentSourceInfo");
        if (this.useManagementServer != null) {
            element.setAttribute("UseManagementServer", this.useManagementServer != false ? "1" : "0");
        }
        if (this.useLiveUpdateServer != null) {
            element.setAttribute("UseLiveUpdateServer", this.useLiveUpdateServer != false ? "1" : "0");
        }
        if (this.liveUpdateServerType != null) {
            element.setAttribute("LiveUpdateServerType", this.getOptLiveUpdateServerTypeValue());
        }
        if (this.useMasterClient != null) {
            element.setAttribute("UseMasterClient", this.useMasterClient != false ? "1" : "0");
        }
        if (this.masterClientHost != null) {
            element.setAttribute("MasterClientHost", this.masterClientHost);
        }
        if (this.masterClientPort != null) {
            element.setAttribute("MasterClientPort", this.masterClientPort);
        }
        if (this.staticGupSelected != null) {
            element.setAttribute("StaticGupSelected", this.staticGupSelected != false ? "1" : "0");
        }
        if (this.dynamicGupSelected != null) {
            element.setAttribute("DynamicGupSelected", this.dynamicGupSelected != false ? "1" : "0");
        }
        if (this.explicitGupSelected != null) {
            element.setAttribute("ExplicitGupSelected", this.explicitGupSelected != false ? "1" : "0");
        }
        if (this.masterClientBypassTime != null) {
            element.setAttribute("MasterClientBypassTime", this.masterClientBypassTime.toString());
        }
        if (this.masterClientMaxDiskCache != null) {
            element.setAttribute("MasterClientMaxDiskCache", this.masterClientMaxDiskCache.toString());
        }
        if (this.masterClientDeleteUnusedContentsTime != null) {
            element.setAttribute("MasterClientDeleteUnusedContentsTime", this.masterClientDeleteUnusedContentsTime.toString());
        }
        if (this.masterClientThreadCount != null) {
            element.setAttribute("MasterClientThreadCount", this.masterClientThreadCount.toString());
        }
        if (this.masterClientThrottling != null) {
            element.setAttribute("MasterClientThrottling", this.masterClientThrottling.toString());
        }
        if (this.clientThrottling != null) {
            element.setAttribute("ClientThrottling", this.clientThrottling.toString());
        }
        if (this.enabled3rdPartyManagement != null) {
            element.setAttribute("Enabled3rdPartyManagement", this.enabled3rdPartyManagement != false ? "1" : "0");
        }
        if (this.fTPMode != null) {
            element.setAttribute("FTPMode", this.getOptFTPModeValue());
        }
        if (this.httpsTrusted != null) {
            element.setAttribute("HttpsTrusted", this.httpsTrusted != false ? "1" : "0");
        }
        if (this.legacyLuaSupport != null) {
            element.setAttribute("LegacyLuaSupport", this.legacyLuaSupport != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuContentSourceInfo ");
            if (this.useManagementServer != null) {
                strAttrs.append("UseManagementServer=").append(this.useManagementServer != false ? "\"1\" " : "\"0\" ");
            }
            if (this.useLiveUpdateServer != null) {
                strAttrs.append("UseLiveUpdateServer=").append(this.useLiveUpdateServer != false ? "\"1\" " : "\"0\" ");
            }
            if (this.liveUpdateServerType != null) {
                strAttrs.append("LiveUpdateServerType=\"").append(this.getOptLiveUpdateServerTypeValue()).append("\" ");
            }
            if (this.useMasterClient != null) {
                strAttrs.append("UseMasterClient=").append(this.useMasterClient != false ? "\"1\" " : "\"0\" ");
            }
            if (this.masterClientHost != null) {
                strAttrs.append("MasterClientHost=\"").append(AbstractSchema.checkXMLContent(this.masterClientHost)).append("\" ");
            }
            if (this.masterClientPort != null) {
                strAttrs.append("MasterClientPort=\"").append(AbstractSchema.checkXMLContent(this.masterClientPort)).append("\" ");
            }
            if (this.staticGupSelected != null) {
                strAttrs.append("StaticGupSelected=").append(this.staticGupSelected != false ? "\"1\" " : "\"0\" ");
            }
            if (this.dynamicGupSelected != null) {
                strAttrs.append("DynamicGupSelected=").append(this.dynamicGupSelected != false ? "\"1\" " : "\"0\" ");
            }
            if (this.explicitGupSelected != null) {
                strAttrs.append("ExplicitGupSelected=").append(this.explicitGupSelected != false ? "\"1\" " : "\"0\" ");
            }
            if (this.masterClientBypassTime != null) {
                strAttrs.append("MasterClientBypassTime=\"").append(this.masterClientBypassTime.toString()).append("\" ");
            }
            if (this.masterClientMaxDiskCache != null) {
                strAttrs.append("MasterClientMaxDiskCache=\"").append(this.masterClientMaxDiskCache.toString()).append("\" ");
            }
            if (this.masterClientDeleteUnusedContentsTime != null) {
                strAttrs.append("MasterClientDeleteUnusedContentsTime=\"").append(this.masterClientDeleteUnusedContentsTime.toString()).append("\" ");
            }
            if (this.masterClientThreadCount != null) {
                strAttrs.append("MasterClientThreadCount=\"").append(this.masterClientThreadCount.toString()).append("\" ");
            }
            if (this.masterClientThrottling != null) {
                strAttrs.append("MasterClientThrottling=\"").append(this.masterClientThrottling.toString()).append("\" ");
            }
            if (this.clientThrottling != null) {
                strAttrs.append("ClientThrottling=\"").append(this.clientThrottling.toString()).append("\" ");
            }
            if (this.enabled3rdPartyManagement != null) {
                strAttrs.append("Enabled3rdPartyManagement=").append(this.enabled3rdPartyManagement != false ? "\"1\" " : "\"0\" ");
            }
            if (this.fTPMode != null) {
                strAttrs.append("FTPMode=\"").append(this.getOptFTPModeValue()).append("\" ");
            }
            if (this.httpsTrusted != null) {
                strAttrs.append("HttpsTrusted=").append(this.httpsTrusted != false ? "\"1\" " : "\"0\" ");
            }
            if (this.legacyLuaSupport != null) {
                strAttrs.append("LegacyLuaSupport=").append(this.legacyLuaSupport != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuContentSourceInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

