/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LuCategories;
import com.sygate.scm.common.configobject.schema.LuCategoryName;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelections;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatforms;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuConfig
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer numberOfRevisions;
    private Boolean extractFullPackage;

    public LuConfig() {
        this(true);
    }

    public LuConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(724, new ChildGroup(0, 1));
        this.children.put(741, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(742, new ChildGroup(0, 1));
        this.children.put(750, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(709, new ChildGroup(0, 1));
        this.children.put(746, new ChildGroup(0, 1));
        this.children.put(748, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuConfig";
    }

    public Integer getDefNumberOfRevisions() {
        String productType = System.getProperty("Spc.Product.Type", "");
        return "SEPSB".equals(productType) ? Integer.valueOf(12) : Integer.valueOf(42);
    }

    public Integer getOptNumberOfRevisions() {
        return this.numberOfRevisions;
    }

    public void setOptNumberOfRevisions(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.numberOfRevisions = value;
    }

    public Boolean getDefExtractFullPackage() {
        return Boolean.FALSE;
    }

    public Boolean getOptExtractFullPackage() {
        return this.extractFullPackage;
    }

    public void setOptExtractFullPackage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.extractFullPackage = value;
    }

    public LuDownloadSchedule getOptLuDownloadSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(724);
        if (childGroup.size() > 0) {
            return (LuDownloadSchedule)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuDownloadSchedule(LuDownloadSchedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuDownloadSchedule obj = this.getOptLuDownloadSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addLuCategoryName(LuCategoryName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLuCategoryName(int index, LuCategoryName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LuCategoryName> getLuCategoryName() {
        Vector<LuCategoryName> v = new Vector<LuCategoryName>();
        for (Transportable child : (ChildGroup)this.children.get(741)) {
            v.add((LuCategoryName)child);
        }
        return v;
    }

    public int getLuCategoryNameCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(741);
        return childGroup.size();
    }

    public LuCategoryName getLuCategoryName(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(741);
        return (LuCategoryName)childGroup.get(index);
    }

    public void setLuCategoryName(int index, LuCategoryName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLuCategoryName(LuCategoryName value) {
        this.removeChild(value);
    }

    public LuCategories getOptLuCategories() {
        ChildGroup childGroup = (ChildGroup)this.children.get(742);
        if (childGroup.size() > 0) {
            return (LuCategories)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuCategories(LuCategories value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuCategories obj = this.getOptLuCategories();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addLuSupportLanguage(LuSupportLanguage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLuSupportLanguage(int index, LuSupportLanguage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LuSupportLanguage> getLuSupportLanguage() {
        Vector<LuSupportLanguage> v = new Vector<LuSupportLanguage>();
        for (Transportable child : (ChildGroup)this.children.get(750)) {
            v.add((LuSupportLanguage)child);
        }
        return v;
    }

    public int getLuSupportLanguageCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(750);
        return childGroup.size();
    }

    public LuSupportLanguage getLuSupportLanguage(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(750);
        return (LuSupportLanguage)childGroup.get(index);
    }

    public void setLuSupportLanguage(int index, LuSupportLanguage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLuSupportLanguage(LuSupportLanguage value) {
        this.removeChild(value);
    }

    public LuContentSourceInfo getOptLuContentSourceInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(709);
        if (childGroup.size() > 0) {
            return (LuContentSourceInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuContentSourceInfo(LuContentSourceInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuContentSourceInfo obj = this.getOptLuContentSourceInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuSupportedClientPlatforms getOptLuSupportedClientPlatforms() {
        ChildGroup childGroup = (ChildGroup)this.children.get(746);
        if (childGroup.size() > 0) {
            return (LuSupportedClientPlatforms)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuSupportedClientPlatforms(LuSupportedClientPlatforms value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuSupportedClientPlatforms obj = this.getOptLuSupportedClientPlatforms();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuContentSizeSelections getOptLuContentSizeSelections() {
        ChildGroup childGroup = (ChildGroup)this.children.get(748);
        if (childGroup.size() > 0) {
            return (LuContentSizeSelections)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuContentSizeSelections(LuContentSizeSelections value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuContentSizeSelections obj = this.getOptLuContentSizeSelections();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 740;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LuDownloadSchedule) {
            try {
                this.setOptLuDownloadSchedule((LuDownloadSchedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuCategoryName) {
            try {
                this.addLuCategoryName((LuCategoryName)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuCategories) {
            try {
                this.setOptLuCategories((LuCategories)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuSupportLanguage) {
            try {
                this.addLuSupportLanguage((LuSupportLanguage)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuContentSourceInfo) {
            try {
                this.setOptLuContentSourceInfo((LuContentSourceInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuSupportedClientPlatforms) {
            try {
                this.setOptLuSupportedClientPlatforms((LuSupportedClientPlatforms)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuContentSizeSelections) {
            try {
                this.setOptLuContentSizeSelections((LuContentSizeSelections)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("NumberOfRevisions");
            if (value != null) {
                try {
                    this.numberOfRevisions = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LuConfig/NumberOfRevisions: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LuConfig/NumberOfRevisions: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ExtractFullPackage")) != null) {
                this.extractFullPackage = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getOptLuDownloadSchedule() != null) {
            this.getOptLuDownloadSchedule().setReadonly();
        }
        int objCnt = this.getLuCategoryNameCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLuCategoryName(i).setReadonly();
        }
        if (this.getOptLuCategories() != null) {
            this.getOptLuCategories().setReadonly();
        }
        objCnt = this.getLuSupportLanguageCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLuSupportLanguage(i).setReadonly();
        }
        if (this.getOptLuContentSourceInfo() != null) {
            this.getOptLuContentSourceInfo().setReadonly();
        }
        if (this.getOptLuSupportedClientPlatforms() != null) {
            this.getOptLuSupportedClientPlatforms().setReadonly();
        }
        if (this.getOptLuContentSizeSelections() != null) {
            this.getOptLuContentSizeSelections().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"LuConfig".equals(element.getNodeName())) {
            throw new ValidationException("LuConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "NumberOfRevisions");
        if (value != null) {
            try {
                this.numberOfRevisions = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LuConfig/NumberOfRevisions: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ExtractFullPackage")) != null) {
            this.extractFullPackage = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuDownloadSchedule")).size() > 0) {
            LuDownloadSchedule luDownloadScheduleObj = new LuDownloadSchedule();
            luDownloadScheduleObj.importFromElement(v.get(0));
            this.setOptLuDownloadSchedule(luDownloadScheduleObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuCategoryName");
        for (int i = 0; i < v.size(); ++i) {
            LuCategoryName luCategoryNameObj = new LuCategoryName();
            luCategoryNameObj.importFromElement(v.get(i));
            this.addLuCategoryName(luCategoryNameObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuCategories");
        if (v.size() > 0) {
            LuCategories luCategoriesObj = new LuCategories();
            luCategoriesObj.importFromElement(v.get(0));
            this.setOptLuCategories(luCategoriesObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuSupportLanguage");
        for (int i = 0; i < v.size(); ++i) {
            LuSupportLanguage luSupportLanguageObj = new LuSupportLanguage();
            luSupportLanguageObj.importFromElement(v.get(i));
            this.addLuSupportLanguage(luSupportLanguageObj);
        }
        v = XMLHelper.getChildElementByName(element, "LuContentSourceInfo");
        if (v.size() > 0) {
            LuContentSourceInfo luContentSourceInfoObj = new LuContentSourceInfo();
            luContentSourceInfoObj.importFromElement(v.get(0));
            this.setOptLuContentSourceInfo(luContentSourceInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuSupportedClientPlatforms")).size() > 0) {
            LuSupportedClientPlatforms luSupportedClientPlatformsObj = new LuSupportedClientPlatforms();
            luSupportedClientPlatformsObj.importFromElement(v.get(0));
            this.setOptLuSupportedClientPlatforms(luSupportedClientPlatformsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuContentSizeSelections")).size() > 0) {
            LuContentSizeSelections luContentSizeSelectionsObj = new LuContentSizeSelections();
            luContentSizeSelectionsObj.importFromElement(v.get(0));
            this.setOptLuContentSizeSelections(luContentSizeSelectionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuConfig");
        if (this.numberOfRevisions != null) {
            element.setAttribute("NumberOfRevisions", this.numberOfRevisions.toString());
        }
        if (this.extractFullPackage != null) {
            element.setAttribute("ExtractFullPackage", this.extractFullPackage != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuConfig ");
            if (this.numberOfRevisions != null) {
                strAttrs.append("NumberOfRevisions=\"").append(this.numberOfRevisions.toString()).append("\" ");
            }
            if (this.extractFullPackage != null) {
                strAttrs.append("ExtractFullPackage=").append(this.extractFullPackage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

