/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ClientDeltaSupport;
import com.sygate.scm.common.configobject.schema.GenerationIDs;
import com.sygate.scm.common.configobject.schema.LegacyMoniker;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuClientRegistration
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String product;
    private String version;
    private String language;
    private String moniker;

    public LuClientRegistration() {
        this(true);
    }

    public LuClientRegistration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(761, new ChildGroup(0, 1));
        this.children.put(758, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(760, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LuClientRegistration";
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.product = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.language = value;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.moniker = value;
    }

    public ClientDeltaSupport getOptClientDeltaSupport() {
        ChildGroup childGroup = (ChildGroup)this.children.get(761);
        if (childGroup.size() > 0) {
            return (ClientDeltaSupport)childGroup.get(0);
        }
        return null;
    }

    public void setOptClientDeltaSupport(ClientDeltaSupport value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ClientDeltaSupport obj = this.getOptClientDeltaSupport();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addLegacyMoniker(LegacyMoniker value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLegacyMoniker(int index, LegacyMoniker value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LegacyMoniker> getLegacyMoniker() {
        Vector<LegacyMoniker> v = new Vector<LegacyMoniker>();
        for (Transportable child : (ChildGroup)this.children.get(758)) {
            v.add((LegacyMoniker)child);
        }
        return v;
    }

    public int getLegacyMonikerCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(758);
        return childGroup.size();
    }

    public LegacyMoniker getLegacyMoniker(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(758);
        return (LegacyMoniker)childGroup.get(index);
    }

    public void setLegacyMoniker(int index, LegacyMoniker value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLegacyMoniker(LegacyMoniker value) {
        this.removeChild(value);
    }

    public GenerationIDs getOptGenerationIDs() {
        ChildGroup childGroup = (ChildGroup)this.children.get(760);
        if (childGroup.size() > 0) {
            return (GenerationIDs)childGroup.get(0);
        }
        return null;
    }

    public void setOptGenerationIDs(GenerationIDs value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            GenerationIDs obj = this.getOptGenerationIDs();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 757;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.product == null) {
            throw new ValidationException("LuClientRegistration/Product: attribute is required!");
        }
        if (this.version == null) {
            throw new ValidationException("LuClientRegistration/Version: attribute is required!");
        }
        if (this.language == null) {
            throw new ValidationException("LuClientRegistration/Language: attribute is required!");
        }
        if (this.moniker == null) {
            throw new ValidationException("LuClientRegistration/Moniker: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ClientDeltaSupport) {
            try {
                this.setOptClientDeltaSupport((ClientDeltaSupport)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LegacyMoniker) {
            try {
                this.addLegacyMoniker((LegacyMoniker)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof GenerationIDs) {
            try {
                this.setOptGenerationIDs((GenerationIDs)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Product");
            if (value == null) {
                throw new ValidationException("LuClientRegistration/Product: attribute is required!");
            }
            this.product = value;
            value = attris.getValue("Version");
            if (value == null) {
                throw new ValidationException("LuClientRegistration/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("Language");
            if (value == null) {
                throw new ValidationException("LuClientRegistration/Language: attribute is required!");
            }
            this.language = value;
            value = attris.getValue("Moniker");
            if (value == null) {
                throw new ValidationException("LuClientRegistration/Moniker: attribute is required!");
            }
            this.moniker = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getOptClientDeltaSupport() != null) {
            this.getOptClientDeltaSupport().setReadonly();
        }
        int objCnt = this.getLegacyMonikerCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLegacyMoniker(i).setReadonly();
        }
        if (this.getOptGenerationIDs() != null) {
            this.getOptGenerationIDs().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuClientRegistration".equals(element.getNodeName())) {
            throw new ValidationException("LuClientRegistration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Product");
        if (value == null) {
            throw new ValidationException("LuClientRegistration/Product: attribute is required!");
        }
        this.product = value;
        value = XMLHelper.getAttribute(element, "Version");
        if (value == null) {
            throw new ValidationException("LuClientRegistration/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "Language");
        if (value == null) {
            throw new ValidationException("LuClientRegistration/Language: attribute is required!");
        }
        this.language = value;
        value = XMLHelper.getAttribute(element, "Moniker");
        if (value == null) {
            throw new ValidationException("LuClientRegistration/Moniker: attribute is required!");
        }
        this.moniker = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ClientDeltaSupport");
        if (v.size() > 0) {
            ClientDeltaSupport clientDeltaSupportObj = new ClientDeltaSupport();
            clientDeltaSupportObj.importFromElement(v.get(0));
            this.setOptClientDeltaSupport(clientDeltaSupportObj);
        }
        v = XMLHelper.getChildElementByName(element, "LegacyMoniker");
        for (int i = 0; i < v.size(); ++i) {
            LegacyMoniker legacyMonikerObj = new LegacyMoniker();
            legacyMonikerObj.importFromElement(v.get(i));
            this.addLegacyMoniker(legacyMonikerObj);
        }
        v = XMLHelper.getChildElementByName(element, "GenerationIDs");
        if (v.size() > 0) {
            GenerationIDs generationIDsObj = new GenerationIDs();
            generationIDsObj.importFromElement(v.get(0));
            this.setOptGenerationIDs(generationIDsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuClientRegistration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuClientRegistration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuClientRegistration");
        if (this.product != null) {
            element.setAttribute("Product", this.product);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.language != null) {
            element.setAttribute("Language", this.language);
        }
        if (this.moniker != null) {
            element.setAttribute("Moniker", this.moniker);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuClientRegistration ");
            if (this.product != null) {
                strAttrs.append("Product=\"").append(AbstractSchema.checkXMLContent(this.product)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.language != null) {
                strAttrs.append("Language=\"").append(AbstractSchema.checkXMLContent(this.language)).append("\" ");
            }
            if (this.moniker != null) {
                strAttrs.append("Moniker=\"").append(AbstractSchema.checkXMLContent(this.moniker)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuClientRegistration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

