/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuAppliedContent
extends ConfigObject {
    public static final Integer LATEST = 0;
    public static final Integer NAMEDVERSION = 1;
    public static final Integer ENGINEVERSION = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private String contentCategory;
    private Integer versionSelectionType;

    public LuAppliedContent() {
        this(true);
    }

    public LuAppliedContent(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(730, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "LuAppliedContent";
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public String getContentCategory() {
        return this.contentCategory;
    }

    public void setContentCategory(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.contentCategory = value;
    }

    public Integer getDefVersionSelectionType() {
        return LATEST;
    }

    public Integer getOptVersionSelectionType() {
        return this.versionSelectionType;
    }

    public String getOptVersionSelectionTypeValue() throws ValidationException {
        if (this.versionSelectionType == null) {
            return null;
        }
        String s = null;
        switch (this.versionSelectionType) {
            case 0: {
                s = "LATEST";
                break;
            }
            case 1: {
                s = "NAMEDVERSION";
                break;
            }
            case 2: {
                s = "ENGINEVERSION";
                break;
            }
            default: {
                throw new ValidationException("LuAppliedContent/VersionSelectionType: invalid attribute value:" + this.versionSelectionType + "!");
            }
        }
        return s;
    }

    public void setOptVersionSelectionType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.versionSelectionType = value;
    }

    public void setOptVersionSelectionTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.versionSelectionType = null;
            return;
        }
        if ("LATEST".equals(value)) {
            this.versionSelectionType = LATEST;
        } else if ("NAMEDVERSION".equals(value)) {
            this.versionSelectionType = NAMEDVERSION;
        } else if ("ENGINEVERSION".equals(value)) {
            this.versionSelectionType = ENGINEVERSION;
        } else {
            throw new ValidationException("LuAppliedContent/VersionSelectionType: invalid attribute value:" + value + "!");
        }
    }

    public void addContentVersionInfo(ContentVersionInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addContentVersionInfo(int index, ContentVersionInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ContentVersionInfo> getContentVersionInfo() {
        Vector<ContentVersionInfo> v = new Vector<ContentVersionInfo>();
        for (Transportable child : (ChildGroup)this.children.get(730)) {
            v.add((ContentVersionInfo)child);
        }
        return v;
    }

    public int getContentVersionInfoCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(730);
        return childGroup.size();
    }

    public ContentVersionInfo getContentVersionInfo(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(730);
        return (ContentVersionInfo)childGroup.get(index);
    }

    public void setContentVersionInfo(int index, ContentVersionInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeContentVersionInfo(ContentVersionInfo value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 705;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.contentCategory == null) {
            throw new ValidationException("LuAppliedContent/ContentCategory: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ContentVersionInfo) {
            try {
                this.addContentVersionInfo((ContentVersionInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("ContentCategory")) == null) {
                throw new ValidationException("LuAppliedContent/ContentCategory: attribute is required!");
            }
            this.contentCategory = value;
            value = attris.getValue("VersionSelectionType");
            if (value != null) {
                this.setOptVersionSelectionTypeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getContentVersionInfoCount();
        for (i = 0; i < objCnt; ++i) {
            this.getContentVersionInfo(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LuAppliedContent".equals(element.getNodeName())) {
            throw new ValidationException("LuAppliedContent: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ContentCategory")) == null) {
            throw new ValidationException("LuAppliedContent/ContentCategory: attribute is required!");
        }
        this.contentCategory = value;
        value = XMLHelper.getAttribute(element, "VersionSelectionType");
        if (value != null) {
            this.setOptVersionSelectionTypeValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ContentVersionInfo");
        for (int i = 0; i < v.size(); ++i) {
            ContentVersionInfo contentVersionInfoObj = new ContentVersionInfo();
            contentVersionInfoObj.importFromElement(v.get(i));
            this.addContentVersionInfo(contentVersionInfoObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LuAppliedContent/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LuAppliedContent/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LuAppliedContent");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.contentCategory != null) {
            element.setAttribute("ContentCategory", this.contentCategory);
        }
        if (this.versionSelectionType != null) {
            element.setAttribute("VersionSelectionType", this.getOptVersionSelectionTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LuAppliedContent ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.contentCategory != null) {
                strAttrs.append("ContentCategory=\"").append(AbstractSchema.checkXMLContent(this.contentCategory)).append("\" ");
            }
            if (this.versionSelectionType != null) {
                strAttrs.append("VersionSelectionType=\"").append(this.getOptVersionSelectionTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LuAppliedContent>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

