/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ForwardedEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LogHandling
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer aggregationInterval;
    private Integer deleteAfterMinutes;
    private Boolean lockDeleteAfterMinutes;

    public LogHandling() {
        this(true);
    }

    public LogHandling(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(589, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "LogHandling";
    }

    public Integer getDefAggregationInterval() {
        return 300;
    }

    public Integer getOptAggregationInterval() {
        return this.aggregationInterval;
    }

    public void setOptAggregationInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.aggregationInterval = value;
    }

    public Integer getDefDeleteAfterMinutes() {
        return 43200;
    }

    public Integer getOptDeleteAfterMinutes() {
        return this.deleteAfterMinutes;
    }

    public void setOptDeleteAfterMinutes(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deleteAfterMinutes = value;
    }

    public Boolean getDefLockDeleteAfterMinutes() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDeleteAfterMinutes() {
        return this.lockDeleteAfterMinutes;
    }

    public void setOptLockDeleteAfterMinutes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDeleteAfterMinutes = value;
    }

    public void addForwardedEvent(ForwardedEvent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addForwardedEvent(int index, ForwardedEvent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ForwardedEvent> getForwardedEvent() {
        Vector<ForwardedEvent> v = new Vector<ForwardedEvent>();
        for (Transportable child : (ChildGroup)this.children.get(589)) {
            v.add((ForwardedEvent)child);
        }
        return v;
    }

    public int getForwardedEventCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(589);
        return childGroup.size();
    }

    public ForwardedEvent getForwardedEvent(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(589);
        return (ForwardedEvent)childGroup.get(index);
    }

    public void setForwardedEvent(int index, ForwardedEvent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeForwardedEvent(ForwardedEvent value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 588;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ForwardedEvent) {
            try {
                this.addForwardedEvent((ForwardedEvent)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AggregationInterval");
            if (value != null) {
                try {
                    this.aggregationInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LogHandling/AggregationInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LogHandling/AggregationInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DeleteAfterMinutes")) != null) {
                try {
                    this.deleteAfterMinutes = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LogHandling/DeleteAfterMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LogHandling/DeleteAfterMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LockDeleteAfterMinutes")) != null) {
                this.lockDeleteAfterMinutes = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getForwardedEventCount();
        for (i = 0; i < objCnt; ++i) {
            this.getForwardedEvent(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LogHandling".equals(element.getNodeName())) {
            throw new ValidationException("LogHandling: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AggregationInterval");
        if (value != null) {
            try {
                this.aggregationInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LogHandling/AggregationInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DeleteAfterMinutes")) != null) {
            try {
                this.deleteAfterMinutes = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LogHandling/DeleteAfterMinutes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LockDeleteAfterMinutes")) != null) {
            this.lockDeleteAfterMinutes = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ForwardedEvent");
        for (int i = 0; i < v.size(); ++i) {
            ForwardedEvent forwardedEventObj = new ForwardedEvent();
            forwardedEventObj.importFromElement(v.get(i));
            this.addForwardedEvent(forwardedEventObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LogHandling/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LogHandling/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LogHandling");
        if (this.aggregationInterval != null) {
            element.setAttribute("AggregationInterval", this.aggregationInterval.toString());
        }
        if (this.deleteAfterMinutes != null) {
            element.setAttribute("DeleteAfterMinutes", this.deleteAfterMinutes.toString());
        }
        if (this.lockDeleteAfterMinutes != null) {
            element.setAttribute("LockDeleteAfterMinutes", this.lockDeleteAfterMinutes != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LogHandling ");
            if (this.aggregationInterval != null) {
                strAttrs.append("AggregationInterval=\"").append(this.aggregationInterval.toString()).append("\" ");
            }
            if (this.deleteAfterMinutes != null) {
                strAttrs.append("DeleteAfterMinutes=\"").append(this.deleteAfterMinutes.toString()).append("\" ");
            }
            if (this.lockDeleteAfterMinutes != null) {
                strAttrs.append("LockDeleteAfterMinutes=").append(this.lockDeleteAfterMinutes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LogHandling>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

