/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AlSignature;
import com.sygate.scm.common.configobject.schema.DnsQuery;
import com.sygate.scm.common.configobject.schema.ICMPQuery;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Location
extends ConfigObject
implements NamedObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Boolean excludedFromAl;

    public Location() {
        this(true);
    }

    public Location(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, 1));
        this.children.put(247, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(781, new ChildGroup(0, 1));
        this.children.put(783, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "Location";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Boolean getDefExcludedFromAl() {
        return Boolean.FALSE;
    }

    public Boolean getOptExcludedFromAl() {
        return this.excludedFromAl;
    }

    public void setOptExcludedFromAl(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.excludedFromAl = value;
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addAlSignature(AlSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addAlSignature(int index, AlSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<AlSignature> getAlSignature() {
        Vector<AlSignature> v = new Vector<AlSignature>();
        for (Transportable child : (ChildGroup)this.children.get(247)) {
            v.add((AlSignature)child);
        }
        return v;
    }

    public int getAlSignatureCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(247);
        return childGroup.size();
    }

    public AlSignature getAlSignature(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(247);
        return (AlSignature)childGroup.get(index);
    }

    public void setAlSignature(int index, AlSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeAlSignature(AlSignature value) {
        this.removeChild(value);
    }

    public ICMPQuery getOptICMPQuery() {
        ChildGroup childGroup = (ChildGroup)this.children.get(781);
        if (childGroup.size() > 0) {
            return (ICMPQuery)childGroup.get(0);
        }
        return null;
    }

    public void setOptICMPQuery(ICMPQuery value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ICMPQuery obj = this.getOptICMPQuery();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DnsQuery getOptDnsQuery() {
        ChildGroup childGroup = (ChildGroup)this.children.get(783);
        if (childGroup.size() > 0) {
            return (DnsQuery)childGroup.get(0);
        }
        return null;
    }

    public void setOptDnsQuery(DnsQuery value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DnsQuery obj = this.getOptDnsQuery();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 246;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("Location/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("Location/Name: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("Location/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AlSignature) {
            try {
                this.addAlSignature((AlSignature)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ICMPQuery) {
            try {
                this.setOptICMPQuery((ICMPQuery)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DnsQuery) {
            try {
                this.setOptDnsQuery((DnsQuery)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Id")) == null) {
                throw new ValidationException("Location/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("Location/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("ExcludedFromAl")) != null) {
                this.excludedFromAl = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        int objCnt = this.getAlSignatureCount();
        for (i = 0; i < objCnt; ++i) {
            this.getAlSignature(i).setReadonly();
        }
        if (this.getOptICMPQuery() != null) {
            this.getOptICMPQuery().setReadonly();
        }
        if (this.getOptDnsQuery() != null) {
            this.getOptDnsQuery().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("Location: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"Location".equals(element.getNodeName())) {
            throw new ValidationException("Location: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) == null) {
            throw new ValidationException("Location/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("Location/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ExcludedFromAl")) != null) {
            this.excludedFromAl = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("Location/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        v = XMLHelper.getChildElementByName(element, "AlSignature");
        for (int i = 0; i < v.size(); ++i) {
            AlSignature alSignatureObj = new AlSignature();
            alSignatureObj.importFromElement(v.get(i));
            this.addAlSignature(alSignatureObj);
        }
        v = XMLHelper.getChildElementByName(element, "ICMPQuery");
        if (v.size() > 0) {
            ICMPQuery iCMPQueryObj = new ICMPQuery();
            iCMPQueryObj.importFromElement(v.get(0));
            this.setOptICMPQuery(iCMPQueryObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DnsQuery")).size() > 0) {
            DnsQuery dnsQueryObj = new DnsQuery();
            dnsQueryObj.importFromElement(v.get(0));
            this.setOptDnsQuery(dnsQueryObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Location/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Location/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Location");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.excludedFromAl != null) {
            element.setAttribute("ExcludedFromAl", this.excludedFromAl != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Location ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.excludedFromAl != null) {
                strAttrs.append("ExcludedFromAl=").append(this.excludedFromAl != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Location>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

