/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuGeneralConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LinuxLuPolicy
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;

    public LinuxLuPolicy() {
        this(true);
    }

    public LinuxLuPolicy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(709, new ChildGroup(0, 1));
        this.children.put(724, new ChildGroup(0, 1));
        this.children.put(729, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "LinuxLuPolicy";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public LuContentSourceInfo getOptLuContentSourceInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(709);
        if (childGroup.size() > 0) {
            return (LuContentSourceInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuContentSourceInfo(LuContentSourceInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuContentSourceInfo obj = this.getOptLuContentSourceInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuDownloadSchedule getOptLuDownloadSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(724);
        if (childGroup.size() > 0) {
            return (LuDownloadSchedule)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuDownloadSchedule(LuDownloadSchedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuDownloadSchedule obj = this.getOptLuDownloadSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public LuGeneralConfig getOptLuGeneralConfig() {
        ChildGroup childGroup = (ChildGroup)this.children.get(729);
        if (childGroup.size() > 0) {
            return (LuGeneralConfig)childGroup.get(0);
        }
        return null;
    }

    public void setOptLuGeneralConfig(LuGeneralConfig value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LuGeneralConfig obj = this.getOptLuGeneralConfig();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 708;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LuContentSourceInfo) {
            try {
                this.setOptLuContentSourceInfo((LuContentSourceInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuDownloadSchedule) {
            try {
                this.setOptLuDownloadSchedule((LuDownloadSchedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LuGeneralConfig) {
            try {
                this.setOptLuGeneralConfig((LuGeneralConfig)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptLuContentSourceInfo() != null) {
            this.getOptLuContentSourceInfo().setReadonly();
        }
        if (this.getOptLuDownloadSchedule() != null) {
            this.getOptLuDownloadSchedule().setReadonly();
        }
        if (this.getOptLuGeneralConfig() != null) {
            this.getOptLuGeneralConfig().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"LinuxLuPolicy".equals(element.getNodeName())) {
            throw new ValidationException("LinuxLuPolicy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuContentSourceInfo")).size() > 0) {
            LuContentSourceInfo luContentSourceInfoObj = new LuContentSourceInfo();
            luContentSourceInfoObj.importFromElement(v.get(0));
            this.setOptLuContentSourceInfo(luContentSourceInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuDownloadSchedule")).size() > 0) {
            LuDownloadSchedule luDownloadScheduleObj = new LuDownloadSchedule();
            luDownloadScheduleObj.importFromElement(v.get(0));
            this.setOptLuDownloadSchedule(luDownloadScheduleObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "LuGeneralConfig")).size() > 0) {
            LuGeneralConfig luGeneralConfigObj = new LuGeneralConfig();
            luGeneralConfigObj.importFromElement(v.get(0));
            this.setOptLuGeneralConfig(luGeneralConfigObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LinuxLuPolicy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LinuxLuPolicy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LinuxLuPolicy");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LinuxLuPolicy ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LinuxLuPolicy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

