/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LicenseChain
extends ConfigObject {
    public static final Integer SEP = 0;
    public static final Integer SNAC = 1;
    private static final long serialVersionUID = 1L;
    private String id;
    private Long endDate;
    private Long expireDate;
    private Long warnDate;
    private String checksum;
    private Integer meterCount;
    private Integer graceCount;
    private Integer clientProductType;
    private String renewalURL;
    private Boolean suspended;

    public LicenseChain() {
        this(true);
    }

    public LicenseChain(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(19, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "LicenseChain";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public Long getOptEndDate() {
        return this.endDate;
    }

    public void setOptEndDate(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.endDate = value;
    }

    public Long getOptExpireDate() {
        return this.expireDate;
    }

    public void setOptExpireDate(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.expireDate = value;
    }

    public Long getOptWarnDate() {
        return this.warnDate;
    }

    public void setOptWarnDate(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.warnDate = value;
    }

    public String getOptChecksum() {
        return this.checksum;
    }

    public void setOptChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checksum = value;
    }

    public Integer getOptMeterCount() {
        return this.meterCount;
    }

    public void setOptMeterCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.meterCount = value;
    }

    public Integer getOptGraceCount() {
        return this.graceCount;
    }

    public void setOptGraceCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.graceCount = value;
    }

    public Integer getOptClientProductType() {
        return this.clientProductType;
    }

    public String getOptClientProductTypeValue() throws ValidationException {
        if (this.clientProductType == null) {
            return null;
        }
        String s = null;
        switch (this.clientProductType) {
            case 0: {
                s = "SEP";
                break;
            }
            case 1: {
                s = "SNAC";
                break;
            }
            default: {
                throw new ValidationException("LicenseChain/ClientProductType: invalid attribute value:" + this.clientProductType + "!");
            }
        }
        return s;
    }

    public void setOptClientProductType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientProductType = value;
    }

    public void setOptClientProductTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.clientProductType = null;
            return;
        }
        if ("SEP".equals(value)) {
            this.clientProductType = SEP;
        } else if ("SNAC".equals(value)) {
            this.clientProductType = SNAC;
        } else {
            throw new ValidationException("LicenseChain/ClientProductType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptRenewalURL() {
        return this.renewalURL;
    }

    public void setOptRenewalURL(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.renewalURL = value;
    }

    public Boolean getDefSuspended() {
        return Boolean.FALSE;
    }

    public Boolean getOptSuspended() {
        return this.suspended;
    }

    public void setOptSuspended(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.suspended = value;
    }

    public void addElsLicense(ElsLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addElsLicense(int index, ElsLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ElsLicense> getElsLicense() {
        Vector<ElsLicense> v = new Vector<ElsLicense>();
        for (Transportable child : (ChildGroup)this.children.get(19)) {
            v.add((ElsLicense)child);
        }
        return v;
    }

    public int getElsLicenseCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(19);
        return childGroup.size();
    }

    public ElsLicense getElsLicense(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(19);
        return (ElsLicense)childGroup.get(index);
    }

    public void setElsLicense(int index, ElsLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeElsLicense(ElsLicense value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 20;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("LicenseChain/Id: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ElsLicense) {
            try {
                this.addElsLicense((ElsLicense)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("LicenseChain/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("EndDate");
            if (value != null) {
                try {
                    this.endDate = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LicenseChain/EndDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LicenseChain/EndDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ExpireDate")) != null) {
                try {
                    this.expireDate = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LicenseChain/ExpireDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LicenseChain/ExpireDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("WarnDate")) != null) {
                try {
                    this.warnDate = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LicenseChain/WarnDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LicenseChain/WarnDate: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Checksum")) != null) {
                this.checksum = value;
            }
            if ((value = attris.getValue("MeterCount")) != null) {
                try {
                    this.meterCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LicenseChain/MeterCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LicenseChain/MeterCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("GraceCount")) != null) {
                try {
                    this.graceCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LicenseChain/GraceCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LicenseChain/GraceCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ClientProductType")) != null) {
                this.setOptClientProductTypeValue(value);
            }
            if ((value = attris.getValue("RenewalURL")) != null) {
                this.renewalURL = value;
            }
            if ((value = attris.getValue("Suspended")) != null) {
                this.suspended = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getElsLicenseCount();
        for (i = 0; i < objCnt; ++i) {
            this.getElsLicense(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LicenseChain".equals(element.getNodeName())) {
            throw new ValidationException("LicenseChain: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("LicenseChain/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "EndDate");
        if (value != null) {
            try {
                this.endDate = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LicenseChain/EndDate: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ExpireDate")) != null) {
            try {
                this.expireDate = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LicenseChain/ExpireDate: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "WarnDate")) != null) {
            try {
                this.warnDate = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LicenseChain/WarnDate: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Checksum")) != null) {
            this.checksum = value;
        }
        if ((value = XMLHelper.getAttribute(element, "MeterCount")) != null) {
            try {
                this.meterCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LicenseChain/MeterCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "GraceCount")) != null) {
            try {
                this.graceCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LicenseChain/GraceCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ClientProductType")) != null) {
            this.setOptClientProductTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RenewalURL")) != null) {
            this.renewalURL = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Suspended")) != null) {
            this.suspended = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ElsLicense");
        for (int i = 0; i < v.size(); ++i) {
            ElsLicense elsLicenseObj = new ElsLicense();
            elsLicenseObj.importFromElement(v.get(i));
            this.addElsLicense(elsLicenseObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("LicenseChain/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("LicenseChain/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("LicenseChain");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.endDate != null) {
            element.setAttribute("EndDate", this.endDate.toString());
        }
        if (this.expireDate != null) {
            element.setAttribute("ExpireDate", this.expireDate.toString());
        }
        if (this.warnDate != null) {
            element.setAttribute("WarnDate", this.warnDate.toString());
        }
        if (this.checksum != null) {
            element.setAttribute("Checksum", this.checksum);
        }
        if (this.meterCount != null) {
            element.setAttribute("MeterCount", this.meterCount.toString());
        }
        if (this.graceCount != null) {
            element.setAttribute("GraceCount", this.graceCount.toString());
        }
        if (this.clientProductType != null) {
            element.setAttribute("ClientProductType", this.getOptClientProductTypeValue());
        }
        if (this.renewalURL != null) {
            element.setAttribute("RenewalURL", this.renewalURL);
        }
        if (this.suspended != null) {
            element.setAttribute("Suspended", this.suspended != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LicenseChain ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.endDate != null) {
                strAttrs.append("EndDate=\"").append(this.endDate.toString()).append("\" ");
            }
            if (this.expireDate != null) {
                strAttrs.append("ExpireDate=\"").append(this.expireDate.toString()).append("\" ");
            }
            if (this.warnDate != null) {
                strAttrs.append("WarnDate=\"").append(this.warnDate.toString()).append("\" ");
            }
            if (this.checksum != null) {
                strAttrs.append("Checksum=\"").append(AbstractSchema.checkXMLContent(this.checksum)).append("\" ");
            }
            if (this.meterCount != null) {
                strAttrs.append("MeterCount=\"").append(this.meterCount.toString()).append("\" ");
            }
            if (this.graceCount != null) {
                strAttrs.append("GraceCount=\"").append(this.graceCount.toString()).append("\" ");
            }
            if (this.clientProductType != null) {
                strAttrs.append("ClientProductType=\"").append(this.getOptClientProductTypeValue()).append("\" ");
            }
            if (this.renewalURL != null) {
                strAttrs.append("RenewalURL=\"").append(AbstractSchema.checkXMLContent(this.renewalURL)).append("\" ");
            }
            if (this.suspended != null) {
                strAttrs.append("Suspended=").append(this.suspended != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LicenseChain>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

