/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.IPLCompanyContactInfo;
import com.sygate.scm.common.configobject.schema.IPLTechContactInfo;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.LicenseCode;
import com.sygate.scm.common.configobject.schema.OverdeployedLicense;
import com.sygate.scm.common.configobject.schema.TrialwareLicense;
import com.sygate.scm.common.configobject.schema.UpgradeLicense;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class License
extends ConfigObject {
    public static final Integer SEPSB_TRIAL = 0;
    public static final Integer SEPSB_PAID = 1;
    public static final Integer SEPE_TRIAL = 2;
    public static final Integer SEPE_UPGRADE = 3;
    public static final Integer SEPE_PAID = 4;
    public static final Integer UNKNOWN = 5;
    private static final long serialVersionUID = 1L;
    private Boolean notifyAdminLicenseExpiration;
    private Integer licenseState;
    private Boolean licenseExpired;

    public License() {
        this(true);
    }

    public License(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(15, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(16, new ChildGroup(0, 1));
        this.children.put(17, new ChildGroup(0, 1));
        this.children.put(18, new ChildGroup(0, 1));
        this.children.put(20, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(22, new ChildGroup(0, 1));
        this.children.put(23, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "License";
    }

    public Boolean getOptNotifyAdminLicenseExpiration() {
        return this.notifyAdminLicenseExpiration;
    }

    public void setOptNotifyAdminLicenseExpiration(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.notifyAdminLicenseExpiration = value;
    }

    public Integer getDefLicenseState() {
        return UNKNOWN;
    }

    public Integer getOptLicenseState() {
        return this.licenseState;
    }

    public String getOptLicenseStateValue() throws ValidationException {
        if (this.licenseState == null) {
            return null;
        }
        String s = null;
        switch (this.licenseState) {
            case 0: {
                s = "SEPSB_TRIAL";
                break;
            }
            case 1: {
                s = "SEPSB_PAID";
                break;
            }
            case 2: {
                s = "SEPE_TRIAL";
                break;
            }
            case 3: {
                s = "SEPE_UPGRADE";
                break;
            }
            case 4: {
                s = "SEPE_PAID";
                break;
            }
            case 5: {
                s = "UNKNOWN";
                break;
            }
            default: {
                throw new ValidationException("License/LicenseState: invalid attribute value:" + this.licenseState + "!");
            }
        }
        return s;
    }

    public void setOptLicenseState(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.licenseState = value;
    }

    public void setOptLicenseStateValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.licenseState = null;
            return;
        }
        if ("SEPSB_TRIAL".equals(value)) {
            this.licenseState = SEPSB_TRIAL;
        } else if ("SEPSB_PAID".equals(value)) {
            this.licenseState = SEPSB_PAID;
        } else if ("SEPE_TRIAL".equals(value)) {
            this.licenseState = SEPE_TRIAL;
        } else if ("SEPE_UPGRADE".equals(value)) {
            this.licenseState = SEPE_UPGRADE;
        } else if ("SEPE_PAID".equals(value)) {
            this.licenseState = SEPE_PAID;
        } else if ("UNKNOWN".equals(value)) {
            this.licenseState = UNKNOWN;
        } else {
            throw new ValidationException("License/LicenseState: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLicenseExpired() {
        return Boolean.TRUE;
    }

    public Boolean getOptLicenseExpired() {
        return this.licenseExpired;
    }

    public void setOptLicenseExpired(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.licenseExpired = value;
    }

    public void addLicenseCode(LicenseCode value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLicenseCode(int index, LicenseCode value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LicenseCode> getLicenseCode() {
        Vector<LicenseCode> v = new Vector<LicenseCode>();
        for (Transportable child : (ChildGroup)this.children.get(15)) {
            v.add((LicenseCode)child);
        }
        return v;
    }

    public int getLicenseCodeCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(15);
        return childGroup.size();
    }

    public LicenseCode getLicenseCode(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(15);
        return (LicenseCode)childGroup.get(index);
    }

    public void setLicenseCode(int index, LicenseCode value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLicenseCode(LicenseCode value) {
        this.removeChild(value);
    }

    public OverdeployedLicense getOptOverdeployedLicense() {
        ChildGroup childGroup = (ChildGroup)this.children.get(16);
        if (childGroup.size() > 0) {
            return (OverdeployedLicense)childGroup.get(0);
        }
        return null;
    }

    public void setOptOverdeployedLicense(OverdeployedLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            OverdeployedLicense obj = this.getOptOverdeployedLicense();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public TrialwareLicense getOptTrialwareLicense() {
        ChildGroup childGroup = (ChildGroup)this.children.get(17);
        if (childGroup.size() > 0) {
            return (TrialwareLicense)childGroup.get(0);
        }
        return null;
    }

    public void setOptTrialwareLicense(TrialwareLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            TrialwareLicense obj = this.getOptTrialwareLicense();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public UpgradeLicense getOptUpgradeLicense() {
        ChildGroup childGroup = (ChildGroup)this.children.get(18);
        if (childGroup.size() > 0) {
            return (UpgradeLicense)childGroup.get(0);
        }
        return null;
    }

    public void setOptUpgradeLicense(UpgradeLicense value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            UpgradeLicense obj = this.getOptUpgradeLicense();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addLicenseChain(LicenseChain value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLicenseChain(int index, LicenseChain value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<LicenseChain> getLicenseChain() {
        Vector<LicenseChain> v = new Vector<LicenseChain>();
        for (Transportable child : (ChildGroup)this.children.get(20)) {
            v.add((LicenseChain)child);
        }
        return v;
    }

    public int getLicenseChainCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(20);
        return childGroup.size();
    }

    public LicenseChain getLicenseChain(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(20);
        return (LicenseChain)childGroup.get(index);
    }

    public void setLicenseChain(int index, LicenseChain value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLicenseChain(LicenseChain value) {
        this.removeChild(value);
    }

    public IPLCompanyContactInfo getOptIPLCompanyContactInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(22);
        if (childGroup.size() > 0) {
            return (IPLCompanyContactInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptIPLCompanyContactInfo(IPLCompanyContactInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IPLCompanyContactInfo obj = this.getOptIPLCompanyContactInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public IPLTechContactInfo getOptIPLTechContactInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(23);
        if (childGroup.size() > 0) {
            return (IPLTechContactInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptIPLTechContactInfo(IPLTechContactInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IPLTechContactInfo obj = this.getOptIPLTechContactInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 14;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LicenseCode) {
            try {
                this.addLicenseCode((LicenseCode)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof OverdeployedLicense) {
            try {
                this.setOptOverdeployedLicense((OverdeployedLicense)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof TrialwareLicense) {
            try {
                this.setOptTrialwareLicense((TrialwareLicense)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof UpgradeLicense) {
            try {
                this.setOptUpgradeLicense((UpgradeLicense)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof LicenseChain) {
            try {
                this.addLicenseChain((LicenseChain)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IPLCompanyContactInfo) {
            try {
                this.setOptIPLCompanyContactInfo((IPLCompanyContactInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IPLTechContactInfo) {
            try {
                this.setOptIPLTechContactInfo((IPLTechContactInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("NotifyAdminLicenseExpiration");
            if (value != null) {
                this.notifyAdminLicenseExpiration = "1".equals(value);
            }
            if ((value = attris.getValue("LicenseState")) != null) {
                this.setOptLicenseStateValue(value);
            }
            if ((value = attris.getValue("LicenseExpired")) != null) {
                this.licenseExpired = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getLicenseCodeCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLicenseCode(i).setReadonly();
        }
        if (this.getOptOverdeployedLicense() != null) {
            this.getOptOverdeployedLicense().setReadonly();
        }
        if (this.getOptTrialwareLicense() != null) {
            this.getOptTrialwareLicense().setReadonly();
        }
        if (this.getOptUpgradeLicense() != null) {
            this.getOptUpgradeLicense().setReadonly();
        }
        objCnt = this.getLicenseChainCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLicenseChain(i).setReadonly();
        }
        if (this.getOptIPLCompanyContactInfo() != null) {
            this.getOptIPLCompanyContactInfo().setReadonly();
        }
        if (this.getOptIPLTechContactInfo() != null) {
            this.getOptIPLTechContactInfo().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"License".equals(element.getNodeName())) {
            throw new ValidationException("License: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "NotifyAdminLicenseExpiration");
        if (value != null) {
            this.notifyAdminLicenseExpiration = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LicenseState")) != null) {
            this.setOptLicenseStateValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LicenseExpired")) != null) {
            this.licenseExpired = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "LicenseCode");
        for (i = 0; i < v.size(); ++i) {
            LicenseCode licenseCodeObj = new LicenseCode();
            licenseCodeObj.importFromElement(v.get(i));
            this.addLicenseCode(licenseCodeObj);
        }
        v = XMLHelper.getChildElementByName(element, "OverdeployedLicense");
        if (v.size() > 0) {
            OverdeployedLicense overdeployedLicenseObj = new OverdeployedLicense();
            overdeployedLicenseObj.importFromElement(v.get(0));
            this.setOptOverdeployedLicense(overdeployedLicenseObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "TrialwareLicense")).size() > 0) {
            TrialwareLicense trialwareLicenseObj = new TrialwareLicense();
            trialwareLicenseObj.importFromElement(v.get(0));
            this.setOptTrialwareLicense(trialwareLicenseObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "UpgradeLicense")).size() > 0) {
            UpgradeLicense upgradeLicenseObj = new UpgradeLicense();
            upgradeLicenseObj.importFromElement(v.get(0));
            this.setOptUpgradeLicense(upgradeLicenseObj);
        }
        v = XMLHelper.getChildElementByName(element, "LicenseChain");
        for (i = 0; i < v.size(); ++i) {
            LicenseChain licenseChainObj = new LicenseChain();
            licenseChainObj.importFromElement(v.get(i));
            this.addLicenseChain(licenseChainObj);
        }
        v = XMLHelper.getChildElementByName(element, "IPLCompanyContactInfo");
        if (v.size() > 0) {
            IPLCompanyContactInfo iPLCompanyContactInfoObj = new IPLCompanyContactInfo();
            iPLCompanyContactInfoObj.importFromElement(v.get(0));
            this.setOptIPLCompanyContactInfo(iPLCompanyContactInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IPLTechContactInfo")).size() > 0) {
            IPLTechContactInfo iPLTechContactInfoObj = new IPLTechContactInfo();
            iPLTechContactInfoObj.importFromElement(v.get(0));
            this.setOptIPLTechContactInfo(iPLTechContactInfoObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("License/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("License/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("License");
        if (this.notifyAdminLicenseExpiration != null) {
            element.setAttribute("NotifyAdminLicenseExpiration", this.notifyAdminLicenseExpiration != false ? "1" : "0");
        }
        if (this.licenseState != null) {
            element.setAttribute("LicenseState", this.getOptLicenseStateValue());
        }
        if (this.licenseExpired != null) {
            element.setAttribute("LicenseExpired", this.licenseExpired != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<License ");
            if (this.notifyAdminLicenseExpiration != null) {
                strAttrs.append("NotifyAdminLicenseExpiration=").append(this.notifyAdminLicenseExpiration != false ? "\"1\" " : "\"0\" ");
            }
            if (this.licenseState != null) {
                strAttrs.append("LicenseState=\"").append(this.getOptLicenseStateValue()).append("\" ");
            }
            if (this.licenseExpired != null) {
                strAttrs.append("LicenseExpired=").append(this.licenseExpired != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</License>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

