/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class KnownRiskOverrride
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String securityRiskName;
    private String overallRating;
    private String privacyImpact;
    private String performance;
    private String pVID;
    private Boolean writeLog;

    public KnownRiskOverrride() {
        this(true);
    }

    public KnownRiskOverrride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "KnownRiskOverrride";
    }

    public String getSecurityRiskName() {
        return this.securityRiskName;
    }

    public void setSecurityRiskName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.securityRiskName = value;
    }

    public String getOptOverallRating() {
        return this.overallRating;
    }

    public void setOptOverallRating(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.overallRating = value;
    }

    public String getOptPrivacyImpact() {
        return this.privacyImpact;
    }

    public void setOptPrivacyImpact(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.privacyImpact = value;
    }

    public String getOptPerformance() {
        return this.performance;
    }

    public void setOptPerformance(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.performance = value;
    }

    public String getOptPVID() {
        return this.pVID;
    }

    public void setOptPVID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pVID = value;
    }

    public Boolean getDefWriteLog() {
        return Boolean.TRUE;
    }

    public Boolean getOptWriteLog() {
        return this.writeLog;
    }

    public void setOptWriteLog(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.writeLog = value;
    }

    @Override
    public int getObjectType() {
        return 681;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.securityRiskName == null) {
            throw new ValidationException("KnownRiskOverrride/SecurityRiskName: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SecurityRiskName");
            if (value == null) {
                throw new ValidationException("KnownRiskOverrride/SecurityRiskName: attribute is required!");
            }
            this.securityRiskName = value;
            value = attris.getValue("OverallRating");
            if (value != null) {
                this.overallRating = value;
            }
            if ((value = attris.getValue("PrivacyImpact")) != null) {
                this.privacyImpact = value;
            }
            if ((value = attris.getValue("Performance")) != null) {
                this.performance = value;
            }
            if ((value = attris.getValue("PVID")) != null) {
                this.pVID = value;
            }
            if ((value = attris.getValue("WriteLog")) != null) {
                this.writeLog = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"KnownRiskOverrride".equals(element.getNodeName())) {
            throw new ValidationException("KnownRiskOverrride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SecurityRiskName");
        if (value == null) {
            throw new ValidationException("KnownRiskOverrride/SecurityRiskName: attribute is required!");
        }
        this.securityRiskName = value;
        value = XMLHelper.getAttribute(element, "OverallRating");
        if (value != null) {
            this.overallRating = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PrivacyImpact")) != null) {
            this.privacyImpact = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Performance")) != null) {
            this.performance = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PVID")) != null) {
            this.pVID = value;
        }
        if ((value = XMLHelper.getAttribute(element, "WriteLog")) != null) {
            this.writeLog = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("KnownRiskOverrride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("KnownRiskOverrride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("KnownRiskOverrride");
        if (this.securityRiskName != null) {
            element.setAttribute("SecurityRiskName", this.securityRiskName);
        }
        if (this.overallRating != null) {
            element.setAttribute("OverallRating", this.overallRating);
        }
        if (this.privacyImpact != null) {
            element.setAttribute("PrivacyImpact", this.privacyImpact);
        }
        if (this.performance != null) {
            element.setAttribute("Performance", this.performance);
        }
        if (this.pVID != null) {
            element.setAttribute("PVID", this.pVID);
        }
        if (this.writeLog != null) {
            element.setAttribute("WriteLog", this.writeLog != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<KnownRiskOverrride ");
            if (this.securityRiskName != null) {
                strAttrs.append("SecurityRiskName=\"").append(AbstractSchema.checkXMLContent(this.securityRiskName)).append("\" ");
            }
            if (this.overallRating != null) {
                strAttrs.append("OverallRating=\"").append(AbstractSchema.checkXMLContent(this.overallRating)).append("\" ");
            }
            if (this.privacyImpact != null) {
                strAttrs.append("PrivacyImpact=\"").append(AbstractSchema.checkXMLContent(this.privacyImpact)).append("\" ");
            }
            if (this.performance != null) {
                strAttrs.append("Performance=\"").append(AbstractSchema.checkXMLContent(this.performance)).append("\" ");
            }
            if (this.pVID != null) {
                strAttrs.append("PVID=\"").append(AbstractSchema.checkXMLContent(this.pVID)).append("\" ");
            }
            if (this.writeLog != null) {
                strAttrs.append("WriteLog=").append(this.writeLog != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</KnownRiskOverrride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

