/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstallationOption
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer UNATTENDED = 1;
    public static final Integer SILENT = 2;
    public static final Integer PROMPT_WHEN_RESTART = 0;
    public static final Integer ASK_FOR_RESTART = 1;
    public static final Integer SILENT_RESTART = 2;
    public static final Integer DO_NOTHING = 3;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer userInterfaceLevel;
    private Integer restartOption;
    private Boolean keepAllDataOnUpgrade;
    private Boolean specifyInstallationDirectory;
    private String installationDirectory;
    private Boolean enableCompetitiveUninstall;
    private Boolean enablePreInstallCleanup;
    private Boolean enableInstallationLog;
    private String installationLogFileName;
    private Boolean startAgentAfterInstallation;
    private Boolean addProgramIntoStartMenu;
    private Boolean enableMrCleanSubMission;
    private Boolean specifyReducedInstallSize;
    private Boolean darkNetwork;

    public InstallationOption() {
        this(true);
    }

    public InstallationOption(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "InstallationOption";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getUserInterfaceLevel() {
        return this.userInterfaceLevel;
    }

    public String getUserInterfaceLevelValue() throws ValidationException {
        if (this.userInterfaceLevel == null) {
            return null;
        }
        String s = null;
        switch (this.userInterfaceLevel) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "UNATTENDED";
                break;
            }
            case 2: {
                s = "SILENT";
                break;
            }
            default: {
                throw new ValidationException("InstallationOption/UserInterfaceLevel: invalid attribute value:" + this.userInterfaceLevel + "!");
            }
        }
        return s;
    }

    public void setUserInterfaceLevel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userInterfaceLevel = value;
    }

    public void setUserInterfaceLevelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NORMAL".equals(value)) {
            this.userInterfaceLevel = NORMAL;
        } else if ("UNATTENDED".equals(value)) {
            this.userInterfaceLevel = UNATTENDED;
        } else if ("SILENT".equals(value)) {
            this.userInterfaceLevel = SILENT;
        } else {
            throw new ValidationException("InstallationOption/UserInterfaceLevel: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRestartOption() {
        return PROMPT_WHEN_RESTART;
    }

    public Integer getOptRestartOption() {
        return this.restartOption;
    }

    public String getOptRestartOptionValue() throws ValidationException {
        if (this.restartOption == null) {
            return null;
        }
        String s = null;
        switch (this.restartOption) {
            case 0: {
                s = "PROMPT_WHEN_RESTART";
                break;
            }
            case 1: {
                s = "ASK_FOR_RESTART";
                break;
            }
            case 2: {
                s = "SILENT_RESTART";
                break;
            }
            case 3: {
                s = "DO_NOTHING";
                break;
            }
            default: {
                throw new ValidationException("InstallationOption/RestartOption: invalid attribute value:" + this.restartOption + "!");
            }
        }
        return s;
    }

    public void setOptRestartOption(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.restartOption = value;
    }

    public void setOptRestartOptionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.restartOption = null;
            return;
        }
        if ("PROMPT_WHEN_RESTART".equals(value)) {
            this.restartOption = PROMPT_WHEN_RESTART;
        } else if ("ASK_FOR_RESTART".equals(value)) {
            this.restartOption = ASK_FOR_RESTART;
        } else if ("SILENT_RESTART".equals(value)) {
            this.restartOption = SILENT_RESTART;
        } else if ("DO_NOTHING".equals(value)) {
            this.restartOption = DO_NOTHING;
        } else {
            throw new ValidationException("InstallationOption/RestartOption: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getKeepAllDataOnUpgrade() {
        return this.keepAllDataOnUpgrade;
    }

    public void setKeepAllDataOnUpgrade(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.keepAllDataOnUpgrade = value;
    }

    public Boolean getDefSpecifyInstallationDirectory() {
        return Boolean.FALSE;
    }

    public Boolean getOptSpecifyInstallationDirectory() {
        return this.specifyInstallationDirectory;
    }

    public void setOptSpecifyInstallationDirectory(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.specifyInstallationDirectory = value;
    }

    public String getOptInstallationDirectory() {
        return this.installationDirectory;
    }

    public void setOptInstallationDirectory(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.installationDirectory = value;
    }

    public Boolean getDefEnableCompetitiveUninstall() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableCompetitiveUninstall() {
        return this.enableCompetitiveUninstall;
    }

    public void setOptEnableCompetitiveUninstall(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableCompetitiveUninstall = value;
    }

    public Boolean getDefEnablePreInstallCleanup() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnablePreInstallCleanup() {
        return this.enablePreInstallCleanup;
    }

    public void setOptEnablePreInstallCleanup(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enablePreInstallCleanup = value;
    }

    public Boolean getDefEnableInstallationLog() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableInstallationLog() {
        return this.enableInstallationLog;
    }

    public void setOptEnableInstallationLog(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableInstallationLog = value;
    }

    public String getOptInstallationLogFileName() {
        return this.installationLogFileName;
    }

    public void setOptInstallationLogFileName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.installationLogFileName = value;
    }

    public Boolean getDefStartAgentAfterInstallation() {
        return Boolean.TRUE;
    }

    public Boolean getOptStartAgentAfterInstallation() {
        return this.startAgentAfterInstallation;
    }

    public void setOptStartAgentAfterInstallation(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startAgentAfterInstallation = value;
    }

    public Boolean getDefAddProgramIntoStartMenu() {
        return Boolean.TRUE;
    }

    public Boolean getOptAddProgramIntoStartMenu() {
        return this.addProgramIntoStartMenu;
    }

    public void setOptAddProgramIntoStartMenu(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.addProgramIntoStartMenu = value;
    }

    public Boolean getDefEnableMrCleanSubMission() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnableMrCleanSubMission() {
        return this.enableMrCleanSubMission;
    }

    public void setOptEnableMrCleanSubMission(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableMrCleanSubMission = value;
    }

    public Boolean getDefSpecifyReducedInstallSize() {
        return Boolean.FALSE;
    }

    public Boolean getOptSpecifyReducedInstallSize() {
        return this.specifyReducedInstallSize;
    }

    public void setOptSpecifyReducedInstallSize(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.specifyReducedInstallSize = value;
    }

    public Boolean getDefDarkNetwork() {
        return Boolean.FALSE;
    }

    public Boolean getOptDarkNetwork() {
        return this.darkNetwork;
    }

    public void setOptDarkNetwork(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.darkNetwork = value;
    }

    @Override
    public int getObjectType() {
        return 179;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.userInterfaceLevel == null) {
            throw new ValidationException("InstallationOption/UserInterfaceLevel: attribute is required!");
        }
        if (this.keepAllDataOnUpgrade == null) {
            throw new ValidationException("InstallationOption/KeepAllDataOnUpgrade: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("UserInterfaceLevel")) == null) {
                throw new ValidationException("InstallationOption/UserInterfaceLevel: attribute is required!");
            }
            this.setUserInterfaceLevelValue(value);
            value = attris.getValue("RestartOption");
            if (value != null) {
                this.setOptRestartOptionValue(value);
            }
            if ((value = attris.getValue("KeepAllDataOnUpgrade")) == null) {
                throw new ValidationException("InstallationOption/KeepAllDataOnUpgrade: attribute is required!");
            }
            this.keepAllDataOnUpgrade = "1".equals(value);
            value = attris.getValue("SpecifyInstallationDirectory");
            if (value != null) {
                this.specifyInstallationDirectory = "1".equals(value);
            }
            if ((value = attris.getValue("InstallationDirectory")) != null) {
                this.installationDirectory = value;
            }
            if ((value = attris.getValue("EnableCompetitiveUninstall")) != null) {
                this.enableCompetitiveUninstall = "1".equals(value);
            }
            if ((value = attris.getValue("EnablePreInstallCleanup")) != null) {
                this.enablePreInstallCleanup = "1".equals(value);
            }
            if ((value = attris.getValue("EnableInstallationLog")) != null) {
                this.enableInstallationLog = "1".equals(value);
            }
            if ((value = attris.getValue("InstallationLogFileName")) != null) {
                this.installationLogFileName = value;
            }
            if ((value = attris.getValue("StartAgentAfterInstallation")) != null) {
                this.startAgentAfterInstallation = "1".equals(value);
            }
            if ((value = attris.getValue("AddProgramIntoStartMenu")) != null) {
                this.addProgramIntoStartMenu = "1".equals(value);
            }
            if ((value = attris.getValue("EnableMrCleanSubMission")) != null) {
                this.enableMrCleanSubMission = "1".equals(value);
            }
            if ((value = attris.getValue("SpecifyReducedInstallSize")) != null) {
                this.specifyReducedInstallSize = "1".equals(value);
            }
            if ((value = attris.getValue("DarkNetwork")) != null) {
                this.darkNetwork = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"InstallationOption".equals(element.getNodeName())) {
            throw new ValidationException("InstallationOption: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserInterfaceLevel")) == null) {
            throw new ValidationException("InstallationOption/UserInterfaceLevel: attribute is required!");
        }
        this.setUserInterfaceLevelValue(value);
        value = XMLHelper.getAttribute(element, "RestartOption");
        if (value != null) {
            this.setOptRestartOptionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "KeepAllDataOnUpgrade")) == null) {
            throw new ValidationException("InstallationOption/KeepAllDataOnUpgrade: attribute is required!");
        }
        this.keepAllDataOnUpgrade = "1".equals(value);
        value = XMLHelper.getAttribute(element, "SpecifyInstallationDirectory");
        if (value != null) {
            this.specifyInstallationDirectory = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "InstallationDirectory")) != null) {
            this.installationDirectory = value;
        }
        if ((value = XMLHelper.getAttribute(element, "EnableCompetitiveUninstall")) != null) {
            this.enableCompetitiveUninstall = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnablePreInstallCleanup")) != null) {
            this.enablePreInstallCleanup = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableInstallationLog")) != null) {
            this.enableInstallationLog = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "InstallationLogFileName")) != null) {
            this.installationLogFileName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "StartAgentAfterInstallation")) != null) {
            this.startAgentAfterInstallation = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AddProgramIntoStartMenu")) != null) {
            this.addProgramIntoStartMenu = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableMrCleanSubMission")) != null) {
            this.enableMrCleanSubMission = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SpecifyReducedInstallSize")) != null) {
            this.specifyReducedInstallSize = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DarkNetwork")) != null) {
            this.darkNetwork = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("InstallationOption/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("InstallationOption/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("InstallationOption");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.userInterfaceLevel != null) {
            element.setAttribute("UserInterfaceLevel", this.getUserInterfaceLevelValue());
        }
        if (this.restartOption != null) {
            element.setAttribute("RestartOption", this.getOptRestartOptionValue());
        }
        if (this.keepAllDataOnUpgrade != null) {
            element.setAttribute("KeepAllDataOnUpgrade", this.keepAllDataOnUpgrade != false ? "1" : "0");
        }
        if (this.specifyInstallationDirectory != null) {
            element.setAttribute("SpecifyInstallationDirectory", this.specifyInstallationDirectory != false ? "1" : "0");
        }
        if (this.installationDirectory != null) {
            element.setAttribute("InstallationDirectory", this.installationDirectory);
        }
        if (this.enableCompetitiveUninstall != null) {
            element.setAttribute("EnableCompetitiveUninstall", this.enableCompetitiveUninstall != false ? "1" : "0");
        }
        if (this.enablePreInstallCleanup != null) {
            element.setAttribute("EnablePreInstallCleanup", this.enablePreInstallCleanup != false ? "1" : "0");
        }
        if (this.enableInstallationLog != null) {
            element.setAttribute("EnableInstallationLog", this.enableInstallationLog != false ? "1" : "0");
        }
        if (this.installationLogFileName != null) {
            element.setAttribute("InstallationLogFileName", this.installationLogFileName);
        }
        if (this.startAgentAfterInstallation != null) {
            element.setAttribute("StartAgentAfterInstallation", this.startAgentAfterInstallation != false ? "1" : "0");
        }
        if (this.addProgramIntoStartMenu != null) {
            element.setAttribute("AddProgramIntoStartMenu", this.addProgramIntoStartMenu != false ? "1" : "0");
        }
        if (this.enableMrCleanSubMission != null) {
            element.setAttribute("EnableMrCleanSubMission", this.enableMrCleanSubMission != false ? "1" : "0");
        }
        if (this.specifyReducedInstallSize != null) {
            element.setAttribute("SpecifyReducedInstallSize", this.specifyReducedInstallSize != false ? "1" : "0");
        }
        if (this.darkNetwork != null) {
            element.setAttribute("DarkNetwork", this.darkNetwork != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<InstallationOption ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.userInterfaceLevel != null) {
                strAttrs.append("UserInterfaceLevel=\"").append(this.getUserInterfaceLevelValue()).append("\" ");
            }
            if (this.restartOption != null) {
                strAttrs.append("RestartOption=\"").append(this.getOptRestartOptionValue()).append("\" ");
            }
            if (this.keepAllDataOnUpgrade != null) {
                strAttrs.append("KeepAllDataOnUpgrade=").append(this.keepAllDataOnUpgrade != false ? "\"1\" " : "\"0\" ");
            }
            if (this.specifyInstallationDirectory != null) {
                strAttrs.append("SpecifyInstallationDirectory=").append(this.specifyInstallationDirectory != false ? "\"1\" " : "\"0\" ");
            }
            if (this.installationDirectory != null) {
                strAttrs.append("InstallationDirectory=\"").append(AbstractSchema.checkXMLContent(this.installationDirectory)).append("\" ");
            }
            if (this.enableCompetitiveUninstall != null) {
                strAttrs.append("EnableCompetitiveUninstall=").append(this.enableCompetitiveUninstall != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enablePreInstallCleanup != null) {
                strAttrs.append("EnablePreInstallCleanup=").append(this.enablePreInstallCleanup != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableInstallationLog != null) {
                strAttrs.append("EnableInstallationLog=").append(this.enableInstallationLog != false ? "\"1\" " : "\"0\" ");
            }
            if (this.installationLogFileName != null) {
                strAttrs.append("InstallationLogFileName=\"").append(AbstractSchema.checkXMLContent(this.installationLogFileName)).append("\" ");
            }
            if (this.startAgentAfterInstallation != null) {
                strAttrs.append("StartAgentAfterInstallation=").append(this.startAgentAfterInstallation != false ? "\"1\" " : "\"0\" ");
            }
            if (this.addProgramIntoStartMenu != null) {
                strAttrs.append("AddProgramIntoStartMenu=").append(this.addProgramIntoStartMenu != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableMrCleanSubMission != null) {
                strAttrs.append("EnableMrCleanSubMission=").append(this.enableMrCleanSubMission != false ? "\"1\" " : "\"0\" ");
            }
            if (this.specifyReducedInstallSize != null) {
                strAttrs.append("SpecifyReducedInstallSize=").append(this.specifyReducedInstallSize != false ? "\"1\" " : "\"0\" ");
            }
            if (this.darkNetwork != null) {
                strAttrs.append("DarkNetwork=").append(this.darkNetwork != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</InstallationOption>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

