/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.Action;
import com.sygate.scm.common.configobject.schema.IdsChildSignatureLink;
import com.sygate.scm.common.configobject.schema.IdsTrafficCondition;
import com.sygate.scm.common.configobject.schema.IdsTriggerExpiration;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IdsSignature
extends ConfigObject
implements NamedObject {
    public static final Integer UNKNOWN = 0;
    public static final Integer ACTIVE = 1;
    public static final Integer PASSIVE = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Long severity;
    private Integer hostType;
    private String linkTo;

    public IdsSignature() {
        this(true);
    }

    public IdsSignature(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(493, new ChildGroup(1, 1));
        this.children.put(304, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(349, new ChildGroup(1, 1));
        this.children.put(494, new ChildGroup(0, 1));
        this.children.put(495, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "IdsSignature";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Long getSeverity() {
        return this.severity;
    }

    public void setSeverity(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.severity = value;
    }

    public Integer getDefHostType() {
        return UNKNOWN;
    }

    public Integer getOptHostType() {
        return this.hostType;
    }

    public String getOptHostTypeValue() throws ValidationException {
        if (this.hostType == null) {
            return null;
        }
        String s = null;
        switch (this.hostType) {
            case 0: {
                s = "UNKNOWN";
                break;
            }
            case 1: {
                s = "ACTIVE";
                break;
            }
            case 2: {
                s = "PASSIVE";
                break;
            }
            default: {
                throw new ValidationException("IdsSignature/HostType: invalid attribute value:" + this.hostType + "!");
            }
        }
        return s;
    }

    public void setOptHostType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hostType = value;
    }

    public void setOptHostTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.hostType = null;
            return;
        }
        if ("UNKNOWN".equals(value)) {
            this.hostType = UNKNOWN;
        } else if ("ACTIVE".equals(value)) {
            this.hostType = ACTIVE;
        } else if ("PASSIVE".equals(value)) {
            this.hostType = PASSIVE;
        } else {
            throw new ValidationException("IdsSignature/HostType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptLinkTo() {
        return this.linkTo;
    }

    public void setOptLinkTo(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.linkTo = value;
    }

    public IdsTrafficCondition getIdsTrafficCondition() {
        ChildGroup childGroup = (ChildGroup)this.children.get(493);
        if (childGroup.size() > 0) {
            return (IdsTrafficCondition)childGroup.get(0);
        }
        return null;
    }

    public void setIdsTrafficCondition(IdsTrafficCondition value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IdsTrafficCondition obj = this.getIdsTrafficCondition();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addSoApplicationContainer(SoApplicationContainer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSoApplicationContainer(int index, SoApplicationContainer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SoApplicationContainer> getSoApplicationContainer() {
        Vector<SoApplicationContainer> v = new Vector<SoApplicationContainer>();
        for (Transportable child : (ChildGroup)this.children.get(304)) {
            v.add((SoApplicationContainer)child);
        }
        return v;
    }

    public int getSoApplicationContainerCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(304);
        return childGroup.size();
    }

    public SoApplicationContainer getSoApplicationContainer(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(304);
        return (SoApplicationContainer)childGroup.get(index);
    }

    public void setSoApplicationContainer(int index, SoApplicationContainer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSoApplicationContainer(SoApplicationContainer value) {
        this.removeChild(value);
    }

    public Action getAction() {
        ChildGroup childGroup = (ChildGroup)this.children.get(349);
        if (childGroup.size() > 0) {
            return (Action)childGroup.get(0);
        }
        return null;
    }

    public void setAction(Action value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Action obj = this.getAction();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public IdsChildSignatureLink getOptIdsChildSignatureLink() {
        ChildGroup childGroup = (ChildGroup)this.children.get(494);
        if (childGroup.size() > 0) {
            return (IdsChildSignatureLink)childGroup.get(0);
        }
        return null;
    }

    public void setOptIdsChildSignatureLink(IdsChildSignatureLink value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IdsChildSignatureLink obj = this.getOptIdsChildSignatureLink();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public IdsTriggerExpiration getOptIdsTriggerExpiration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(495);
        if (childGroup.size() > 0) {
            return (IdsTriggerExpiration)childGroup.get(0);
        }
        return null;
    }

    public void setOptIdsTriggerExpiration(IdsTriggerExpiration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IdsTriggerExpiration obj = this.getOptIdsTriggerExpiration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 492;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("IdsSignature/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("IdsSignature/Name: attribute is required!");
        }
        if (this.severity == null) {
            throw new ValidationException("IdsSignature/Severity: attribute is required!");
        }
        if (this.getIdsTrafficCondition() == null) {
            throw new ValidationException("IdsSignature/IdsTrafficCondition: attribute is required!");
        }
        if (this.getAction() == null) {
            throw new ValidationException("IdsSignature/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof IdsTrafficCondition) {
            try {
                this.setIdsTrafficCondition((IdsTrafficCondition)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SoApplicationContainer) {
            try {
                this.addSoApplicationContainer((SoApplicationContainer)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Action) {
            try {
                this.setAction((Action)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IdsChildSignatureLink) {
            try {
                this.setOptIdsChildSignatureLink((IdsChildSignatureLink)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IdsTriggerExpiration) {
            try {
                this.setOptIdsTriggerExpiration((IdsTriggerExpiration)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Id")) == null) {
                throw new ValidationException("IdsSignature/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("IdsSignature/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Severity")) == null) {
                throw new ValidationException("IdsSignature/Severity: attribute is required!");
            }
            try {
                this.severity = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("HostType");
            if (value != null) {
                this.setOptHostTypeValue(value);
            }
            if ((value = attris.getValue("LinkTo")) != null) {
                this.linkTo = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getIdsTrafficCondition() != null) {
            this.getIdsTrafficCondition().setReadonly();
        }
        int objCnt = this.getSoApplicationContainerCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSoApplicationContainer(i).setReadonly();
        }
        if (this.getAction() != null) {
            this.getAction().setReadonly();
        }
        if (this.getOptIdsChildSignatureLink() != null) {
            this.getOptIdsChildSignatureLink().setReadonly();
        }
        if (this.getOptIdsTriggerExpiration() != null) {
            this.getOptIdsTriggerExpiration().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(493)).size();
        }
        catch (Throwable t) {
            throw new SAXException("IdsSignature: can't import element == IdsTrafficCondition!");
        }
        try {
            ((ChildGroup)this.children.get(349)).size();
        }
        catch (Throwable t) {
            throw new SAXException("IdsSignature: can't import element == Action!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"IdsSignature".equals(element.getNodeName())) {
            throw new ValidationException("IdsSignature: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) == null) {
            throw new ValidationException("IdsSignature/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("IdsSignature/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Severity")) == null) {
            throw new ValidationException("IdsSignature/Severity: attribute is required!");
        }
        try {
            this.severity = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "HostType");
        if (value != null) {
            this.setOptHostTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LinkTo")) != null) {
            this.linkTo = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "IdsTrafficCondition")).size() != 1) {
            throw new ValidationException("IdsSignature/IdsTrafficCondition: element is require!");
        }
        IdsTrafficCondition idsTrafficConditionObj = new IdsTrafficCondition();
        idsTrafficConditionObj.importFromElement(v.get(0));
        this.setIdsTrafficCondition(idsTrafficConditionObj);
        v = XMLHelper.getChildElementByName(element, "SoApplicationContainer");
        for (int i = 0; i < v.size(); ++i) {
            SoApplicationContainer soApplicationContainerObj = new SoApplicationContainer();
            soApplicationContainerObj.importFromElement(v.get(i));
            this.addSoApplicationContainer(soApplicationContainerObj);
        }
        v = XMLHelper.getChildElementByName(element, "Action");
        if (v.size() != 1) {
            throw new ValidationException("IdsSignature/Action: element is require!");
        }
        Action actionObj = new Action();
        actionObj.importFromElement(v.get(0));
        this.setAction(actionObj);
        v = XMLHelper.getChildElementByName(element, "IdsChildSignatureLink");
        if (v.size() > 0) {
            IdsChildSignatureLink idsChildSignatureLinkObj = new IdsChildSignatureLink();
            idsChildSignatureLinkObj.importFromElement(v.get(0));
            this.setOptIdsChildSignatureLink(idsChildSignatureLinkObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IdsTriggerExpiration")).size() > 0) {
            IdsTriggerExpiration idsTriggerExpirationObj = new IdsTriggerExpiration();
            idsTriggerExpirationObj.importFromElement(v.get(0));
            this.setOptIdsTriggerExpiration(idsTriggerExpirationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("IdsSignature/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("IdsSignature/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("IdsSignature");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.severity != null) {
            element.setAttribute("Severity", this.severity.toString());
        }
        if (this.hostType != null) {
            element.setAttribute("HostType", this.getOptHostTypeValue());
        }
        if (this.linkTo != null) {
            element.setAttribute("LinkTo", this.linkTo);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IdsSignature ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.severity != null) {
                strAttrs.append("Severity=\"").append(this.severity.toString()).append("\" ");
            }
            if (this.hostType != null) {
                strAttrs.append("HostType=\"").append(this.getOptHostTypeValue()).append("\" ");
            }
            if (this.linkTo != null) {
                strAttrs.append("LinkTo=\"").append(AbstractSchema.checkXMLContent(this.linkTo)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IdsSignature>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

