/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.HostName;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IPAddressesHostNames
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public IPAddressesHostNames() {
        this(true);
    }

    public IPAddressesHostNames(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(721, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(52, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(53, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "IPAddressesHostNames";
    }

    public void addHostName(HostName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addHostName(int index, HostName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<HostName> getHostName() {
        Vector<HostName> v = new Vector<HostName>();
        for (Transportable child : (ChildGroup)this.children.get(721)) {
            v.add((HostName)child);
        }
        return v;
    }

    public int getHostNameCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(721);
        return childGroup.size();
    }

    public HostName getHostName(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(721);
        return (HostName)childGroup.get(index);
    }

    public void setHostName(int index, HostName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeHostName(HostName value) {
        this.removeChild(value);
    }

    public void addIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IpAddress> getIpAddress() {
        Vector<IpAddress> v = new Vector<IpAddress>();
        for (Transportable child : (ChildGroup)this.children.get(52)) {
            v.add((IpAddress)child);
        }
        return v;
    }

    public int getIpAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return childGroup.size();
    }

    public IpAddress getIpAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return (IpAddress)childGroup.get(index);
    }

    public void setIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpAddress(IpAddress value) {
        this.removeChild(value);
    }

    public void addIpv6Address(Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Ipv6Address> getIpv6Address() {
        Vector<Ipv6Address> v = new Vector<Ipv6Address>();
        for (Transportable child : (ChildGroup)this.children.get(53)) {
            v.add((Ipv6Address)child);
        }
        return v;
    }

    public int getIpv6AddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(53);
        return childGroup.size();
    }

    public Ipv6Address getIpv6Address(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(53);
        return (Ipv6Address)childGroup.get(index);
    }

    public void setIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpv6Address(Ipv6Address value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 720;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof HostName) {
            try {
                this.addHostName((HostName)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.addIpAddress((IpAddress)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Ipv6Address) {
            try {
                this.addIpv6Address((Ipv6Address)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getHostNameCount();
        for (i = 0; i < objCnt; ++i) {
            this.getHostName(i).setReadonly();
        }
        objCnt = this.getIpAddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpAddress(i).setReadonly();
        }
        objCnt = this.getIpv6AddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpv6Address(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"IPAddressesHostNames".equals(element.getNodeName())) {
            throw new ValidationException("IPAddressesHostNames: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "HostName");
        for (i = 0; i < v.size(); ++i) {
            HostName hostNameObj = new HostName();
            hostNameObj.importFromElement(v.get(i));
            this.addHostName(hostNameObj);
        }
        v = XMLHelper.getChildElementByName(element, "IpAddress");
        for (i = 0; i < v.size(); ++i) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(i));
            this.addIpAddress(ipAddressObj);
        }
        v = XMLHelper.getChildElementByName(element, "Ipv6Address");
        for (i = 0; i < v.size(); ++i) {
            Ipv6Address ipv6AddressObj = new Ipv6Address();
            ipv6AddressObj.importFromElement(v.get(i));
            this.addIpv6Address(ipv6AddressObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("IPAddressesHostNames/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("IPAddressesHostNames/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("IPAddressesHostNames");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IPAddressesHostNames ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IPAddressesHostNames>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

