/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ICMPRequest
extends ConfigObject {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    public static final Integer MATCH_ALL_HOST_ADDR = 0;
    public static final Integer MATCH_ANY_HOST_ADDR = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private Integer mode;
    private String frequency;

    public ICMPRequest() {
        this(true);
    }

    public ICMPRequest(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(318, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(52, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(3, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(53, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ICMPRequest";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("ICMPRequest/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("ICMPRequest/Operator: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefMode() {
        return MATCH_ALL_HOST_ADDR;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "MATCH_ALL_HOST_ADDR";
                break;
            }
            case 1: {
                s = "MATCH_ANY_HOST_ADDR";
                break;
            }
            default: {
                throw new ValidationException("ICMPRequest/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("MATCH_ALL_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ALL_HOST_ADDR;
        } else if ("MATCH_ANY_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ANY_HOST_ADDR;
        } else {
            throw new ValidationException("ICMPRequest/Mode: invalid attribute value:" + value + "!");
        }
    }

    public String getOptFrequency() {
        return this.frequency;
    }

    public void setOptFrequency(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.frequency = value;
    }

    public void addDnsHost(DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDnsHost(int index, DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DnsHost> getDnsHost() {
        Vector<DnsHost> v = new Vector<DnsHost>();
        for (Transportable child : (ChildGroup)this.children.get(318)) {
            v.add((DnsHost)child);
        }
        return v;
    }

    public int getDnsHostCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(318);
        return childGroup.size();
    }

    public DnsHost getDnsHost(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(318);
        return (DnsHost)childGroup.get(index);
    }

    public void setDnsHost(int index, DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDnsHost(DnsHost value) {
        this.removeChild(value);
    }

    public void addIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IpAddress> getIpAddress() {
        Vector<IpAddress> v = new Vector<IpAddress>();
        for (Transportable child : (ChildGroup)this.children.get(52)) {
            v.add((IpAddress)child);
        }
        return v;
    }

    public int getIpAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return childGroup.size();
    }

    public IpAddress getIpAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        return (IpAddress)childGroup.get(index);
    }

    public void setIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpAddress(IpAddress value) {
        this.removeChild(value);
    }

    public void addObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ObjReference> getObjReference() {
        Vector<ObjReference> v = new Vector<ObjReference>();
        for (Transportable child : (ChildGroup)this.children.get(3)) {
            v.add((ObjReference)child);
        }
        return v;
    }

    public int getObjReferenceCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return childGroup.size();
    }

    public ObjReference getObjReference(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return (ObjReference)childGroup.get(index);
    }

    public ObjReference getObjReferenceByType(String type) {
        if (type == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType())) continue;
            return reference;
        }
        return null;
    }

    public ObjReference getObjReferenceByTypeAndName(String type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType()) || !name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    public void setObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeObjReference(ObjReference value) {
        this.removeChild(value);
    }

    public void addIpv6Address(Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Ipv6Address> getIpv6Address() {
        Vector<Ipv6Address> v = new Vector<Ipv6Address>();
        for (Transportable child : (ChildGroup)this.children.get(53)) {
            v.add((Ipv6Address)child);
        }
        return v;
    }

    public int getIpv6AddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(53);
        return childGroup.size();
    }

    public Ipv6Address getIpv6Address(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(53);
        return (Ipv6Address)childGroup.get(index);
    }

    public void setIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpv6Address(Ipv6Address value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 782;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof DnsHost) {
            try {
                this.addDnsHost((DnsHost)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.addIpAddress((IpAddress)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.addObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Ipv6Address) {
            try {
                this.addIpv6Address((Ipv6Address)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
            if ((value = attris.getValue("Mode")) != null) {
                this.setOptModeValue(value);
            }
            if ((value = attris.getValue("Frequency")) != null) {
                this.frequency = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getDnsHostCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDnsHost(i).setReadonly();
        }
        objCnt = this.getIpAddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpAddress(i).setReadonly();
        }
        objCnt = this.getObjReferenceCount();
        for (i = 0; i < objCnt; ++i) {
            this.getObjReference(i).setReadonly();
        }
        objCnt = this.getIpv6AddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpv6Address(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"ICMPRequest".equals(element.getNodeName())) {
            throw new ValidationException("ICMPRequest: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) != null) {
            this.setOptModeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Frequency")) != null) {
            this.frequency = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DnsHost");
        for (i = 0; i < v.size(); ++i) {
            DnsHost dnsHostObj = new DnsHost();
            dnsHostObj.importFromElement(v.get(i));
            this.addDnsHost(dnsHostObj);
        }
        v = XMLHelper.getChildElementByName(element, "IpAddress");
        for (i = 0; i < v.size(); ++i) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(i));
            this.addIpAddress(ipAddressObj);
        }
        v = XMLHelper.getChildElementByName(element, "ObjReference");
        for (i = 0; i < v.size(); ++i) {
            ObjReference objReferenceObj = new ObjReference();
            objReferenceObj.importFromElement(v.get(i));
            this.addObjReference(objReferenceObj);
        }
        v = XMLHelper.getChildElementByName(element, "Ipv6Address");
        for (i = 0; i < v.size(); ++i) {
            Ipv6Address ipv6AddressObj = new Ipv6Address();
            ipv6AddressObj.importFromElement(v.get(i));
            this.addIpv6Address(ipv6AddressObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ICMPRequest/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ICMPRequest/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ICMPRequest");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        if (this.frequency != null) {
            element.setAttribute("Frequency", this.frequency);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ICMPRequest ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.frequency != null) {
                strAttrs.append("Frequency=\"").append(AbstractSchema.checkXMLContent(this.frequency)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ICMPRequest>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

