/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.I18nCDATA;
import com.sygate.scm.common.configobject.schema.I18nString;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class I18nStrings
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String locale;
    private String version;

    public I18nStrings() {
        this(true);
    }

    public I18nStrings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(426, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(427, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "I18nStrings";
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.locale = value;
    }

    public String getOptVersion() {
        return this.version;
    }

    public void setOptVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public void addI18nString(I18nString value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addI18nString(int index, I18nString value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<I18nString> getI18nString() {
        Vector<I18nString> v = new Vector<I18nString>();
        for (Transportable child : (ChildGroup)this.children.get(426)) {
            v.add((I18nString)child);
        }
        return v;
    }

    public int getI18nStringCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(426);
        return childGroup.size();
    }

    public I18nString getI18nString(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(426);
        return (I18nString)childGroup.get(index);
    }

    public void setI18nString(int index, I18nString value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeI18nString(I18nString value) {
        this.removeChild(value);
    }

    public void addI18nCDATA(I18nCDATA value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addI18nCDATA(int index, I18nCDATA value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<I18nCDATA> getI18nCDATA() {
        Vector<I18nCDATA> v = new Vector<I18nCDATA>();
        for (Transportable child : (ChildGroup)this.children.get(427)) {
            v.add((I18nCDATA)child);
        }
        return v;
    }

    public int getI18nCDATACount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(427);
        return childGroup.size();
    }

    public I18nCDATA getI18nCDATA(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(427);
        return (I18nCDATA)childGroup.get(index);
    }

    public void setI18nCDATA(int index, I18nCDATA value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeI18nCDATA(I18nCDATA value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 425;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.locale == null) {
            throw new ValidationException("I18nStrings/Locale: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof I18nString) {
            try {
                this.addI18nString((I18nString)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof I18nCDATA) {
            try {
                this.addI18nCDATA((I18nCDATA)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Locale");
            if (value == null) {
                throw new ValidationException("I18nStrings/Locale: attribute is required!");
            }
            this.locale = value;
            value = attris.getValue("Version");
            if (value != null) {
                this.version = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getI18nStringCount();
        for (i = 0; i < objCnt; ++i) {
            this.getI18nString(i).setReadonly();
        }
        objCnt = this.getI18nCDATACount();
        for (i = 0; i < objCnt; ++i) {
            this.getI18nCDATA(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"I18nStrings".equals(element.getNodeName())) {
            throw new ValidationException("I18nStrings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Locale");
        if (value == null) {
            throw new ValidationException("I18nStrings/Locale: attribute is required!");
        }
        this.locale = value;
        value = XMLHelper.getAttribute(element, "Version");
        if (value != null) {
            this.version = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "I18nString");
        for (i = 0; i < v.size(); ++i) {
            I18nString i18nStringObj = new I18nString();
            i18nStringObj.importFromElement(v.get(i));
            this.addI18nString(i18nStringObj);
        }
        v = XMLHelper.getChildElementByName(element, "I18nCDATA");
        for (i = 0; i < v.size(); ++i) {
            I18nCDATA i18nCDATAObj = new I18nCDATA();
            i18nCDATAObj.importFromElement(v.get(i));
            this.addI18nCDATA(i18nCDATAObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("I18nStrings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("I18nStrings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("I18nStrings");
        if (this.locale != null) {
            element.setAttribute("Locale", this.locale);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<I18nStrings ");
            if (this.locale != null) {
                strAttrs.append("Locale=\"").append(AbstractSchema.checkXMLContent(this.locale)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</I18nStrings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

