/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HppNotifications
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean displayAlert;
    private Boolean lockDisplayAlert;
    private Boolean promptTerminateProcess;
    private Boolean lockPromptTerminateProcess;
    private Boolean promptStopService;
    private Boolean lockPromptStopService;

    public HppNotifications() {
        this(true);
    }

    public HppNotifications(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "HppNotifications";
    }

    public Boolean getDefDisplayAlert() {
        String productType = System.getProperty("Spc.Product.Type", "");
        return "SEPSB".equals(productType) ? Boolean.FALSE : Boolean.TRUE;
    }

    public Boolean getDisplayAlert() {
        return this.displayAlert;
    }

    public void setDisplayAlert(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayAlert = value;
    }

    public Boolean getDefLockDisplayAlert() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDisplayAlert() {
        return this.lockDisplayAlert;
    }

    public void setOptLockDisplayAlert(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDisplayAlert = value;
    }

    public Boolean getDefPromptTerminateProcess() {
        return Boolean.FALSE;
    }

    public Boolean getOptPromptTerminateProcess() {
        return this.promptTerminateProcess;
    }

    public void setOptPromptTerminateProcess(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.promptTerminateProcess = value;
    }

    public Boolean getDefLockPromptTerminateProcess() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockPromptTerminateProcess() {
        return this.lockPromptTerminateProcess;
    }

    public void setOptLockPromptTerminateProcess(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockPromptTerminateProcess = value;
    }

    public Boolean getDefPromptStopService() {
        return Boolean.FALSE;
    }

    public Boolean getOptPromptStopService() {
        return this.promptStopService;
    }

    public void setOptPromptStopService(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.promptStopService = value;
    }

    public Boolean getDefLockPromptStopService() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockPromptStopService() {
        return this.lockPromptStopService;
    }

    public void setOptLockPromptStopService(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockPromptStopService = value;
    }

    @Override
    public int getObjectType() {
        return 647;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.displayAlert == null) {
            throw new ValidationException("HppNotifications/DisplayAlert: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DisplayAlert");
            if (value == null) {
                throw new ValidationException("HppNotifications/DisplayAlert: attribute is required!");
            }
            this.displayAlert = "1".equals(value);
            value = attris.getValue("LockDisplayAlert");
            if (value != null) {
                this.lockDisplayAlert = "1".equals(value);
            }
            if ((value = attris.getValue("PromptTerminateProcess")) != null) {
                this.promptTerminateProcess = "1".equals(value);
            }
            if ((value = attris.getValue("LockPromptTerminateProcess")) != null) {
                this.lockPromptTerminateProcess = "1".equals(value);
            }
            if ((value = attris.getValue("PromptStopService")) != null) {
                this.promptStopService = "1".equals(value);
            }
            if ((value = attris.getValue("LockPromptStopService")) != null) {
                this.lockPromptStopService = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"HppNotifications".equals(element.getNodeName())) {
            throw new ValidationException("HppNotifications: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DisplayAlert");
        if (value == null) {
            throw new ValidationException("HppNotifications/DisplayAlert: attribute is required!");
        }
        this.displayAlert = "1".equals(value);
        value = XMLHelper.getAttribute(element, "LockDisplayAlert");
        if (value != null) {
            this.lockDisplayAlert = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PromptTerminateProcess")) != null) {
            this.promptTerminateProcess = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockPromptTerminateProcess")) != null) {
            this.lockPromptTerminateProcess = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PromptStopService")) != null) {
            this.promptStopService = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockPromptStopService")) != null) {
            this.lockPromptStopService = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HppNotifications/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HppNotifications/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HppNotifications");
        if (this.displayAlert != null) {
            element.setAttribute("DisplayAlert", this.displayAlert != false ? "1" : "0");
        }
        if (this.lockDisplayAlert != null) {
            element.setAttribute("LockDisplayAlert", this.lockDisplayAlert != false ? "1" : "0");
        }
        if (this.promptTerminateProcess != null) {
            element.setAttribute("PromptTerminateProcess", this.promptTerminateProcess != false ? "1" : "0");
        }
        if (this.lockPromptTerminateProcess != null) {
            element.setAttribute("LockPromptTerminateProcess", this.lockPromptTerminateProcess != false ? "1" : "0");
        }
        if (this.promptStopService != null) {
            element.setAttribute("PromptStopService", this.promptStopService != false ? "1" : "0");
        }
        if (this.lockPromptStopService != null) {
            element.setAttribute("LockPromptStopService", this.lockPromptStopService != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HppNotifications ");
            if (this.displayAlert != null) {
                strAttrs.append("DisplayAlert=").append(this.displayAlert != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockDisplayAlert != null) {
                strAttrs.append("LockDisplayAlert=").append(this.lockDisplayAlert != false ? "\"1\" " : "\"0\" ");
            }
            if (this.promptTerminateProcess != null) {
                strAttrs.append("PromptTerminateProcess=").append(this.promptTerminateProcess != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockPromptTerminateProcess != null) {
                strAttrs.append("LockPromptTerminateProcess=").append(this.lockPromptTerminateProcess != false ? "\"1\" " : "\"0\" ");
            }
            if (this.promptStopService != null) {
                strAttrs.append("PromptStopService=").append(this.promptStopService != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockPromptStopService != null) {
                strAttrs.append("LockPromptStopService=").append(this.lockPromptStopService != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HppNotifications>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

