/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HostIntegrityTrigger
extends ConfigObject {
    public static final Integer ALWAYS_OFF = 0;
    public static final Integer ALWAYS_ON = 1;
    public static final Integer BY_ENFORCER = 2;
    public static final Integer BY_SEM_SERVER = 3;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer hostIntegrityTrigger;
    private Long hostIntegrityTimer;

    public HostIntegrityTrigger() {
        this(true);
    }

    public HostIntegrityTrigger(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "HostIntegrityTrigger";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefHostIntegrityTrigger() {
        return BY_ENFORCER;
    }

    public Integer getOptHostIntegrityTrigger() {
        return this.hostIntegrityTrigger;
    }

    public String getOptHostIntegrityTriggerValue() throws ValidationException {
        if (this.hostIntegrityTrigger == null) {
            return null;
        }
        String s = null;
        switch (this.hostIntegrityTrigger) {
            case 0: {
                s = "ALWAYS_OFF";
                break;
            }
            case 1: {
                s = "ALWAYS_ON";
                break;
            }
            case 2: {
                s = "BY_ENFORCER";
                break;
            }
            case 3: {
                s = "BY_SEM_SERVER";
                break;
            }
            default: {
                throw new ValidationException("HostIntegrityTrigger/HostIntegrityTrigger: invalid attribute value:" + this.hostIntegrityTrigger + "!");
            }
        }
        return s;
    }

    public void setOptHostIntegrityTrigger(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hostIntegrityTrigger = value;
    }

    public void setOptHostIntegrityTriggerValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.hostIntegrityTrigger = null;
            return;
        }
        if ("ALWAYS_OFF".equals(value)) {
            this.hostIntegrityTrigger = ALWAYS_OFF;
        } else if ("ALWAYS_ON".equals(value)) {
            this.hostIntegrityTrigger = ALWAYS_ON;
        } else if ("BY_ENFORCER".equals(value)) {
            this.hostIntegrityTrigger = BY_ENFORCER;
        } else if ("BY_SEM_SERVER".equals(value)) {
            this.hostIntegrityTrigger = BY_SEM_SERVER;
        } else {
            throw new ValidationException("HostIntegrityTrigger/HostIntegrityTrigger: invalid attribute value:" + value + "!");
        }
    }

    public Long getDefHostIntegrityTimer() {
        return 120L;
    }

    public Long getOptHostIntegrityTimer() {
        return this.hostIntegrityTimer;
    }

    public void setOptHostIntegrityTimer(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hostIntegrityTimer = value;
    }

    @Override
    public int getObjectType() {
        return 388;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("HostIntegrityTrigger")) != null) {
                this.setOptHostIntegrityTriggerValue(value);
            }
            if ((value = attris.getValue("HostIntegrityTimer")) != null) {
                try {
                    this.hostIntegrityTimer = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("HostIntegrityTrigger/HostIntegrityTimer: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("HostIntegrityTrigger/HostIntegrityTimer: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"HostIntegrityTrigger".equals(element.getNodeName())) {
            throw new ValidationException("HostIntegrityTrigger: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HostIntegrityTrigger")) != null) {
            this.setOptHostIntegrityTriggerValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HostIntegrityTimer")) != null) {
            try {
                this.hostIntegrityTimer = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("HostIntegrityTrigger/HostIntegrityTimer: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HostIntegrityTrigger/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HostIntegrityTrigger/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HostIntegrityTrigger");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.hostIntegrityTrigger != null) {
            element.setAttribute("HostIntegrityTrigger", this.getOptHostIntegrityTriggerValue());
        }
        if (this.hostIntegrityTimer != null) {
            element.setAttribute("HostIntegrityTimer", this.hostIntegrityTimer.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HostIntegrityTrigger ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.hostIntegrityTrigger != null) {
                strAttrs.append("HostIntegrityTrigger=\"").append(this.getOptHostIntegrityTriggerValue()).append("\" ");
            }
            if (this.hostIntegrityTimer != null) {
                strAttrs.append("HostIntegrityTimer=\"").append(this.hostIntegrityTimer.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HostIntegrityTrigger>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

