/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.HiNotification;
import com.sygate.scm.common.configobject.schema.HiSnooze;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HostIntegritySetting
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Long maxHistoryTime;
    private Boolean checkProfileOnHistoryExpired;
    private Boolean continueExecWhenOneFailed;
    private Boolean disableVerboseLogging;
    private Boolean userLogonRequired;

    public HostIntegritySetting() {
        this(true);
    }

    public HostIntegritySetting(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(390, new ChildGroup(0, 1));
        this.children.put(394, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "HostIntegritySetting";
    }

    public Long getDefMaxHistoryTime() {
        return 2592000L;
    }

    public Long getOptMaxHistoryTime() {
        return this.maxHistoryTime;
    }

    public void setOptMaxHistoryTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.maxHistoryTime = value;
    }

    public Boolean getDefCheckProfileOnHistoryExpired() {
        return Boolean.TRUE;
    }

    public Boolean getOptCheckProfileOnHistoryExpired() {
        return this.checkProfileOnHistoryExpired;
    }

    public void setOptCheckProfileOnHistoryExpired(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkProfileOnHistoryExpired = value;
    }

    public Boolean getDefContinueExecWhenOneFailed() {
        return Boolean.FALSE;
    }

    public Boolean getOptContinueExecWhenOneFailed() {
        return this.continueExecWhenOneFailed;
    }

    public void setOptContinueExecWhenOneFailed(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.continueExecWhenOneFailed = value;
    }

    public Boolean getDefDisableVerboseLogging() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableVerboseLogging() {
        return this.disableVerboseLogging;
    }

    public void setOptDisableVerboseLogging(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableVerboseLogging = value;
    }

    public Boolean getDefUserLogonRequired() {
        return Boolean.TRUE;
    }

    public Boolean getOptUserLogonRequired() {
        return this.userLogonRequired;
    }

    public void setOptUserLogonRequired(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userLogonRequired = value;
    }

    public HiNotification getOptHiNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(390);
        if (childGroup.size() > 0) {
            return (HiNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptHiNotification(HiNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiNotification obj = this.getOptHiNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public HiSnooze getOptHiSnooze() {
        ChildGroup childGroup = (ChildGroup)this.children.get(394);
        if (childGroup.size() > 0) {
            return (HiSnooze)childGroup.get(0);
        }
        return null;
    }

    public void setOptHiSnooze(HiSnooze value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiSnooze obj = this.getOptHiSnooze();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 389;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof HiNotification) {
            try {
                this.setOptHiNotification((HiNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof HiSnooze) {
            try {
                this.setOptHiSnooze((HiSnooze)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("MaxHistoryTime");
            if (value != null) {
                try {
                    this.maxHistoryTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("HostIntegritySetting/MaxHistoryTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("HostIntegritySetting/MaxHistoryTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("CheckProfileOnHistoryExpired")) != null) {
                this.checkProfileOnHistoryExpired = "1".equals(value);
            }
            if ((value = attris.getValue("ContinueExecWhenOneFailed")) != null) {
                this.continueExecWhenOneFailed = "1".equals(value);
            }
            if ((value = attris.getValue("DisableVerboseLogging")) != null) {
                this.disableVerboseLogging = "1".equals(value);
            }
            if ((value = attris.getValue("UserLogonRequired")) != null) {
                this.userLogonRequired = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptHiNotification() != null) {
            this.getOptHiNotification().setReadonly();
        }
        if (this.getOptHiSnooze() != null) {
            this.getOptHiSnooze().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"HostIntegritySetting".equals(element.getNodeName())) {
            throw new ValidationException("HostIntegritySetting: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "MaxHistoryTime");
        if (value != null) {
            try {
                this.maxHistoryTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("HostIntegritySetting/MaxHistoryTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "CheckProfileOnHistoryExpired")) != null) {
            this.checkProfileOnHistoryExpired = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ContinueExecWhenOneFailed")) != null) {
            this.continueExecWhenOneFailed = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableVerboseLogging")) != null) {
            this.disableVerboseLogging = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserLogonRequired")) != null) {
            this.userLogonRequired = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "HiNotification")).size() > 0) {
            HiNotification hiNotificationObj = new HiNotification();
            hiNotificationObj.importFromElement(v.get(0));
            this.setOptHiNotification(hiNotificationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "HiSnooze")).size() > 0) {
            HiSnooze hiSnoozeObj = new HiSnooze();
            hiSnoozeObj.importFromElement(v.get(0));
            this.setOptHiSnooze(hiSnoozeObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HostIntegritySetting/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HostIntegritySetting/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HostIntegritySetting");
        if (this.maxHistoryTime != null) {
            element.setAttribute("MaxHistoryTime", this.maxHistoryTime.toString());
        }
        if (this.checkProfileOnHistoryExpired != null) {
            element.setAttribute("CheckProfileOnHistoryExpired", this.checkProfileOnHistoryExpired != false ? "1" : "0");
        }
        if (this.continueExecWhenOneFailed != null) {
            element.setAttribute("ContinueExecWhenOneFailed", this.continueExecWhenOneFailed != false ? "1" : "0");
        }
        if (this.disableVerboseLogging != null) {
            element.setAttribute("DisableVerboseLogging", this.disableVerboseLogging != false ? "1" : "0");
        }
        if (this.userLogonRequired != null) {
            element.setAttribute("UserLogonRequired", this.userLogonRequired != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HostIntegritySetting ");
            if (this.maxHistoryTime != null) {
                strAttrs.append("MaxHistoryTime=\"").append(this.maxHistoryTime.toString()).append("\" ");
            }
            if (this.checkProfileOnHistoryExpired != null) {
                strAttrs.append("CheckProfileOnHistoryExpired=").append(this.checkProfileOnHistoryExpired != false ? "\"1\" " : "\"0\" ");
            }
            if (this.continueExecWhenOneFailed != null) {
                strAttrs.append("ContinueExecWhenOneFailed=").append(this.continueExecWhenOneFailed != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableVerboseLogging != null) {
                strAttrs.append("DisableVerboseLogging=").append(this.disableVerboseLogging != false ? "\"1\" " : "\"0\" ");
            }
            if (this.userLogonRequired != null) {
                strAttrs.append("UserLogonRequired=").append(this.userLogonRequired != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HostIntegritySetting>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

