/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HiReqTemplate
extends ConfigObject
implements NamedObject {
    public static final Integer NORMAL = 0;
    public static final Integer NEW = 1;
    public static final Integer CHANGED = 2;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private String version;
    private Long lastModifiedTime;
    private Integer accessFlag;

    public HiReqTemplate() {
        this(true);
    }

    public HiReqTemplate(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(397, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "HiReqTemplate";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastModifiedTime = value;
    }

    public Integer getDefAccessFlag() {
        return NORMAL;
    }

    public Integer getOptAccessFlag() {
        return this.accessFlag;
    }

    public String getOptAccessFlagValue() throws ValidationException {
        if (this.accessFlag == null) {
            return null;
        }
        String s = null;
        switch (this.accessFlag) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "NEW";
                break;
            }
            case 2: {
                s = "CHANGED";
                break;
            }
            default: {
                throw new ValidationException("HiReqTemplate/AccessFlag: invalid attribute value:" + this.accessFlag + "!");
            }
        }
        return s;
    }

    public void setOptAccessFlag(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.accessFlag = value;
    }

    public void setOptAccessFlagValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.accessFlag = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.accessFlag = NORMAL;
        } else if ("NEW".equals(value)) {
            this.accessFlag = NEW;
        } else if ("CHANGED".equals(value)) {
            this.accessFlag = CHANGED;
        } else {
            throw new ValidationException("HiReqTemplate/AccessFlag: invalid attribute value:" + value + "!");
        }
    }

    public HiRequirement getHiRequirement() {
        ChildGroup childGroup = (ChildGroup)this.children.get(397);
        if (childGroup.size() > 0) {
            return (HiRequirement)childGroup.get(0);
        }
        return null;
    }

    public void setHiRequirement(HiRequirement value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiRequirement obj = this.getHiRequirement();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 419;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("HiReqTemplate/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("HiReqTemplate/Name: attribute is required!");
        }
        if (this.version == null) {
            throw new ValidationException("HiReqTemplate/Version: attribute is required!");
        }
        if (this.lastModifiedTime == null) {
            throw new ValidationException("HiReqTemplate/LastModifiedTime: attribute is required!");
        }
        if (this.getHiRequirement() == null) {
            throw new ValidationException("HiReqTemplate/HiRequirement: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof HiRequirement) {
            try {
                this.setHiRequirement((HiRequirement)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("HiReqTemplate/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("HiReqTemplate/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Version")) == null) {
                throw new ValidationException("HiReqTemplate/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("LastModifiedTime");
            if (value == null) {
                throw new ValidationException("HiReqTemplate/LastModifiedTime: attribute is required!");
            }
            try {
                this.lastModifiedTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("HiReqTemplate/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("HiReqTemplate/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("AccessFlag");
            if (value != null) {
                this.setOptAccessFlagValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getHiRequirement() != null) {
            this.getHiRequirement().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(397)).size();
        }
        catch (Throwable t) {
            throw new SAXException("HiReqTemplate: can't import element == HiRequirement!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"HiReqTemplate".equals(element.getNodeName())) {
            throw new ValidationException("HiReqTemplate: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("HiReqTemplate/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("HiReqTemplate/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Version")) == null) {
            throw new ValidationException("HiReqTemplate/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "LastModifiedTime");
        if (value == null) {
            throw new ValidationException("HiReqTemplate/LastModifiedTime: attribute is required!");
        }
        try {
            this.lastModifiedTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("HiReqTemplate/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("HiReqTemplate/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "AccessFlag");
        if (value != null) {
            this.setOptAccessFlagValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "HiRequirement")).size() != 1) {
            throw new ValidationException("HiReqTemplate/HiRequirement: element is require!");
        }
        HiRequirement hiRequirementObj = new HiRequirement();
        hiRequirementObj.importFromElement(v.get(0));
        this.setHiRequirement(hiRequirementObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HiReqTemplate/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HiReqTemplate/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HiReqTemplate");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.lastModifiedTime != null) {
            element.setAttribute("LastModifiedTime", this.lastModifiedTime.toString());
        }
        if (this.accessFlag != null) {
            element.setAttribute("AccessFlag", this.getOptAccessFlagValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HiReqTemplate ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.lastModifiedTime != null) {
                strAttrs.append("LastModifiedTime=\"").append(this.lastModifiedTime.toString()).append("\" ");
            }
            if (this.accessFlag != null) {
                strAttrs.append("AccessFlag=\"").append(this.getOptAccessFlagValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HiReqTemplate>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

