/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HiPredefinedReqName
extends ConfigObject {
    public static final Integer ENFORCE_AV = 0;
    public static final Integer ENFORCE_FW = 1;
    public static final Integer ENFORCE_SP = 2;
    public static final Integer ENFORCE_PATC = 3;
    public static final Integer ENFORCE_ASW = 4;
    private static final long serialVersionUID = 1L;
    private String macroName;
    private String macroDisplayName;
    private Integer macroType;

    public HiPredefinedReqName() {
        this(true);
    }

    public HiPredefinedReqName(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "HiPredefinedReqName";
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.macroName = value;
    }

    public String getMacroDisplayName() {
        return this.macroDisplayName;
    }

    public void setMacroDisplayName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.macroDisplayName = value;
    }

    public Integer getMacroType() {
        return this.macroType;
    }

    public String getMacroTypeValue() throws ValidationException {
        if (this.macroType == null) {
            return null;
        }
        String s = null;
        switch (this.macroType) {
            case 0: {
                s = "ENFORCE_AV";
                break;
            }
            case 1: {
                s = "ENFORCE_FW";
                break;
            }
            case 2: {
                s = "ENFORCE_SP";
                break;
            }
            case 3: {
                s = "ENFORCE_PATC";
                break;
            }
            case 4: {
                s = "ENFORCE_ASW";
                break;
            }
            default: {
                throw new ValidationException("HiPredefinedReqName/MacroType: invalid attribute value:" + this.macroType + "!");
            }
        }
        return s;
    }

    public void setMacroType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.macroType = value;
    }

    public void setMacroTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ENFORCE_AV".equals(value)) {
            this.macroType = ENFORCE_AV;
        } else if ("ENFORCE_FW".equals(value)) {
            this.macroType = ENFORCE_FW;
        } else if ("ENFORCE_SP".equals(value)) {
            this.macroType = ENFORCE_SP;
        } else if ("ENFORCE_PATC".equals(value)) {
            this.macroType = ENFORCE_PATC;
        } else if ("ENFORCE_ASW".equals(value)) {
            this.macroType = ENFORCE_ASW;
        } else {
            throw new ValidationException("HiPredefinedReqName/MacroType: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 422;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.macroName == null) {
            throw new ValidationException("HiPredefinedReqName/MacroName: attribute is required!");
        }
        if (this.macroDisplayName == null) {
            throw new ValidationException("HiPredefinedReqName/MacroDisplayName: attribute is required!");
        }
        if (this.macroType == null) {
            throw new ValidationException("HiPredefinedReqName/MacroType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("MacroName");
            if (value == null) {
                throw new ValidationException("HiPredefinedReqName/MacroName: attribute is required!");
            }
            this.macroName = value;
            value = attris.getValue("MacroDisplayName");
            if (value == null) {
                throw new ValidationException("HiPredefinedReqName/MacroDisplayName: attribute is required!");
            }
            this.macroDisplayName = value;
            value = attris.getValue("MacroType");
            if (value == null) {
                throw new ValidationException("HiPredefinedReqName/MacroType: attribute is required!");
            }
            this.setMacroTypeValue(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"HiPredefinedReqName".equals(element.getNodeName())) {
            throw new ValidationException("HiPredefinedReqName: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "MacroName");
        if (value == null) {
            throw new ValidationException("HiPredefinedReqName/MacroName: attribute is required!");
        }
        this.macroName = value;
        value = XMLHelper.getAttribute(element, "MacroDisplayName");
        if (value == null) {
            throw new ValidationException("HiPredefinedReqName/MacroDisplayName: attribute is required!");
        }
        this.macroDisplayName = value;
        value = XMLHelper.getAttribute(element, "MacroType");
        if (value == null) {
            throw new ValidationException("HiPredefinedReqName/MacroType: attribute is required!");
        }
        this.setMacroTypeValue(value);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HiPredefinedReqName/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HiPredefinedReqName/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HiPredefinedReqName");
        if (this.macroName != null) {
            element.setAttribute("MacroName", this.macroName);
        }
        if (this.macroDisplayName != null) {
            element.setAttribute("MacroDisplayName", this.macroDisplayName);
        }
        if (this.macroType != null) {
            element.setAttribute("MacroType", this.getMacroTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HiPredefinedReqName ");
            if (this.macroName != null) {
                strAttrs.append("MacroName=\"").append(AbstractSchema.checkXMLContent(this.macroName)).append("\" ");
            }
            if (this.macroDisplayName != null) {
                strAttrs.append("MacroDisplayName=\"").append(AbstractSchema.checkXMLContent(this.macroDisplayName)).append("\" ");
            }
            if (this.macroType != null) {
                strAttrs.append("MacroType=\"").append(this.getMacroTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HiPredefinedReqName>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

