/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.HiCONDITION;
import com.sygate.scm.common.configobject.schema.HiELSE;
import com.sygate.scm.common.configobject.schema.HiTHEN;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HiIF
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String comment;

    public HiIF() {
        this(true);
    }

    public HiIF(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(405, new ChildGroup(1, 1));
        this.children.put(410, new ChildGroup(1, 1));
        this.children.put(411, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "HiIF";
    }

    public String getOptComment() {
        return this.comment;
    }

    public void setOptComment(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.comment = value;
    }

    public HiCONDITION getHiCONDITION() {
        ChildGroup childGroup = (ChildGroup)this.children.get(405);
        if (childGroup.size() > 0) {
            return (HiCONDITION)childGroup.get(0);
        }
        return null;
    }

    public void setHiCONDITION(HiCONDITION value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiCONDITION obj = this.getHiCONDITION();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public HiTHEN getHiTHEN() {
        ChildGroup childGroup = (ChildGroup)this.children.get(410);
        if (childGroup.size() > 0) {
            return (HiTHEN)childGroup.get(0);
        }
        return null;
    }

    public void setHiTHEN(HiTHEN value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiTHEN obj = this.getHiTHEN();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public HiELSE getOptHiELSE() {
        ChildGroup childGroup = (ChildGroup)this.children.get(411);
        if (childGroup.size() > 0) {
            return (HiELSE)childGroup.get(0);
        }
        return null;
    }

    public void setOptHiELSE(HiELSE value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HiELSE obj = this.getOptHiELSE();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 404;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getHiCONDITION() == null) {
            throw new ValidationException("HiIF/HiCONDITION: attribute is required!");
        }
        if (this.getHiTHEN() == null) {
            throw new ValidationException("HiIF/HiTHEN: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof HiCONDITION) {
            try {
                this.setHiCONDITION((HiCONDITION)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof HiTHEN) {
            try {
                this.setHiTHEN((HiTHEN)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof HiELSE) {
            try {
                this.setOptHiELSE((HiELSE)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Comment");
            if (value != null) {
                this.comment = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getHiCONDITION() != null) {
            this.getHiCONDITION().setReadonly();
        }
        if (this.getHiTHEN() != null) {
            this.getHiTHEN().setReadonly();
        }
        if (this.getOptHiELSE() != null) {
            this.getOptHiELSE().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(405)).size();
        }
        catch (Throwable t) {
            throw new SAXException("HiIF: can't import element == HiCONDITION!");
        }
        try {
            ((ChildGroup)this.children.get(410)).size();
        }
        catch (Throwable t) {
            throw new SAXException("HiIF: can't import element == HiTHEN!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"HiIF".equals(element.getNodeName())) {
            throw new ValidationException("HiIF: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Comment");
        if (value != null) {
            this.comment = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "HiCONDITION")).size() != 1) {
            throw new ValidationException("HiIF/HiCONDITION: element is require!");
        }
        HiCONDITION hiCONDITIONObj = new HiCONDITION();
        hiCONDITIONObj.importFromElement(v.get(0));
        this.setHiCONDITION(hiCONDITIONObj);
        v = XMLHelper.getChildElementByName(element, "HiTHEN");
        if (v.size() != 1) {
            throw new ValidationException("HiIF/HiTHEN: element is require!");
        }
        HiTHEN hiTHENObj = new HiTHEN();
        hiTHENObj.importFromElement(v.get(0));
        this.setHiTHEN(hiTHENObj);
        v = XMLHelper.getChildElementByName(element, "HiELSE");
        if (v.size() > 0) {
            HiELSE hiELSEObj = new HiELSE();
            hiELSEObj.importFromElement(v.get(0));
            this.setOptHiELSE(hiELSEObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("HiIF/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("HiIF/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("HiIF");
        if (this.comment != null) {
            element.setAttribute("Comment", this.comment);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HiIF ");
            if (this.comment != null) {
                strAttrs.append("Comment=\"").append(AbstractSchema.checkXMLContent(this.comment)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HiIF>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

