/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.NotificationDisplayTime;
import com.sygate.scm.common.configobject.schema.SecurityEventNotification;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GuiNotification
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean enableVisualNotification;
    private Boolean enableSoundNotification;
    private Boolean enableIconFlashingOnNotification;

    public GuiNotification() {
        this(true);
    }

    public GuiNotification(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(223, new ChildGroup(0, 1));
        this.children.put(224, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "GuiNotification";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefEnableVisualNotification() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnableVisualNotification() {
        return this.enableVisualNotification;
    }

    public void setOptEnableVisualNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableVisualNotification = value;
    }

    public Boolean getDefEnableSoundNotification() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnableSoundNotification() {
        return this.enableSoundNotification;
    }

    public void setOptEnableSoundNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableSoundNotification = value;
    }

    public Boolean getDefEnableIconFlashingOnNotification() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableIconFlashingOnNotification() {
        return this.enableIconFlashingOnNotification;
    }

    public void setOptEnableIconFlashingOnNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableIconFlashingOnNotification = value;
    }

    public SecurityEventNotification getOptSecurityEventNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(223);
        if (childGroup.size() > 0) {
            return (SecurityEventNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptSecurityEventNotification(SecurityEventNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SecurityEventNotification obj = this.getOptSecurityEventNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public NotificationDisplayTime getOptNotificationDisplayTime() {
        ChildGroup childGroup = (ChildGroup)this.children.get(224);
        if (childGroup.size() > 0) {
            return (NotificationDisplayTime)childGroup.get(0);
        }
        return null;
    }

    public void setOptNotificationDisplayTime(NotificationDisplayTime value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NotificationDisplayTime obj = this.getOptNotificationDisplayTime();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 222;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SecurityEventNotification) {
            try {
                this.setOptSecurityEventNotification((SecurityEventNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NotificationDisplayTime) {
            try {
                this.setOptNotificationDisplayTime((NotificationDisplayTime)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("EnableVisualNotification")) != null) {
                this.enableVisualNotification = "1".equals(value);
            }
            if ((value = attris.getValue("EnableSoundNotification")) != null) {
                this.enableSoundNotification = "1".equals(value);
            }
            if ((value = attris.getValue("EnableIconFlashingOnNotification")) != null) {
                this.enableIconFlashingOnNotification = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptSecurityEventNotification() != null) {
            this.getOptSecurityEventNotification().setReadonly();
        }
        if (this.getOptNotificationDisplayTime() != null) {
            this.getOptNotificationDisplayTime().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"GuiNotification".equals(element.getNodeName())) {
            throw new ValidationException("GuiNotification: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableVisualNotification")) != null) {
            this.enableVisualNotification = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableSoundNotification")) != null) {
            this.enableSoundNotification = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableIconFlashingOnNotification")) != null) {
            this.enableIconFlashingOnNotification = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SecurityEventNotification")).size() > 0) {
            SecurityEventNotification securityEventNotificationObj = new SecurityEventNotification();
            securityEventNotificationObj.importFromElement(v.get(0));
            this.setOptSecurityEventNotification(securityEventNotificationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NotificationDisplayTime")).size() > 0) {
            NotificationDisplayTime notificationDisplayTimeObj = new NotificationDisplayTime();
            notificationDisplayTimeObj.importFromElement(v.get(0));
            this.setOptNotificationDisplayTime(notificationDisplayTimeObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("GuiNotification/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("GuiNotification/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("GuiNotification");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.enableVisualNotification != null) {
            element.setAttribute("EnableVisualNotification", this.enableVisualNotification != false ? "1" : "0");
        }
        if (this.enableSoundNotification != null) {
            element.setAttribute("EnableSoundNotification", this.enableSoundNotification != false ? "1" : "0");
        }
        if (this.enableIconFlashingOnNotification != null) {
            element.setAttribute("EnableIconFlashingOnNotification", this.enableIconFlashingOnNotification != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<GuiNotification ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableVisualNotification != null) {
                strAttrs.append("EnableVisualNotification=").append(this.enableVisualNotification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableSoundNotification != null) {
                strAttrs.append("EnableSoundNotification=").append(this.enableSoundNotification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableIconFlashingOnNotification != null) {
                strAttrs.append("EnableIconFlashingOnNotification=").append(this.enableIconFlashingOnNotification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</GuiNotification>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

