/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CommonImageExclusion;
import com.sygate.scm.common.configobject.schema.ScanLess;
import com.sygate.scm.common.configobject.schema.SharedInsightCache;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GeneralInfo
extends ConfigObject {
    public static final Integer NEVER = 0;
    public static final Integer ONCE = 1;
    public static final Integer ALWAYS = 2;
    public static final Integer RESTORE = 3;
    public static final Integer ENABLE = 0;
    public static final Integer DISABLE = 1;
    public static final Integer NO_ACTION = 2;
    private static final long serialVersionUID = 1L;
    private Integer disableSecurityCenter;
    private Integer securityCenterAvAlert;
    private Integer displayAfterDays;
    private Integer displayAfterDaysLB;
    private Boolean lockHomepageAddress;
    private String homepageAddress;
    private Boolean lockUnloadServices;
    private Boolean useScanNetDrivePassword;
    private String netScanPassword;
    private String netScanPassword2;
    private Boolean lockNetScanPassword;
    private Boolean displayErrorPopup;
    private Boolean displayDefaultSupportSite;
    private String customizedSupportSite;
    private String errorMessage;
    private Boolean coexistence;

    public GeneralInfo() {
        this(true);
    }

    public GeneralInfo(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(666, new ChildGroup(0, 1));
        this.children.put(667, new ChildGroup(0, 1));
        this.children.put(668, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "GeneralInfo";
    }

    public Integer getDefDisableSecurityCenter() {
        return NEVER;
    }

    public Integer getDisableSecurityCenter() {
        return this.disableSecurityCenter;
    }

    public String getDisableSecurityCenterValue() throws ValidationException {
        if (this.disableSecurityCenter == null) {
            return null;
        }
        String s = null;
        switch (this.disableSecurityCenter) {
            case 0: {
                s = "NEVER";
                break;
            }
            case 1: {
                s = "ONCE";
                break;
            }
            case 2: {
                s = "ALWAYS";
                break;
            }
            case 3: {
                s = "RESTORE";
                break;
            }
            default: {
                throw new ValidationException("GeneralInfo/DisableSecurityCenter: invalid attribute value:" + this.disableSecurityCenter + "!");
            }
        }
        return s;
    }

    public void setDisableSecurityCenter(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableSecurityCenter = value;
    }

    public void setDisableSecurityCenterValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NEVER".equals(value)) {
            this.disableSecurityCenter = NEVER;
        } else if ("ONCE".equals(value)) {
            this.disableSecurityCenter = ONCE;
        } else if ("ALWAYS".equals(value)) {
            this.disableSecurityCenter = ALWAYS;
        } else if ("RESTORE".equals(value)) {
            this.disableSecurityCenter = RESTORE;
        } else {
            throw new ValidationException("GeneralInfo/DisableSecurityCenter: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefSecurityCenterAvAlert() {
        return NO_ACTION;
    }

    public Integer getSecurityCenterAvAlert() {
        return this.securityCenterAvAlert;
    }

    public String getSecurityCenterAvAlertValue() throws ValidationException {
        if (this.securityCenterAvAlert == null) {
            return null;
        }
        String s = null;
        switch (this.securityCenterAvAlert) {
            case 0: {
                s = "ENABLE";
                break;
            }
            case 1: {
                s = "DISABLE";
                break;
            }
            case 2: {
                s = "NO_ACTION";
                break;
            }
            default: {
                throw new ValidationException("GeneralInfo/SecurityCenterAvAlert: invalid attribute value:" + this.securityCenterAvAlert + "!");
            }
        }
        return s;
    }

    public void setSecurityCenterAvAlert(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.securityCenterAvAlert = value;
    }

    public void setSecurityCenterAvAlertValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ENABLE".equals(value)) {
            this.securityCenterAvAlert = ENABLE;
        } else if ("DISABLE".equals(value)) {
            this.securityCenterAvAlert = DISABLE;
        } else if ("NO_ACTION".equals(value)) {
            this.securityCenterAvAlert = NO_ACTION;
        } else {
            throw new ValidationException("GeneralInfo/SecurityCenterAvAlert: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefDisplayAfterDays() {
        return 7;
    }

    public Integer getOptDisplayAfterDays() {
        return this.displayAfterDays;
    }

    public void setOptDisplayAfterDays(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayAfterDays = value;
    }

    public Integer getDefDisplayAfterDaysLB() {
        return 30;
    }

    public Integer getOptDisplayAfterDaysLB() {
        return this.displayAfterDaysLB;
    }

    public void setOptDisplayAfterDaysLB(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayAfterDaysLB = value;
    }

    public Boolean getDefLockHomepageAddress() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockHomepageAddress() {
        return this.lockHomepageAddress;
    }

    public void setOptLockHomepageAddress(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockHomepageAddress = value;
    }

    public String getOptHomepageAddress() {
        return this.homepageAddress;
    }

    public void setOptHomepageAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.homepageAddress = value;
    }

    public Boolean getDefLockUnloadServices() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockUnloadServices() {
        return this.lockUnloadServices;
    }

    public void setOptLockUnloadServices(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockUnloadServices = value;
    }

    public Boolean getDefUseScanNetDrivePassword() {
        return Boolean.FALSE;
    }

    public Boolean getOptUseScanNetDrivePassword() {
        return this.useScanNetDrivePassword;
    }

    public void setOptUseScanNetDrivePassword(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useScanNetDrivePassword = value;
    }

    public String getDefNetScanPassword() {
        return "52E3BBAFC627009AC13CAFF1200A0DBF";
    }

    public String getOptNetScanPassword() {
        try {
            return Utility.decrypt(this.netScanPassword);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptNetScanPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.netScanPassword = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDefNetScanPassword2() {
        return "015BDB0E7E16A7ECF94E71F8F791F36FC9ED17AAFF381C9413F431B6C9888BF16C9FF2B6A8EC4ABD77DFF2FA600296DD865EDB21E4F64E887AB528F206E222A7A9";
    }

    public String getOptNetScanPassword2() {
        try {
            return Utility.decrypt(this.netScanPassword2);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptNetScanPassword2(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.netScanPassword2 = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean getDefLockNetScanPassword() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockNetScanPassword() {
        return this.lockNetScanPassword;
    }

    public void setOptLockNetScanPassword(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockNetScanPassword = value;
    }

    public Boolean getDefDisplayErrorPopup() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisplayErrorPopup() {
        return this.displayErrorPopup;
    }

    public void setOptDisplayErrorPopup(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayErrorPopup = value;
    }

    public Boolean getDefDisplayDefaultSupportSite() {
        return Boolean.TRUE;
    }

    public Boolean getOptDisplayDefaultSupportSite() {
        return this.displayDefaultSupportSite;
    }

    public void setOptDisplayDefaultSupportSite(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayDefaultSupportSite = value;
    }

    public String getOptCustomizedSupportSite() {
        return this.customizedSupportSite;
    }

    public void setOptCustomizedSupportSite(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.customizedSupportSite = value;
    }

    public String getOptErrorMessage() {
        return this.errorMessage;
    }

    public void setOptErrorMessage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.errorMessage = value;
    }

    public Boolean getDefCoexistence() {
        return Boolean.FALSE;
    }

    public Boolean getOptCoexistence() {
        return this.coexistence;
    }

    public void setOptCoexistence(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.coexistence = value;
    }

    public ScanLess getOptScanLess() {
        ChildGroup childGroup = (ChildGroup)this.children.get(666);
        if (childGroup.size() > 0) {
            return (ScanLess)childGroup.get(0);
        }
        return null;
    }

    public void setOptScanLess(ScanLess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ScanLess obj = this.getOptScanLess();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SharedInsightCache getOptSharedInsightCache() {
        ChildGroup childGroup = (ChildGroup)this.children.get(667);
        if (childGroup.size() > 0) {
            return (SharedInsightCache)childGroup.get(0);
        }
        return null;
    }

    public void setOptSharedInsightCache(SharedInsightCache value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SharedInsightCache obj = this.getOptSharedInsightCache();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public CommonImageExclusion getOptCommonImageExclusion() {
        ChildGroup childGroup = (ChildGroup)this.children.get(668);
        if (childGroup.size() > 0) {
            return (CommonImageExclusion)childGroup.get(0);
        }
        return null;
    }

    public void setOptCommonImageExclusion(CommonImageExclusion value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CommonImageExclusion obj = this.getOptCommonImageExclusion();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 587;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.disableSecurityCenter == null) {
            throw new ValidationException("GeneralInfo/DisableSecurityCenter: attribute is required!");
        }
        if (this.securityCenterAvAlert == null) {
            throw new ValidationException("GeneralInfo/SecurityCenterAvAlert: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ScanLess) {
            try {
                this.setOptScanLess((ScanLess)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SharedInsightCache) {
            try {
                this.setOptSharedInsightCache((SharedInsightCache)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof CommonImageExclusion) {
            try {
                this.setOptCommonImageExclusion((CommonImageExclusion)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DisableSecurityCenter");
            if (value == null) {
                throw new ValidationException("GeneralInfo/DisableSecurityCenter: attribute is required!");
            }
            this.setDisableSecurityCenterValue(value);
            value = attris.getValue("SecurityCenterAvAlert");
            if (value == null) {
                throw new ValidationException("GeneralInfo/SecurityCenterAvAlert: attribute is required!");
            }
            this.setSecurityCenterAvAlertValue(value);
            value = attris.getValue("DisplayAfterDays");
            if (value != null) {
                try {
                    this.displayAfterDays = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("GeneralInfo/DisplayAfterDays: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("GeneralInfo/DisplayAfterDays: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DisplayAfterDaysLB")) != null) {
                try {
                    this.displayAfterDaysLB = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("GeneralInfo/DisplayAfterDaysLB: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("GeneralInfo/DisplayAfterDaysLB: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LockHomepageAddress")) != null) {
                this.lockHomepageAddress = "1".equals(value);
            }
            if ((value = attris.getValue("HomepageAddress")) != null) {
                this.homepageAddress = value;
            }
            if ((value = attris.getValue("LockUnloadServices")) != null) {
                this.lockUnloadServices = "1".equals(value);
            }
            if ((value = attris.getValue("UseScanNetDrivePassword")) != null) {
                this.useScanNetDrivePassword = "1".equals(value);
            }
            if ((value = attris.getValue("NetScanPassword")) != null) {
                this.netScanPassword = value;
            }
            if ((value = attris.getValue("NetScanPassword2")) != null) {
                this.netScanPassword2 = value;
            }
            if ((value = attris.getValue("LockNetScanPassword")) != null) {
                this.lockNetScanPassword = "1".equals(value);
            }
            if ((value = attris.getValue("DisplayErrorPopup")) != null) {
                this.displayErrorPopup = "1".equals(value);
            }
            if ((value = attris.getValue("DisplayDefaultSupportSite")) != null) {
                this.displayDefaultSupportSite = "1".equals(value);
            }
            if ((value = attris.getValue("CustomizedSupportSite")) != null) {
                this.customizedSupportSite = value;
            }
            if ((value = attris.getValue("ErrorMessage")) != null) {
                this.errorMessage = value;
            }
            if ((value = attris.getValue("Coexistence")) != null) {
                this.coexistence = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptScanLess() != null) {
            this.getOptScanLess().setReadonly();
        }
        if (this.getOptSharedInsightCache() != null) {
            this.getOptSharedInsightCache().setReadonly();
        }
        if (this.getOptCommonImageExclusion() != null) {
            this.getOptCommonImageExclusion().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"GeneralInfo".equals(element.getNodeName())) {
            throw new ValidationException("GeneralInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DisableSecurityCenter");
        if (value == null) {
            throw new ValidationException("GeneralInfo/DisableSecurityCenter: attribute is required!");
        }
        this.setDisableSecurityCenterValue(value);
        value = XMLHelper.getAttribute(element, "SecurityCenterAvAlert");
        if (value == null) {
            throw new ValidationException("GeneralInfo/SecurityCenterAvAlert: attribute is required!");
        }
        this.setSecurityCenterAvAlertValue(value);
        value = XMLHelper.getAttribute(element, "DisplayAfterDays");
        if (value != null) {
            try {
                this.displayAfterDays = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("GeneralInfo/DisplayAfterDays: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayAfterDaysLB")) != null) {
            try {
                this.displayAfterDaysLB = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("GeneralInfo/DisplayAfterDaysLB: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LockHomepageAddress")) != null) {
            this.lockHomepageAddress = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HomepageAddress")) != null) {
            this.homepageAddress = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockUnloadServices")) != null) {
            this.lockUnloadServices = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UseScanNetDrivePassword")) != null) {
            this.useScanNetDrivePassword = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NetScanPassword")) != null) {
            this.netScanPassword = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NetScanPassword2")) != null) {
            this.netScanPassword2 = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockNetScanPassword")) != null) {
            this.lockNetScanPassword = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayErrorPopup")) != null) {
            this.displayErrorPopup = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayDefaultSupportSite")) != null) {
            this.displayDefaultSupportSite = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CustomizedSupportSite")) != null) {
            this.customizedSupportSite = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ErrorMessage")) != null) {
            this.errorMessage = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Coexistence")) != null) {
            this.coexistence = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ScanLess")).size() > 0) {
            ScanLess scanLessObj = new ScanLess();
            scanLessObj.importFromElement(v.get(0));
            this.setOptScanLess(scanLessObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SharedInsightCache")).size() > 0) {
            SharedInsightCache sharedInsightCacheObj = new SharedInsightCache();
            sharedInsightCacheObj.importFromElement(v.get(0));
            this.setOptSharedInsightCache(sharedInsightCacheObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "CommonImageExclusion")).size() > 0) {
            CommonImageExclusion commonImageExclusionObj = new CommonImageExclusion();
            commonImageExclusionObj.importFromElement(v.get(0));
            this.setOptCommonImageExclusion(commonImageExclusionObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("GeneralInfo/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("GeneralInfo/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("GeneralInfo");
        if (this.disableSecurityCenter != null) {
            element.setAttribute("DisableSecurityCenter", this.getDisableSecurityCenterValue());
        }
        if (this.securityCenterAvAlert != null) {
            element.setAttribute("SecurityCenterAvAlert", this.getSecurityCenterAvAlertValue());
        }
        if (this.displayAfterDays != null) {
            element.setAttribute("DisplayAfterDays", this.displayAfterDays.toString());
        }
        if (this.displayAfterDaysLB != null) {
            element.setAttribute("DisplayAfterDaysLB", this.displayAfterDaysLB.toString());
        }
        if (this.lockHomepageAddress != null) {
            element.setAttribute("LockHomepageAddress", this.lockHomepageAddress != false ? "1" : "0");
        }
        if (this.homepageAddress != null) {
            element.setAttribute("HomepageAddress", this.homepageAddress);
        }
        if (this.lockUnloadServices != null) {
            element.setAttribute("LockUnloadServices", this.lockUnloadServices != false ? "1" : "0");
        }
        if (this.useScanNetDrivePassword != null) {
            element.setAttribute("UseScanNetDrivePassword", this.useScanNetDrivePassword != false ? "1" : "0");
        }
        if (this.netScanPassword != null) {
            element.setAttribute("NetScanPassword", this.netScanPassword);
        }
        if (this.netScanPassword2 != null) {
            element.setAttribute("NetScanPassword2", this.netScanPassword2);
        }
        if (this.lockNetScanPassword != null) {
            element.setAttribute("LockNetScanPassword", this.lockNetScanPassword != false ? "1" : "0");
        }
        if (this.displayErrorPopup != null) {
            element.setAttribute("DisplayErrorPopup", this.displayErrorPopup != false ? "1" : "0");
        }
        if (this.displayDefaultSupportSite != null) {
            element.setAttribute("DisplayDefaultSupportSite", this.displayDefaultSupportSite != false ? "1" : "0");
        }
        if (this.customizedSupportSite != null) {
            element.setAttribute("CustomizedSupportSite", this.customizedSupportSite);
        }
        if (this.errorMessage != null) {
            element.setAttribute("ErrorMessage", this.errorMessage);
        }
        if (this.coexistence != null) {
            element.setAttribute("Coexistence", this.coexistence != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<GeneralInfo ");
            if (this.disableSecurityCenter != null) {
                strAttrs.append("DisableSecurityCenter=\"").append(this.getDisableSecurityCenterValue()).append("\" ");
            }
            if (this.securityCenterAvAlert != null) {
                strAttrs.append("SecurityCenterAvAlert=\"").append(this.getSecurityCenterAvAlertValue()).append("\" ");
            }
            if (this.displayAfterDays != null) {
                strAttrs.append("DisplayAfterDays=\"").append(this.displayAfterDays.toString()).append("\" ");
            }
            if (this.displayAfterDaysLB != null) {
                strAttrs.append("DisplayAfterDaysLB=\"").append(this.displayAfterDaysLB.toString()).append("\" ");
            }
            if (this.lockHomepageAddress != null) {
                strAttrs.append("LockHomepageAddress=").append(this.lockHomepageAddress != false ? "\"1\" " : "\"0\" ");
            }
            if (this.homepageAddress != null) {
                strAttrs.append("HomepageAddress=\"").append(AbstractSchema.checkXMLContent(this.homepageAddress)).append("\" ");
            }
            if (this.lockUnloadServices != null) {
                strAttrs.append("LockUnloadServices=").append(this.lockUnloadServices != false ? "\"1\" " : "\"0\" ");
            }
            if (this.useScanNetDrivePassword != null) {
                strAttrs.append("UseScanNetDrivePassword=").append(this.useScanNetDrivePassword != false ? "\"1\" " : "\"0\" ");
            }
            if (this.netScanPassword != null) {
                strAttrs.append("NetScanPassword=\"").append(AbstractSchema.checkXMLContent(this.netScanPassword)).append("\" ");
            }
            if (this.netScanPassword2 != null) {
                strAttrs.append("NetScanPassword2=\"").append(AbstractSchema.checkXMLContent(this.netScanPassword2)).append("\" ");
            }
            if (this.lockNetScanPassword != null) {
                strAttrs.append("LockNetScanPassword=").append(this.lockNetScanPassword != false ? "\"1\" " : "\"0\" ");
            }
            if (this.displayErrorPopup != null) {
                strAttrs.append("DisplayErrorPopup=").append(this.displayErrorPopup != false ? "\"1\" " : "\"0\" ");
            }
            if (this.displayDefaultSupportSite != null) {
                strAttrs.append("DisplayDefaultSupportSite=").append(this.displayDefaultSupportSite != false ? "\"1\" " : "\"0\" ");
            }
            if (this.customizedSupportSite != null) {
                strAttrs.append("CustomizedSupportSite=\"").append(AbstractSchema.checkXMLContent(this.customizedSupportSite)).append("\" ");
            }
            if (this.errorMessage != null) {
                strAttrs.append("ErrorMessage=\"").append(AbstractSchema.checkXMLContent(this.errorMessage)).append("\" ");
            }
            if (this.coexistence != null) {
                strAttrs.append("Coexistence=").append(this.coexistence != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</GeneralInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

