/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIcmp;
import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FwProtocolContainer
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String containerName;
    private String containerDescription;

    public FwProtocolContainer() {
        this(true);
    }

    public FwProtocolContainer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(310, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(311, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(312, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(313, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(314, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(315, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "FwProtocolContainer";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getOptContainerName() {
        return this.containerName;
    }

    public void setOptContainerName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.containerName = value;
    }

    public String getOptContainerDescription() {
        return this.containerDescription;
    }

    public void setOptContainerDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.containerDescription = value;
    }

    public void addRawEthernet(RawEthernet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawEthernet(int index, RawEthernet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawEthernet> getRawEthernet() {
        Vector<RawEthernet> v = new Vector<RawEthernet>();
        for (Transportable child : (ChildGroup)this.children.get(310)) {
            v.add((RawEthernet)child);
        }
        return v;
    }

    public int getRawEthernetCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(310);
        return childGroup.size();
    }

    public RawEthernet getRawEthernet(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(310);
        return (RawEthernet)childGroup.get(index);
    }

    public void setRawEthernet(int index, RawEthernet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawEthernet(RawEthernet value) {
        this.removeChild(value);
    }

    public void addRawIp(RawIp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawIp(int index, RawIp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawIp> getRawIp() {
        Vector<RawIp> v = new Vector<RawIp>();
        for (Transportable child : (ChildGroup)this.children.get(311)) {
            v.add((RawIp)child);
        }
        return v;
    }

    public int getRawIpCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(311);
        return childGroup.size();
    }

    public RawIp getRawIp(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(311);
        return (RawIp)childGroup.get(index);
    }

    public void setRawIp(int index, RawIp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawIp(RawIp value) {
        this.removeChild(value);
    }

    public void addRawIcmp(RawIcmp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawIcmp(int index, RawIcmp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawIcmp> getRawIcmp() {
        Vector<RawIcmp> v = new Vector<RawIcmp>();
        for (Transportable child : (ChildGroup)this.children.get(312)) {
            v.add((RawIcmp)child);
        }
        return v;
    }

    public int getRawIcmpCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(312);
        return childGroup.size();
    }

    public RawIcmp getRawIcmp(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(312);
        return (RawIcmp)childGroup.get(index);
    }

    public void setRawIcmp(int index, RawIcmp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawIcmp(RawIcmp value) {
        this.removeChild(value);
    }

    public void addRawIcmpv6(RawIcmpv6 value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawIcmpv6(int index, RawIcmpv6 value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawIcmpv6> getRawIcmpv6() {
        Vector<RawIcmpv6> v = new Vector<RawIcmpv6>();
        for (Transportable child : (ChildGroup)this.children.get(313)) {
            v.add((RawIcmpv6)child);
        }
        return v;
    }

    public int getRawIcmpv6Count() {
        ChildGroup childGroup = (ChildGroup)this.children.get(313);
        return childGroup.size();
    }

    public RawIcmpv6 getRawIcmpv6(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(313);
        return (RawIcmpv6)childGroup.get(index);
    }

    public void setRawIcmpv6(int index, RawIcmpv6 value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawIcmpv6(RawIcmpv6 value) {
        this.removeChild(value);
    }

    public void addRawUdp(RawUdp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawUdp(int index, RawUdp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawUdp> getRawUdp() {
        Vector<RawUdp> v = new Vector<RawUdp>();
        for (Transportable child : (ChildGroup)this.children.get(314)) {
            v.add((RawUdp)child);
        }
        return v;
    }

    public int getRawUdpCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(314);
        return childGroup.size();
    }

    public RawUdp getRawUdp(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(314);
        return (RawUdp)childGroup.get(index);
    }

    public void setRawUdp(int index, RawUdp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawUdp(RawUdp value) {
        this.removeChild(value);
    }

    public void addRawTcp(RawTcp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRawTcp(int index, RawTcp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RawTcp> getRawTcp() {
        Vector<RawTcp> v = new Vector<RawTcp>();
        for (Transportable child : (ChildGroup)this.children.get(315)) {
            v.add((RawTcp)child);
        }
        return v;
    }

    public int getRawTcpCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(315);
        return childGroup.size();
    }

    public RawTcp getRawTcp(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(315);
        return (RawTcp)childGroup.get(index);
    }

    public void setRawTcp(int index, RawTcp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRawTcp(RawTcp value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 309;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof RawEthernet) {
            try {
                this.addRawEthernet((RawEthernet)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RawIp) {
            try {
                this.addRawIp((RawIp)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RawIcmp) {
            try {
                this.addRawIcmp((RawIcmp)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RawIcmpv6) {
            try {
                this.addRawIcmpv6((RawIcmpv6)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RawUdp) {
            try {
                this.addRawUdp((RawUdp)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RawTcp) {
            try {
                this.addRawTcp((RawTcp)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("ContainerName")) != null) {
                this.containerName = value;
            }
            if ((value = attris.getValue("ContainerDescription")) != null) {
                this.containerDescription = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getRawEthernetCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRawEthernet(i).setReadonly();
        }
        objCnt = this.getRawIpCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRawIp(i).setReadonly();
        }
        objCnt = this.getRawIcmpCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRawIcmp(i).setReadonly();
        }
        objCnt = this.getRawIcmpv6Count();
        for (i = 0; i < objCnt; ++i) {
            this.getRawIcmpv6(i).setReadonly();
        }
        objCnt = this.getRawUdpCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRawUdp(i).setReadonly();
        }
        objCnt = this.getRawTcpCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRawTcp(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"FwProtocolContainer".equals(element.getNodeName())) {
            throw new ValidationException("FwProtocolContainer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ContainerName")) != null) {
            this.containerName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ContainerDescription")) != null) {
            this.containerDescription = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "RawEthernet");
        for (i = 0; i < v.size(); ++i) {
            RawEthernet rawEthernetObj = new RawEthernet();
            rawEthernetObj.importFromElement(v.get(i));
            this.addRawEthernet(rawEthernetObj);
        }
        v = XMLHelper.getChildElementByName(element, "RawIp");
        for (i = 0; i < v.size(); ++i) {
            RawIp rawIpObj = new RawIp();
            rawIpObj.importFromElement(v.get(i));
            this.addRawIp(rawIpObj);
        }
        v = XMLHelper.getChildElementByName(element, "RawIcmp");
        for (i = 0; i < v.size(); ++i) {
            RawIcmp rawIcmpObj = new RawIcmp();
            rawIcmpObj.importFromElement(v.get(i));
            this.addRawIcmp(rawIcmpObj);
        }
        v = XMLHelper.getChildElementByName(element, "RawIcmpv6");
        for (i = 0; i < v.size(); ++i) {
            RawIcmpv6 rawIcmpv6Obj = new RawIcmpv6();
            rawIcmpv6Obj.importFromElement(v.get(i));
            this.addRawIcmpv6(rawIcmpv6Obj);
        }
        v = XMLHelper.getChildElementByName(element, "RawUdp");
        for (i = 0; i < v.size(); ++i) {
            RawUdp rawUdpObj = new RawUdp();
            rawUdpObj.importFromElement(v.get(i));
            this.addRawUdp(rawUdpObj);
        }
        v = XMLHelper.getChildElementByName(element, "RawTcp");
        for (i = 0; i < v.size(); ++i) {
            RawTcp rawTcpObj = new RawTcp();
            rawTcpObj.importFromElement(v.get(i));
            this.addRawTcp(rawTcpObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FwProtocolContainer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FwProtocolContainer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FwProtocolContainer");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.containerName != null) {
            element.setAttribute("ContainerName", this.containerName);
        }
        if (this.containerDescription != null) {
            element.setAttribute("ContainerDescription", this.containerDescription);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FwProtocolContainer ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.containerName != null) {
                strAttrs.append("ContainerName=\"").append(AbstractSchema.checkXMLContent(this.containerName)).append("\" ");
            }
            if (this.containerDescription != null) {
                strAttrs.append("ContainerDescription=\"").append(AbstractSchema.checkXMLContent(this.containerDescription)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FwProtocolContainer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

