/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FwNetworkInterface
extends ConfigObject {
    public static final Integer PPTP = 0;
    public static final Integer VPN = 1;
    public static final Integer ALL = 2;
    public static final Integer ETHERNET = 3;
    public static final Integer DUN = 4;
    public static final Integer WLAN = 5;
    public static final Integer VP_CISCO3000 = 6;
    public static final Integer VP_SAFENET = 7;
    public static final Integer VP_CHECKPOINT = 8;
    public static final Integer VP_NETSCREEN = 9;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean include;
    private Integer networkInterfaceType;
    private String networkInterfaceDescString;

    public FwNetworkInterface() {
        this(true);
    }

    public FwNetworkInterface(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(52, new ChildGroup(0, 1));
        this.children.put(54, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "FwNetworkInterface";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getInclude() {
        return this.include;
    }

    public void setInclude(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.include = value;
    }

    public Integer getOptNetworkInterfaceType() {
        return this.networkInterfaceType;
    }

    public String getOptNetworkInterfaceTypeValue() throws ValidationException {
        if (this.networkInterfaceType == null) {
            return null;
        }
        String s = null;
        switch (this.networkInterfaceType) {
            case 0: {
                s = "PPTP";
                break;
            }
            case 1: {
                s = "VPN";
                break;
            }
            case 2: {
                s = "ALL";
                break;
            }
            case 3: {
                s = "ETHERNET";
                break;
            }
            case 4: {
                s = "DUN";
                break;
            }
            case 5: {
                s = "WLAN";
                break;
            }
            case 6: {
                s = "VP_CISCO3000";
                break;
            }
            case 7: {
                s = "VP_SAFENET";
                break;
            }
            case 8: {
                s = "VP_CHECKPOINT";
                break;
            }
            case 9: {
                s = "VP_NETSCREEN";
                break;
            }
            default: {
                throw new ValidationException("FwNetworkInterface/NetworkInterfaceType: invalid attribute value:" + this.networkInterfaceType + "!");
            }
        }
        return s;
    }

    public void setOptNetworkInterfaceType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.networkInterfaceType = value;
    }

    public void setOptNetworkInterfaceTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.networkInterfaceType = null;
            return;
        }
        if ("PPTP".equals(value)) {
            this.networkInterfaceType = PPTP;
        } else if ("VPN".equals(value)) {
            this.networkInterfaceType = VPN;
        } else if ("ALL".equals(value)) {
            this.networkInterfaceType = ALL;
        } else if ("ETHERNET".equals(value)) {
            this.networkInterfaceType = ETHERNET;
        } else if ("DUN".equals(value)) {
            this.networkInterfaceType = DUN;
        } else if ("WLAN".equals(value)) {
            this.networkInterfaceType = WLAN;
        } else if ("VP_CISCO3000".equals(value)) {
            this.networkInterfaceType = VP_CISCO3000;
        } else if ("VP_SAFENET".equals(value)) {
            this.networkInterfaceType = VP_SAFENET;
        } else if ("VP_CHECKPOINT".equals(value)) {
            this.networkInterfaceType = VP_CHECKPOINT;
        } else if ("VP_NETSCREEN".equals(value)) {
            this.networkInterfaceType = VP_NETSCREEN;
        } else {
            throw new ValidationException("FwNetworkInterface/NetworkInterfaceType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptNetworkInterfaceDescString() {
        return this.networkInterfaceDescString;
    }

    public void setOptNetworkInterfaceDescString(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.networkInterfaceDescString = value;
    }

    public IpAddress getOptIpAddress() {
        ChildGroup childGroup = (ChildGroup)this.children.get(52);
        if (childGroup.size() > 0) {
            return (IpAddress)childGroup.get(0);
        }
        return null;
    }

    public void setOptIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IpAddress obj = this.getOptIpAddress();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SubNet getOptSubNet() {
        ChildGroup childGroup = (ChildGroup)this.children.get(54);
        if (childGroup.size() > 0) {
            return (SubNet)childGroup.get(0);
        }
        return null;
    }

    public void setOptSubNet(SubNet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SubNet obj = this.getOptSubNet();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 322;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.include == null) {
            throw new ValidationException("FwNetworkInterface/Include: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.setOptIpAddress((IpAddress)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SubNet) {
            try {
                this.setOptSubNet((SubNet)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Include")) == null) {
                throw new ValidationException("FwNetworkInterface/Include: attribute is required!");
            }
            this.include = "1".equals(value);
            value = attris.getValue("NetworkInterfaceType");
            if (value != null) {
                this.setOptNetworkInterfaceTypeValue(value);
            }
            if ((value = attris.getValue("NetworkInterfaceDescString")) != null) {
                this.networkInterfaceDescString = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptIpAddress() != null) {
            this.getOptIpAddress().setReadonly();
        }
        if (this.getOptSubNet() != null) {
            this.getOptSubNet().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"FwNetworkInterface".equals(element.getNodeName())) {
            throw new ValidationException("FwNetworkInterface: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Include")) == null) {
            throw new ValidationException("FwNetworkInterface/Include: attribute is required!");
        }
        this.include = "1".equals(value);
        value = XMLHelper.getAttribute(element, "NetworkInterfaceType");
        if (value != null) {
            this.setOptNetworkInterfaceTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NetworkInterfaceDescString")) != null) {
            this.networkInterfaceDescString = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "IpAddress")).size() > 0) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(0));
            this.setOptIpAddress(ipAddressObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SubNet")).size() > 0) {
            SubNet subNetObj = new SubNet();
            subNetObj.importFromElement(v.get(0));
            this.setOptSubNet(subNetObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FwNetworkInterface/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FwNetworkInterface/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FwNetworkInterface");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.include != null) {
            element.setAttribute("Include", this.include != false ? "1" : "0");
        }
        if (this.networkInterfaceType != null) {
            element.setAttribute("NetworkInterfaceType", this.getOptNetworkInterfaceTypeValue());
        }
        if (this.networkInterfaceDescString != null) {
            element.setAttribute("NetworkInterfaceDescString", this.networkInterfaceDescString);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FwNetworkInterface ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.include != null) {
                strAttrs.append("Include=").append(this.include != false ? "\"1\" " : "\"0\" ");
            }
            if (this.networkInterfaceType != null) {
                strAttrs.append("NetworkInterfaceType=\"").append(this.getOptNetworkInterfaceTypeValue()).append("\" ");
            }
            if (this.networkInterfaceDescString != null) {
                strAttrs.append("NetworkInterfaceDescString=\"").append(AbstractSchema.checkXMLContent(this.networkInterfaceDescString)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FwNetworkInterface>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

