/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.EnabledObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.MacFwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FwFirewallPolicy
extends TopLevelObject
implements NamedObject,
EnabledObject {
    public static final Integer Simple = 0;
    public static final Integer Advance = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String mode;
    private Integer macMode;
    private String type;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Long objAttributes;
    private String creator;

    public FwFirewallPolicy() {
        this(true);
    }

    public FwFirewallPolicy(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(334, new ChildGroup(0, 1));
        this.children.put(335, new ChildGroup(0, 1));
        this.children.put(355, new ChildGroup(1, 1));
        this.children.put(823, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "FwFirewallPolicy";
    }

    @Override
    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    @Override
    public Boolean getOptEnable() {
        return this.enable;
    }

    @Override
    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getDefMode() {
        return "simple";
    }

    public String getOptMode() {
        return this.mode;
    }

    public void setOptMode(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public Integer getDefMacMode() {
        return Advance;
    }

    public Integer getOptMacMode() {
        return this.macMode;
    }

    public String getOptMacModeValue() throws ValidationException {
        if (this.macMode == null) {
            return null;
        }
        String s = null;
        switch (this.macMode) {
            case 0: {
                s = "Simple";
                break;
            }
            case 1: {
                s = "Advance";
                break;
            }
            default: {
                throw new ValidationException("FwFirewallPolicy/MacMode: invalid attribute value:" + this.macMode + "!");
            }
        }
        return s;
    }

    public void setOptMacMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.macMode = value;
    }

    public void setOptMacModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.macMode = null;
            return;
        }
        if ("Simple".equals(value)) {
            this.macMode = Simple;
        } else if ("Advance".equals(value)) {
            this.macMode = Advance;
        } else {
            throw new ValidationException("FwFirewallPolicy/MacMode: invalid attribute value:" + value + "!");
        }
    }

    public String getDefType() {
        return "simple";
    }

    public String getOptType() {
        return this.type;
    }

    public void setOptType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Long getDefObjAttributes() {
        return 0L;
    }

    public Long getOptObjAttributes() {
        return this.objAttributes;
    }

    public void setOptObjAttributes(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.objAttributes = value;
    }

    public String getOptCreator() {
        return this.creator;
    }

    public void setOptCreator(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creator = value;
    }

    public MacFwFirewallPolicy getOptMacFwFirewallPolicy() {
        ChildGroup childGroup = (ChildGroup)this.children.get(334);
        if (childGroup.size() > 0) {
            return (MacFwFirewallPolicy)childGroup.get(0);
        }
        return null;
    }

    public void setOptMacFwFirewallPolicy(MacFwFirewallPolicy value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MacFwFirewallPolicy obj = this.getOptMacFwFirewallPolicy();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public FirewallRuleSystem getOptFirewallRuleSystem() {
        ChildGroup childGroup = (ChildGroup)this.children.get(335);
        if (childGroup.size() > 0) {
            return (FirewallRuleSystem)childGroup.get(0);
        }
        return null;
    }

    public void setOptFirewallRuleSystem(FirewallRuleSystem value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FirewallRuleSystem obj = this.getOptFirewallRuleSystem();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SecuritySetting getSecuritySetting() {
        ChildGroup childGroup = (ChildGroup)this.children.get(355);
        if (childGroup.size() > 0) {
            return (SecuritySetting)childGroup.get(0);
        }
        return null;
    }

    public void setSecuritySetting(SecuritySetting value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SecuritySetting obj = this.getSecuritySetting();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addSourceInfo(SourceInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSourceInfo(int index, SourceInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SourceInfo> getSourceInfo() {
        Vector<SourceInfo> v = new Vector<SourceInfo>();
        for (Transportable child : (ChildGroup)this.children.get(823)) {
            v.add((SourceInfo)child);
        }
        return v;
    }

    public int getSourceInfoCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(823);
        return childGroup.size();
    }

    public SourceInfo getSourceInfo(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(823);
        return (SourceInfo)childGroup.get(index);
    }

    public void setSourceInfo(int index, SourceInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSourceInfo(SourceInfo value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 323;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("FwFirewallPolicy/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("FwFirewallPolicy/Name: attribute is required!");
        }
        if (this.getSecuritySetting() == null) {
            throw new ValidationException("FwFirewallPolicy/SecuritySetting: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof MacFwFirewallPolicy) {
            try {
                this.setOptMacFwFirewallPolicy((MacFwFirewallPolicy)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof FirewallRuleSystem) {
            try {
                this.setOptFirewallRuleSystem((FirewallRuleSystem)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SecuritySetting) {
            try {
                this.setSecuritySetting((SecuritySetting)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SourceInfo) {
            try {
                this.addSourceInfo((SourceInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Mode")) != null) {
                this.mode = value;
            }
            if ((value = attris.getValue("MacMode")) != null) {
                this.setOptMacModeValue(value);
            }
            if ((value = attris.getValue("Type")) != null) {
                this.type = value;
            }
            if ((value = attris.getValue("Id")) == null) {
                throw new ValidationException("FwFirewallPolicy/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("FwFirewallPolicy/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("ObjAttributes")) != null) {
                try {
                    this.objAttributes = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("FwFirewallPolicy/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("FwFirewallPolicy/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Creator")) != null) {
                this.creator = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getOptMacFwFirewallPolicy() != null) {
            this.getOptMacFwFirewallPolicy().setReadonly();
        }
        if (this.getOptFirewallRuleSystem() != null) {
            this.getOptFirewallRuleSystem().setReadonly();
        }
        if (this.getSecuritySetting() != null) {
            this.getSecuritySetting().setReadonly();
        }
        int objCnt = this.getSourceInfoCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSourceInfo(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(355)).size();
        }
        catch (Throwable t) {
            throw new SAXException("FwFirewallPolicy: can't import element == SecuritySetting!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"FwFirewallPolicy".equals(element.getNodeName())) {
            throw new ValidationException("FwFirewallPolicy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) != null) {
            this.mode = value;
        }
        if ((value = XMLHelper.getAttribute(element, "MacMode")) != null) {
            this.setOptMacModeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Type")) != null) {
            this.type = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) == null) {
            throw new ValidationException("FwFirewallPolicy/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("FwFirewallPolicy/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ObjAttributes")) != null) {
            try {
                this.objAttributes = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("FwFirewallPolicy/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Creator")) != null) {
            this.creator = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "MacFwFirewallPolicy")).size() > 0) {
            MacFwFirewallPolicy macFwFirewallPolicyObj = new MacFwFirewallPolicy();
            macFwFirewallPolicyObj.importFromElement(v.get(0));
            this.setOptMacFwFirewallPolicy(macFwFirewallPolicyObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "FirewallRuleSystem")).size() > 0) {
            FirewallRuleSystem firewallRuleSystemObj = new FirewallRuleSystem();
            firewallRuleSystemObj.importFromElement(v.get(0));
            this.setOptFirewallRuleSystem(firewallRuleSystemObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SecuritySetting")).size() != 1) {
            throw new ValidationException("FwFirewallPolicy/SecuritySetting: element is require!");
        }
        SecuritySetting securitySettingObj = new SecuritySetting();
        securitySettingObj.importFromElement(v.get(0));
        this.setSecuritySetting(securitySettingObj);
        v = XMLHelper.getChildElementByName(element, "SourceInfo");
        for (int i = 0; i < v.size(); ++i) {
            SourceInfo sourceInfoObj = new SourceInfo();
            sourceInfoObj.importFromElement(v.get(i));
            this.addSourceInfo(sourceInfoObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FwFirewallPolicy/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FwFirewallPolicy/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FwFirewallPolicy");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.mode);
        }
        if (this.macMode != null) {
            element.setAttribute("MacMode", this.getOptMacModeValue());
        }
        if (this.type != null) {
            element.setAttribute("Type", this.type);
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.objAttributes != null) {
            element.setAttribute("ObjAttributes", this.objAttributes.toString());
        }
        if (this.creator != null) {
            element.setAttribute("Creator", this.creator);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FwFirewallPolicy ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(AbstractSchema.checkXMLContent(this.mode)).append("\" ");
            }
            if (this.macMode != null) {
                strAttrs.append("MacMode=\"").append(this.getOptMacModeValue()).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(AbstractSchema.checkXMLContent(this.type)).append("\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.objAttributes != null) {
                strAttrs.append("ObjAttributes=\"").append(this.objAttributes.toString()).append("\" ");
            }
            if (this.creator != null) {
                strAttrs.append("Creator=\"").append(AbstractSchema.checkXMLContent(this.creator)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FwFirewallPolicy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

