/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ForwardedEvent
extends ConfigObject {
    public static final Integer SCAN_INFECTION = 0;
    public static final Integer VIRUS_DEF = 1;
    public static final Integer CONFIG = 2;
    public static final Integer STARTUP = 3;
    public static final Integer LICENSE = 4;
    private static final long serialVersionUID = 1L;
    private Long packageID;
    private Long eventID;
    private Integer eventType;
    private Boolean forward;

    public ForwardedEvent() {
        this(true);
    }

    public ForwardedEvent(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ForwardedEvent";
    }

    public Long getPackageID() {
        return this.packageID;
    }

    public void setPackageID(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packageID = value;
    }

    public Long getEventID() {
        return this.eventID;
    }

    public void setEventID(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.eventID = value;
    }

    public Integer getDefEventType() {
        return SCAN_INFECTION;
    }

    public Integer getOptEventType() {
        return this.eventType;
    }

    public String getOptEventTypeValue() throws ValidationException {
        if (this.eventType == null) {
            return null;
        }
        String s = null;
        switch (this.eventType) {
            case 0: {
                s = "SCAN_INFECTION";
                break;
            }
            case 1: {
                s = "VIRUS_DEF";
                break;
            }
            case 2: {
                s = "CONFIG";
                break;
            }
            case 3: {
                s = "STARTUP";
                break;
            }
            case 4: {
                s = "LICENSE";
                break;
            }
            default: {
                throw new ValidationException("ForwardedEvent/EventType: invalid attribute value:" + this.eventType + "!");
            }
        }
        return s;
    }

    public void setOptEventType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.eventType = value;
    }

    public void setOptEventTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.eventType = null;
            return;
        }
        if ("SCAN_INFECTION".equals(value)) {
            this.eventType = SCAN_INFECTION;
        } else if ("VIRUS_DEF".equals(value)) {
            this.eventType = VIRUS_DEF;
        } else if ("CONFIG".equals(value)) {
            this.eventType = CONFIG;
        } else if ("STARTUP".equals(value)) {
            this.eventType = STARTUP;
        } else if ("LICENSE".equals(value)) {
            this.eventType = LICENSE;
        } else {
            throw new ValidationException("ForwardedEvent/EventType: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefForward() {
        return Boolean.FALSE;
    }

    public Boolean getOptForward() {
        return this.forward;
    }

    public void setOptForward(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.forward = value;
    }

    @Override
    public int getObjectType() {
        return 589;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.packageID == null) {
            throw new ValidationException("ForwardedEvent/PackageID: attribute is required!");
        }
        if (this.eventID == null) {
            throw new ValidationException("ForwardedEvent/EventID: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("PackageID");
            if (value == null) {
                throw new ValidationException("ForwardedEvent/PackageID: attribute is required!");
            }
            try {
                this.packageID = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("ForwardedEvent/PackageID: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("ForwardedEvent/PackageID: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("EventID");
            if (value == null) {
                throw new ValidationException("ForwardedEvent/EventID: attribute is required!");
            }
            try {
                this.eventID = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("ForwardedEvent/EventID: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("ForwardedEvent/EventID: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("EventType");
            if (value != null) {
                this.setOptEventTypeValue(value);
            }
            if ((value = attris.getValue("Forward")) != null) {
                this.forward = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ForwardedEvent".equals(element.getNodeName())) {
            throw new ValidationException("ForwardedEvent: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "PackageID");
        if (value == null) {
            throw new ValidationException("ForwardedEvent/PackageID: attribute is required!");
        }
        try {
            this.packageID = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("ForwardedEvent/PackageID: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("ForwardedEvent/PackageID: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "EventID");
        if (value == null) {
            throw new ValidationException("ForwardedEvent/EventID: attribute is required!");
        }
        try {
            this.eventID = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("ForwardedEvent/EventID: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("ForwardedEvent/EventID: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "EventType");
        if (value != null) {
            this.setOptEventTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Forward")) != null) {
            this.forward = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ForwardedEvent/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ForwardedEvent/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ForwardedEvent");
        if (this.packageID != null) {
            element.setAttribute("PackageID", this.packageID.toString());
        }
        if (this.eventID != null) {
            element.setAttribute("EventID", this.eventID.toString());
        }
        if (this.eventType != null) {
            element.setAttribute("EventType", this.getOptEventTypeValue());
        }
        if (this.forward != null) {
            element.setAttribute("Forward", this.forward != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ForwardedEvent ");
            if (this.packageID != null) {
                strAttrs.append("PackageID=\"").append(this.packageID.toString()).append("\" ");
            }
            if (this.eventID != null) {
                strAttrs.append("EventID=\"").append(this.eventID.toString()).append("\" ");
            }
            if (this.eventType != null) {
                strAttrs.append("EventType=\"").append(this.getOptEventTypeValue()).append("\" ");
            }
            if (this.forward != null) {
                strAttrs.append("Forward=").append(this.forward != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ForwardedEvent>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

