/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FloppySettings
extends ConfigObject {
    public static final Integer CLEAN = 0;
    public static final Integer LEAVE_ALONE = 1;
    private static final long serialVersionUID = 1L;
    private Boolean checkForBootVirus;
    private Boolean lockCheckForBootVirus;
    private Integer actionForBootVirus;

    public FloppySettings() {
        this(true);
    }

    public FloppySettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "FloppySettings";
    }

    public Boolean getDefCheckForBootVirus() {
        return Boolean.TRUE;
    }

    public Boolean getOptCheckForBootVirus() {
        return this.checkForBootVirus;
    }

    public void setOptCheckForBootVirus(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkForBootVirus = value;
    }

    public Boolean getDefLockCheckForBootVirus() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockCheckForBootVirus() {
        return this.lockCheckForBootVirus;
    }

    public void setOptLockCheckForBootVirus(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockCheckForBootVirus = value;
    }

    public Integer getDefActionForBootVirus() {
        return CLEAN;
    }

    public Integer getOptActionForBootVirus() {
        return this.actionForBootVirus;
    }

    public String getOptActionForBootVirusValue() throws ValidationException {
        if (this.actionForBootVirus == null) {
            return null;
        }
        String s = null;
        switch (this.actionForBootVirus) {
            case 0: {
                s = "CLEAN";
                break;
            }
            case 1: {
                s = "LEAVE_ALONE";
                break;
            }
            default: {
                throw new ValidationException("FloppySettings/ActionForBootVirus: invalid attribute value:" + this.actionForBootVirus + "!");
            }
        }
        return s;
    }

    public void setOptActionForBootVirus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.actionForBootVirus = value;
    }

    public void setOptActionForBootVirusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.actionForBootVirus = null;
            return;
        }
        if ("CLEAN".equals(value)) {
            this.actionForBootVirus = CLEAN;
        } else if ("LEAVE_ALONE".equals(value)) {
            this.actionForBootVirus = LEAVE_ALONE;
        } else {
            throw new ValidationException("FloppySettings/ActionForBootVirus: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 614;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("CheckForBootVirus");
            if (value != null) {
                this.checkForBootVirus = "1".equals(value);
            }
            if ((value = attris.getValue("LockCheckForBootVirus")) != null) {
                this.lockCheckForBootVirus = "1".equals(value);
            }
            if ((value = attris.getValue("ActionForBootVirus")) != null) {
                this.setOptActionForBootVirusValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"FloppySettings".equals(element.getNodeName())) {
            throw new ValidationException("FloppySettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "CheckForBootVirus");
        if (value != null) {
            this.checkForBootVirus = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockCheckForBootVirus")) != null) {
            this.lockCheckForBootVirus = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ActionForBootVirus")) != null) {
            this.setOptActionForBootVirusValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FloppySettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FloppySettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FloppySettings");
        if (this.checkForBootVirus != null) {
            element.setAttribute("CheckForBootVirus", this.checkForBootVirus != false ? "1" : "0");
        }
        if (this.lockCheckForBootVirus != null) {
            element.setAttribute("LockCheckForBootVirus", this.lockCheckForBootVirus != false ? "1" : "0");
        }
        if (this.actionForBootVirus != null) {
            element.setAttribute("ActionForBootVirus", this.getOptActionForBootVirusValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FloppySettings ");
            if (this.checkForBootVirus != null) {
                strAttrs.append("CheckForBootVirus=").append(this.checkForBootVirus != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockCheckForBootVirus != null) {
                strAttrs.append("LockCheckForBootVirus=").append(this.lockCheckForBootVirus != false ? "\"1\" " : "\"0\" ");
            }
            if (this.actionForBootVirus != null) {
                strAttrs.append("ActionForBootVirus=\"").append(this.getOptActionForBootVirusValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FloppySettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

