/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Filter
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String targetType;
    private String version;
    private String targetProduct;
    private String targetClientPlatform;
    private Boolean obsolete;
    private Boolean suspended;

    public Filter() {
        this(true);
    }

    public Filter(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "Filter";
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetType = value;
    }

    public String getOptVersion() {
        return this.version;
    }

    public void setOptVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public String getOptTargetProduct() {
        return this.targetProduct;
    }

    public void setOptTargetProduct(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetProduct = value;
    }

    public String getOptTargetClientPlatform() {
        return this.targetClientPlatform;
    }

    public void setOptTargetClientPlatform(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.targetClientPlatform = value;
    }

    public Boolean getOptObsolete() {
        return this.obsolete;
    }

    public void setOptObsolete(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.obsolete = value;
    }

    public Boolean getOptSuspended() {
        return this.suspended;
    }

    public void setOptSuspended(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.suspended = value;
    }

    @Override
    public int getObjectType() {
        return 745;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.targetType == null) {
            throw new ValidationException("Filter/TargetType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("TargetType");
            if (value == null) {
                throw new ValidationException("Filter/TargetType: attribute is required!");
            }
            this.targetType = value;
            value = attris.getValue("Version");
            if (value != null) {
                this.version = value;
            }
            if ((value = attris.getValue("TargetProduct")) != null) {
                this.targetProduct = value;
            }
            if ((value = attris.getValue("TargetClientPlatform")) != null) {
                this.targetClientPlatform = value;
            }
            if ((value = attris.getValue("Obsolete")) != null) {
                this.obsolete = "1".equals(value);
            }
            if ((value = attris.getValue("Suspended")) != null) {
                this.suspended = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Filter".equals(element.getNodeName())) {
            throw new ValidationException("Filter: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "TargetType");
        if (value == null) {
            throw new ValidationException("Filter/TargetType: attribute is required!");
        }
        this.targetType = value;
        value = XMLHelper.getAttribute(element, "Version");
        if (value != null) {
            this.version = value;
        }
        if ((value = XMLHelper.getAttribute(element, "TargetProduct")) != null) {
            this.targetProduct = value;
        }
        if ((value = XMLHelper.getAttribute(element, "TargetClientPlatform")) != null) {
            this.targetClientPlatform = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Obsolete")) != null) {
            this.obsolete = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Suspended")) != null) {
            this.suspended = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("Filter/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("Filter/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("Filter");
        if (this.targetType != null) {
            element.setAttribute("TargetType", this.targetType);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.targetProduct != null) {
            element.setAttribute("TargetProduct", this.targetProduct);
        }
        if (this.targetClientPlatform != null) {
            element.setAttribute("TargetClientPlatform", this.targetClientPlatform);
        }
        if (this.obsolete != null) {
            element.setAttribute("Obsolete", this.obsolete != false ? "1" : "0");
        }
        if (this.suspended != null) {
            element.setAttribute("Suspended", this.suspended != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Filter ");
            if (this.targetType != null) {
                strAttrs.append("TargetType=\"").append(AbstractSchema.checkXMLContent(this.targetType)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.targetProduct != null) {
                strAttrs.append("TargetProduct=\"").append(AbstractSchema.checkXMLContent(this.targetProduct)).append("\" ");
            }
            if (this.targetClientPlatform != null) {
                strAttrs.append("TargetClientPlatform=\"").append(AbstractSchema.checkXMLContent(this.targetClientPlatform)).append("\" ");
            }
            if (this.obsolete != null) {
                strAttrs.append("Obsolete=").append(this.obsolete != false ? "\"1\" " : "\"0\" ");
            }
            if (this.suspended != null) {
                strAttrs.append("Suspended=").append(this.suspended != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Filter>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

