/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.SafeProcessExclusionList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileScanningOptions
extends ConfigObject {
    public static final Integer ON_MODIFIED = 0;
    public static final Integer ON_ACCESSED_OR_MODIFIED = 1;
    private static final long serialVersionUID = 1L;
    private Integer whenToScanFiles;
    private Boolean scanFilesOpenedForBackup;
    private Boolean lockWhenToScanFiles;
    private Boolean lockScanFilesOpenedForBackup;
    private Boolean forLeaveAloneDeleteInfectedOnCreate;
    private Boolean forLeaveAloneDeleteInfectedOnCreateSRT;
    private Boolean lockForLeaveAloneDeleteInfectedOnCreate;
    private Boolean preserveFileTimes;
    private Boolean lockPreserveFileTimes;
    private Boolean enableSafeProcessExclusion;
    private Boolean lockEnableSafeProcessExclusion;
    private Boolean enableSafeProcessExclusionList;
    private Boolean lockEnableSafeProcessExclusionList;

    public FileScanningOptions() {
        this(true);
    }

    public FileScanningOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(813, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "FileScanningOptions";
    }

    public Integer getWhenToScanFiles() {
        return this.whenToScanFiles;
    }

    public String getWhenToScanFilesValue() throws ValidationException {
        if (this.whenToScanFiles == null) {
            return null;
        }
        String s = null;
        switch (this.whenToScanFiles) {
            case 0: {
                s = "ON_MODIFIED";
                break;
            }
            case 1: {
                s = "ON_ACCESSED_OR_MODIFIED";
                break;
            }
            default: {
                throw new ValidationException("FileScanningOptions/WhenToScanFiles: invalid attribute value:" + this.whenToScanFiles + "!");
            }
        }
        return s;
    }

    public void setWhenToScanFiles(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.whenToScanFiles = value;
    }

    public void setWhenToScanFilesValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ON_MODIFIED".equals(value)) {
            this.whenToScanFiles = ON_MODIFIED;
        } else if ("ON_ACCESSED_OR_MODIFIED".equals(value)) {
            this.whenToScanFiles = ON_ACCESSED_OR_MODIFIED;
        } else {
            throw new ValidationException("FileScanningOptions/WhenToScanFiles: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefScanFilesOpenedForBackup() {
        return Boolean.TRUE;
    }

    public Boolean getOptScanFilesOpenedForBackup() {
        return this.scanFilesOpenedForBackup;
    }

    public void setOptScanFilesOpenedForBackup(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanFilesOpenedForBackup = value;
    }

    public Boolean getDefLockWhenToScanFiles() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockWhenToScanFiles() {
        return this.lockWhenToScanFiles;
    }

    public void setOptLockWhenToScanFiles(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockWhenToScanFiles = value;
    }

    public Boolean getDefLockScanFilesOpenedForBackup() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockScanFilesOpenedForBackup() {
        return this.lockScanFilesOpenedForBackup;
    }

    public void setOptLockScanFilesOpenedForBackup(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockScanFilesOpenedForBackup = value;
    }

    public Boolean getDefForLeaveAloneDeleteInfectedOnCreate() {
        return Boolean.FALSE;
    }

    public Boolean getOptForLeaveAloneDeleteInfectedOnCreate() {
        return this.forLeaveAloneDeleteInfectedOnCreate;
    }

    public void setOptForLeaveAloneDeleteInfectedOnCreate(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.forLeaveAloneDeleteInfectedOnCreate = value;
    }

    public Boolean getDefForLeaveAloneDeleteInfectedOnCreateSRT() {
        return Boolean.FALSE;
    }

    public Boolean getOptForLeaveAloneDeleteInfectedOnCreateSRT() {
        return this.forLeaveAloneDeleteInfectedOnCreateSRT;
    }

    public void setOptForLeaveAloneDeleteInfectedOnCreateSRT(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.forLeaveAloneDeleteInfectedOnCreateSRT = value;
    }

    public Boolean getDefLockForLeaveAloneDeleteInfectedOnCreate() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockForLeaveAloneDeleteInfectedOnCreate() {
        return this.lockForLeaveAloneDeleteInfectedOnCreate;
    }

    public void setOptLockForLeaveAloneDeleteInfectedOnCreate(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockForLeaveAloneDeleteInfectedOnCreate = value;
    }

    public Boolean getDefPreserveFileTimes() {
        return Boolean.TRUE;
    }

    public Boolean getOptPreserveFileTimes() {
        return this.preserveFileTimes;
    }

    public void setOptPreserveFileTimes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.preserveFileTimes = value;
    }

    public Boolean getDefLockPreserveFileTimes() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockPreserveFileTimes() {
        return this.lockPreserveFileTimes;
    }

    public void setOptLockPreserveFileTimes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockPreserveFileTimes = value;
    }

    public Boolean getDefEnableSafeProcessExclusion() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnableSafeProcessExclusion() {
        return this.enableSafeProcessExclusion;
    }

    public void setOptEnableSafeProcessExclusion(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableSafeProcessExclusion = value;
    }

    public Boolean getDefLockEnableSafeProcessExclusion() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEnableSafeProcessExclusion() {
        return this.lockEnableSafeProcessExclusion;
    }

    public void setOptLockEnableSafeProcessExclusion(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockEnableSafeProcessExclusion = value;
    }

    public Boolean getDefEnableSafeProcessExclusionList() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableSafeProcessExclusionList() {
        return this.enableSafeProcessExclusionList;
    }

    public void setOptEnableSafeProcessExclusionList(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableSafeProcessExclusionList = value;
    }

    public Boolean getDefLockEnableSafeProcessExclusionList() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEnableSafeProcessExclusionList() {
        return this.lockEnableSafeProcessExclusionList;
    }

    public void setOptLockEnableSafeProcessExclusionList(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockEnableSafeProcessExclusionList = value;
    }

    public SafeProcessExclusionList getOptSafeProcessExclusionList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(813);
        if (childGroup.size() > 0) {
            return (SafeProcessExclusionList)childGroup.get(0);
        }
        return null;
    }

    public void setOptSafeProcessExclusionList(SafeProcessExclusionList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SafeProcessExclusionList obj = this.getOptSafeProcessExclusionList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 610;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.whenToScanFiles == null) {
            throw new ValidationException("FileScanningOptions/WhenToScanFiles: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SafeProcessExclusionList) {
            try {
                this.setOptSafeProcessExclusionList((SafeProcessExclusionList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("WhenToScanFiles");
            if (value == null) {
                throw new ValidationException("FileScanningOptions/WhenToScanFiles: attribute is required!");
            }
            this.setWhenToScanFilesValue(value);
            value = attris.getValue("ScanFilesOpenedForBackup");
            if (value != null) {
                this.scanFilesOpenedForBackup = "1".equals(value);
            }
            if ((value = attris.getValue("LockWhenToScanFiles")) != null) {
                this.lockWhenToScanFiles = "1".equals(value);
            }
            if ((value = attris.getValue("LockScanFilesOpenedForBackup")) != null) {
                this.lockScanFilesOpenedForBackup = "1".equals(value);
            }
            if ((value = attris.getValue("ForLeaveAloneDeleteInfectedOnCreate")) != null) {
                this.forLeaveAloneDeleteInfectedOnCreate = "1".equals(value);
            }
            if ((value = attris.getValue("ForLeaveAloneDeleteInfectedOnCreateSRT")) != null) {
                this.forLeaveAloneDeleteInfectedOnCreateSRT = "1".equals(value);
            }
            if ((value = attris.getValue("LockForLeaveAloneDeleteInfectedOnCreate")) != null) {
                this.lockForLeaveAloneDeleteInfectedOnCreate = "1".equals(value);
            }
            if ((value = attris.getValue("PreserveFileTimes")) != null) {
                this.preserveFileTimes = "1".equals(value);
            }
            if ((value = attris.getValue("LockPreserveFileTimes")) != null) {
                this.lockPreserveFileTimes = "1".equals(value);
            }
            if ((value = attris.getValue("EnableSafeProcessExclusion")) != null) {
                this.enableSafeProcessExclusion = "1".equals(value);
            }
            if ((value = attris.getValue("LockEnableSafeProcessExclusion")) != null) {
                this.lockEnableSafeProcessExclusion = "1".equals(value);
            }
            if ((value = attris.getValue("EnableSafeProcessExclusionList")) != null) {
                this.enableSafeProcessExclusionList = "1".equals(value);
            }
            if ((value = attris.getValue("LockEnableSafeProcessExclusionList")) != null) {
                this.lockEnableSafeProcessExclusionList = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptSafeProcessExclusionList() != null) {
            this.getOptSafeProcessExclusionList().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"FileScanningOptions".equals(element.getNodeName())) {
            throw new ValidationException("FileScanningOptions: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "WhenToScanFiles");
        if (value == null) {
            throw new ValidationException("FileScanningOptions/WhenToScanFiles: attribute is required!");
        }
        this.setWhenToScanFilesValue(value);
        value = XMLHelper.getAttribute(element, "ScanFilesOpenedForBackup");
        if (value != null) {
            this.scanFilesOpenedForBackup = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockWhenToScanFiles")) != null) {
            this.lockWhenToScanFiles = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockScanFilesOpenedForBackup")) != null) {
            this.lockScanFilesOpenedForBackup = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ForLeaveAloneDeleteInfectedOnCreate")) != null) {
            this.forLeaveAloneDeleteInfectedOnCreate = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ForLeaveAloneDeleteInfectedOnCreateSRT")) != null) {
            this.forLeaveAloneDeleteInfectedOnCreateSRT = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockForLeaveAloneDeleteInfectedOnCreate")) != null) {
            this.lockForLeaveAloneDeleteInfectedOnCreate = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PreserveFileTimes")) != null) {
            this.preserveFileTimes = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockPreserveFileTimes")) != null) {
            this.lockPreserveFileTimes = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableSafeProcessExclusion")) != null) {
            this.enableSafeProcessExclusion = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockEnableSafeProcessExclusion")) != null) {
            this.lockEnableSafeProcessExclusion = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableSafeProcessExclusionList")) != null) {
            this.enableSafeProcessExclusionList = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockEnableSafeProcessExclusionList")) != null) {
            this.lockEnableSafeProcessExclusionList = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SafeProcessExclusionList")).size() > 0) {
            SafeProcessExclusionList safeProcessExclusionListObj = new SafeProcessExclusionList();
            safeProcessExclusionListObj.importFromElement(v.get(0));
            this.setOptSafeProcessExclusionList(safeProcessExclusionListObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FileScanningOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FileScanningOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FileScanningOptions");
        if (this.whenToScanFiles != null) {
            element.setAttribute("WhenToScanFiles", this.getWhenToScanFilesValue());
        }
        if (this.scanFilesOpenedForBackup != null) {
            element.setAttribute("ScanFilesOpenedForBackup", this.scanFilesOpenedForBackup != false ? "1" : "0");
        }
        if (this.lockWhenToScanFiles != null) {
            element.setAttribute("LockWhenToScanFiles", this.lockWhenToScanFiles != false ? "1" : "0");
        }
        if (this.lockScanFilesOpenedForBackup != null) {
            element.setAttribute("LockScanFilesOpenedForBackup", this.lockScanFilesOpenedForBackup != false ? "1" : "0");
        }
        if (this.forLeaveAloneDeleteInfectedOnCreate != null) {
            element.setAttribute("ForLeaveAloneDeleteInfectedOnCreate", this.forLeaveAloneDeleteInfectedOnCreate != false ? "1" : "0");
        }
        if (this.forLeaveAloneDeleteInfectedOnCreateSRT != null) {
            element.setAttribute("ForLeaveAloneDeleteInfectedOnCreateSRT", this.forLeaveAloneDeleteInfectedOnCreateSRT != false ? "1" : "0");
        }
        if (this.lockForLeaveAloneDeleteInfectedOnCreate != null) {
            element.setAttribute("LockForLeaveAloneDeleteInfectedOnCreate", this.lockForLeaveAloneDeleteInfectedOnCreate != false ? "1" : "0");
        }
        if (this.preserveFileTimes != null) {
            element.setAttribute("PreserveFileTimes", this.preserveFileTimes != false ? "1" : "0");
        }
        if (this.lockPreserveFileTimes != null) {
            element.setAttribute("LockPreserveFileTimes", this.lockPreserveFileTimes != false ? "1" : "0");
        }
        if (this.enableSafeProcessExclusion != null) {
            element.setAttribute("EnableSafeProcessExclusion", this.enableSafeProcessExclusion != false ? "1" : "0");
        }
        if (this.lockEnableSafeProcessExclusion != null) {
            element.setAttribute("LockEnableSafeProcessExclusion", this.lockEnableSafeProcessExclusion != false ? "1" : "0");
        }
        if (this.enableSafeProcessExclusionList != null) {
            element.setAttribute("EnableSafeProcessExclusionList", this.enableSafeProcessExclusionList != false ? "1" : "0");
        }
        if (this.lockEnableSafeProcessExclusionList != null) {
            element.setAttribute("LockEnableSafeProcessExclusionList", this.lockEnableSafeProcessExclusionList != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FileScanningOptions ");
            if (this.whenToScanFiles != null) {
                strAttrs.append("WhenToScanFiles=\"").append(this.getWhenToScanFilesValue()).append("\" ");
            }
            if (this.scanFilesOpenedForBackup != null) {
                strAttrs.append("ScanFilesOpenedForBackup=").append(this.scanFilesOpenedForBackup != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockWhenToScanFiles != null) {
                strAttrs.append("LockWhenToScanFiles=").append(this.lockWhenToScanFiles != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockScanFilesOpenedForBackup != null) {
                strAttrs.append("LockScanFilesOpenedForBackup=").append(this.lockScanFilesOpenedForBackup != false ? "\"1\" " : "\"0\" ");
            }
            if (this.forLeaveAloneDeleteInfectedOnCreate != null) {
                strAttrs.append("ForLeaveAloneDeleteInfectedOnCreate=").append(this.forLeaveAloneDeleteInfectedOnCreate != false ? "\"1\" " : "\"0\" ");
            }
            if (this.forLeaveAloneDeleteInfectedOnCreateSRT != null) {
                strAttrs.append("ForLeaveAloneDeleteInfectedOnCreateSRT=").append(this.forLeaveAloneDeleteInfectedOnCreateSRT != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockForLeaveAloneDeleteInfectedOnCreate != null) {
                strAttrs.append("LockForLeaveAloneDeleteInfectedOnCreate=").append(this.lockForLeaveAloneDeleteInfectedOnCreate != false ? "\"1\" " : "\"0\" ");
            }
            if (this.preserveFileTimes != null) {
                strAttrs.append("PreserveFileTimes=").append(this.preserveFileTimes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockPreserveFileTimes != null) {
                strAttrs.append("LockPreserveFileTimes=").append(this.lockPreserveFileTimes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableSafeProcessExclusion != null) {
                strAttrs.append("EnableSafeProcessExclusion=").append(this.enableSafeProcessExclusion != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockEnableSafeProcessExclusion != null) {
                strAttrs.append("LockEnableSafeProcessExclusion=").append(this.lockEnableSafeProcessExclusion != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableSafeProcessExclusionList != null) {
                strAttrs.append("EnableSafeProcessExclusionList=").append(this.enableSafeProcessExclusionList != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockEnableSafeProcessExclusionList != null) {
                strAttrs.append("LockEnableSafeProcessExclusionList=").append(this.lockEnableSafeProcessExclusionList != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FileScanningOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

