/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ProtectionTechnology;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileOverride
extends ConfigObject {
    public static final Integer WINDOWS = 0;
    public static final Integer MAC = 1;
    public static final Integer LINUX = 2;
    private static final long serialVersionUID = 1L;
    private String prefixVariable;
    private String filePath;
    private Integer oS;

    public FileOverride() {
        this(true);
    }

    public FileOverride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(608, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "FileOverride";
    }

    public String getPrefixVariable() {
        return this.prefixVariable;
    }

    public void setPrefixVariable(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.prefixVariable = value;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.filePath = value;
    }

    public Integer getDefOS() {
        return WINDOWS;
    }

    public Integer getOptOS() {
        return this.oS;
    }

    public String getOptOSValue() throws ValidationException {
        if (this.oS == null) {
            return null;
        }
        String s = null;
        switch (this.oS) {
            case 0: {
                s = "WINDOWS";
                break;
            }
            case 1: {
                s = "MAC";
                break;
            }
            case 2: {
                s = "LINUX";
                break;
            }
            default: {
                throw new ValidationException("FileOverride/OS: invalid attribute value:" + this.oS + "!");
            }
        }
        return s;
    }

    public void setOptOS(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.oS = value;
    }

    public void setOptOSValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.oS = null;
            return;
        }
        if ("WINDOWS".equals(value)) {
            this.oS = WINDOWS;
        } else if ("MAC".equals(value)) {
            this.oS = MAC;
        } else if ("LINUX".equals(value)) {
            this.oS = LINUX;
        } else {
            throw new ValidationException("FileOverride/OS: invalid attribute value:" + value + "!");
        }
    }

    public void addProtectionTechnology(ProtectionTechnology value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addProtectionTechnology(int index, ProtectionTechnology value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ProtectionTechnology> getProtectionTechnology() {
        Vector<ProtectionTechnology> v = new Vector<ProtectionTechnology>();
        for (Transportable child : (ChildGroup)this.children.get(608)) {
            v.add((ProtectionTechnology)child);
        }
        return v;
    }

    public int getProtectionTechnologyCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(608);
        return childGroup.size();
    }

    public ProtectionTechnology getProtectionTechnology(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(608);
        return (ProtectionTechnology)childGroup.get(index);
    }

    public void setProtectionTechnology(int index, ProtectionTechnology value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeProtectionTechnology(ProtectionTechnology value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 683;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.prefixVariable == null) {
            throw new ValidationException("FileOverride/PrefixVariable: attribute is required!");
        }
        if (this.filePath == null) {
            throw new ValidationException("FileOverride/FilePath: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ProtectionTechnology) {
            try {
                this.addProtectionTechnology((ProtectionTechnology)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("PrefixVariable");
            if (value == null) {
                throw new ValidationException("FileOverride/PrefixVariable: attribute is required!");
            }
            this.prefixVariable = value;
            value = attris.getValue("FilePath");
            if (value == null) {
                throw new ValidationException("FileOverride/FilePath: attribute is required!");
            }
            this.filePath = value;
            value = attris.getValue("OS");
            if (value != null) {
                this.setOptOSValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getProtectionTechnologyCount();
        for (i = 0; i < objCnt; ++i) {
            this.getProtectionTechnology(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"FileOverride".equals(element.getNodeName())) {
            throw new ValidationException("FileOverride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "PrefixVariable");
        if (value == null) {
            throw new ValidationException("FileOverride/PrefixVariable: attribute is required!");
        }
        this.prefixVariable = value;
        value = XMLHelper.getAttribute(element, "FilePath");
        if (value == null) {
            throw new ValidationException("FileOverride/FilePath: attribute is required!");
        }
        this.filePath = value;
        value = XMLHelper.getAttribute(element, "OS");
        if (value != null) {
            this.setOptOSValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ProtectionTechnology");
        for (int i = 0; i < v.size(); ++i) {
            ProtectionTechnology protectionTechnologyObj = new ProtectionTechnology();
            protectionTechnologyObj.importFromElement(v.get(i));
            this.addProtectionTechnology(protectionTechnologyObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FileOverride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FileOverride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FileOverride");
        if (this.prefixVariable != null) {
            element.setAttribute("PrefixVariable", this.prefixVariable);
        }
        if (this.filePath != null) {
            element.setAttribute("FilePath", this.filePath);
        }
        if (this.oS != null) {
            element.setAttribute("OS", this.getOptOSValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FileOverride ");
            if (this.prefixVariable != null) {
                strAttrs.append("PrefixVariable=\"").append(AbstractSchema.checkXMLContent(this.prefixVariable)).append("\" ");
            }
            if (this.filePath != null) {
                strAttrs.append("FilePath=\"").append(AbstractSchema.checkXMLContent(this.filePath)).append("\" ");
            }
            if (this.oS != null) {
                strAttrs.append("OS=\"").append(this.getOptOSValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FileOverride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

