/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileCache
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean lockEnableFileCache;
    private Boolean rescanOnDefReload;
    private Boolean useDefaultCacheSize;
    private Long fileCacheEntries;
    private Long fileCacheSize;

    public FileCache() {
        this(true);
    }

    public FileCache(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "FileCache";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefLockEnableFileCache() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEnableFileCache() {
        return this.lockEnableFileCache;
    }

    public void setOptLockEnableFileCache(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockEnableFileCache = value;
    }

    public Boolean getDefRescanOnDefReload() {
        return Boolean.TRUE;
    }

    public Boolean getOptRescanOnDefReload() {
        return this.rescanOnDefReload;
    }

    public void setOptRescanOnDefReload(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rescanOnDefReload = value;
    }

    public Boolean getDefUseDefaultCacheSize() {
        return Boolean.TRUE;
    }

    public Boolean getOptUseDefaultCacheSize() {
        return this.useDefaultCacheSize;
    }

    public void setOptUseDefaultCacheSize(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useDefaultCacheSize = value;
    }

    public Long getDefFileCacheEntries() {
        return 30000L;
    }

    public Long getOptFileCacheEntries() {
        return this.fileCacheEntries;
    }

    public void setOptFileCacheEntries(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileCacheEntries = value;
    }

    public Long getDefFileCacheSize() {
        return 0L;
    }

    public Long getOptFileCacheSize() {
        return this.fileCacheSize;
    }

    public void setOptFileCacheSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileCacheSize = value;
    }

    @Override
    public int getObjectType() {
        return 623;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("LockEnableFileCache")) != null) {
                this.lockEnableFileCache = "1".equals(value);
            }
            if ((value = attris.getValue("RescanOnDefReload")) != null) {
                this.rescanOnDefReload = "1".equals(value);
            }
            if ((value = attris.getValue("UseDefaultCacheSize")) != null) {
                this.useDefaultCacheSize = "1".equals(value);
            }
            if ((value = attris.getValue("FileCacheEntries")) != null) {
                try {
                    this.fileCacheEntries = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("FileCache/FileCacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("FileCache/FileCacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FileCacheSize")) != null) {
                try {
                    this.fileCacheSize = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("FileCache/FileCacheSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("FileCache/FileCacheSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"FileCache".equals(element.getNodeName())) {
            throw new ValidationException("FileCache: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockEnableFileCache")) != null) {
            this.lockEnableFileCache = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RescanOnDefReload")) != null) {
            this.rescanOnDefReload = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UseDefaultCacheSize")) != null) {
            this.useDefaultCacheSize = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "FileCacheEntries")) != null) {
            try {
                this.fileCacheEntries = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("FileCache/FileCacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FileCacheSize")) != null) {
            try {
                this.fileCacheSize = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("FileCache/FileCacheSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FileCache/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FileCache/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FileCache");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.lockEnableFileCache != null) {
            element.setAttribute("LockEnableFileCache", this.lockEnableFileCache != false ? "1" : "0");
        }
        if (this.rescanOnDefReload != null) {
            element.setAttribute("RescanOnDefReload", this.rescanOnDefReload != false ? "1" : "0");
        }
        if (this.useDefaultCacheSize != null) {
            element.setAttribute("UseDefaultCacheSize", this.useDefaultCacheSize != false ? "1" : "0");
        }
        if (this.fileCacheEntries != null) {
            element.setAttribute("FileCacheEntries", this.fileCacheEntries.toString());
        }
        if (this.fileCacheSize != null) {
            element.setAttribute("FileCacheSize", this.fileCacheSize.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FileCache ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockEnableFileCache != null) {
                strAttrs.append("LockEnableFileCache=").append(this.lockEnableFileCache != false ? "\"1\" " : "\"0\" ");
            }
            if (this.rescanOnDefReload != null) {
                strAttrs.append("RescanOnDefReload=").append(this.rescanOnDefReload != false ? "\"1\" " : "\"0\" ");
            }
            if (this.useDefaultCacheSize != null) {
                strAttrs.append("UseDefaultCacheSize=").append(this.useDefaultCacheSize != false ? "\"1\" " : "\"0\" ");
            }
            if (this.fileCacheEntries != null) {
                strAttrs.append("FileCacheEntries=\"").append(this.fileCacheEntries.toString()).append("\" ");
            }
            if (this.fileCacheSize != null) {
                strAttrs.append("FileCacheSize=\"").append(this.fileCacheSize.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FileCache>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

