/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeedFilterDefinition
extends ConfigObject {
    public static final Integer BOOLEAN = 0;
    public static final Integer INT = 1;
    public static final Integer REAL = 2;
    public static final Integer STRING = 3;
    public static final Integer DATETIME = 4;
    private static final long serialVersionUID = 1L;
    private String filterName;
    private String columnName;
    private Integer dataType;

    public FeedFilterDefinition() {
        this(true);
    }

    public FeedFilterDefinition(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "FeedFilterDefinition";
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.filterName = value;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.columnName = value;
    }

    public Integer getOptDataType() {
        return this.dataType;
    }

    public String getOptDataTypeValue() throws ValidationException {
        if (this.dataType == null) {
            return null;
        }
        String s = null;
        switch (this.dataType) {
            case 0: {
                s = "BOOLEAN";
                break;
            }
            case 1: {
                s = "INT";
                break;
            }
            case 2: {
                s = "REAL";
                break;
            }
            case 3: {
                s = "STRING";
                break;
            }
            case 4: {
                s = "DATETIME";
                break;
            }
            default: {
                throw new ValidationException("FeedFilterDefinition/DataType: invalid attribute value:" + this.dataType + "!");
            }
        }
        return s;
    }

    public void setOptDataType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dataType = value;
    }

    public void setOptDataTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.dataType = null;
            return;
        }
        if ("BOOLEAN".equals(value)) {
            this.dataType = BOOLEAN;
        } else if ("INT".equals(value)) {
            this.dataType = INT;
        } else if ("REAL".equals(value)) {
            this.dataType = REAL;
        } else if ("STRING".equals(value)) {
            this.dataType = STRING;
        } else if ("DATETIME".equals(value)) {
            this.dataType = DATETIME;
        } else {
            throw new ValidationException("FeedFilterDefinition/DataType: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 797;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.filterName == null) {
            throw new ValidationException("FeedFilterDefinition/FilterName: attribute is required!");
        }
        if (this.columnName == null) {
            throw new ValidationException("FeedFilterDefinition/ColumnName: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("FilterName");
            if (value == null) {
                throw new ValidationException("FeedFilterDefinition/FilterName: attribute is required!");
            }
            this.filterName = value;
            value = attris.getValue("ColumnName");
            if (value == null) {
                throw new ValidationException("FeedFilterDefinition/ColumnName: attribute is required!");
            }
            this.columnName = value;
            value = attris.getValue("DataType");
            if (value != null) {
                this.setOptDataTypeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"FeedFilterDefinition".equals(element.getNodeName())) {
            throw new ValidationException("FeedFilterDefinition: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "FilterName");
        if (value == null) {
            throw new ValidationException("FeedFilterDefinition/FilterName: attribute is required!");
        }
        this.filterName = value;
        value = XMLHelper.getAttribute(element, "ColumnName");
        if (value == null) {
            throw new ValidationException("FeedFilterDefinition/ColumnName: attribute is required!");
        }
        this.columnName = value;
        value = XMLHelper.getAttribute(element, "DataType");
        if (value != null) {
            this.setOptDataTypeValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FeedFilterDefinition/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FeedFilterDefinition/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FeedFilterDefinition");
        if (this.filterName != null) {
            element.setAttribute("FilterName", this.filterName);
        }
        if (this.columnName != null) {
            element.setAttribute("ColumnName", this.columnName);
        }
        if (this.dataType != null) {
            element.setAttribute("DataType", this.getOptDataTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FeedFilterDefinition ");
            if (this.filterName != null) {
                strAttrs.append("FilterName=\"").append(AbstractSchema.checkXMLContent(this.filterName)).append("\" ");
            }
            if (this.columnName != null) {
                strAttrs.append("ColumnName=\"").append(AbstractSchema.checkXMLContent(this.columnName)).append("\" ");
            }
            if (this.dataType != null) {
                strAttrs.append("DataType=\"").append(this.getOptDataTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FeedFilterDefinition>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

