/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AllowedHavingFilters;
import com.sygate.scm.common.configobject.schema.AllowedSortingFilters;
import com.sygate.scm.common.configobject.schema.AllowedWhereFilters;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeedDefinition
extends ConfigObject {
    public static final Integer RISK_EVENTS = 0;
    public static final Integer CLIENT_ACTIVITY = 1;
    public static final Integer CLIENT_SECURITY = 2;
    public static final Integer CLIENT_TRAFFIC = 3;
    public static final Integer CLIENT_PACKET = 4;
    public static final Integer CLIENT_CONTROL = 5;
    private static final long serialVersionUID = 1L;
    private String feedID;
    private String baseSQL;
    private String securitySQL;
    private String deltaFilterColumn;
    private Integer dataSource;

    public FeedDefinition() {
        this(true);
    }

    public FeedDefinition(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(794, new ChildGroup(0, 1));
        this.children.put(795, new ChildGroup(0, 1));
        this.children.put(796, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "FeedDefinition";
    }

    public String getFeedID() {
        return this.feedID;
    }

    public void setFeedID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.feedID = value;
    }

    public String getBaseSQL() {
        return this.baseSQL;
    }

    public void setBaseSQL(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.baseSQL = value;
    }

    public String getOptSecuritySQL() {
        return this.securitySQL;
    }

    public void setOptSecuritySQL(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.securitySQL = value;
    }

    public String getOptDeltaFilterColumn() {
        return this.deltaFilterColumn;
    }

    public void setOptDeltaFilterColumn(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deltaFilterColumn = value;
    }

    public Integer getOptDataSource() {
        return this.dataSource;
    }

    public String getOptDataSourceValue() throws ValidationException {
        if (this.dataSource == null) {
            return null;
        }
        String s = null;
        switch (this.dataSource) {
            case 0: {
                s = "RISK_EVENTS";
                break;
            }
            case 1: {
                s = "CLIENT_ACTIVITY";
                break;
            }
            case 2: {
                s = "CLIENT_SECURITY";
                break;
            }
            case 3: {
                s = "CLIENT_TRAFFIC";
                break;
            }
            case 4: {
                s = "CLIENT_PACKET";
                break;
            }
            case 5: {
                s = "CLIENT_CONTROL";
                break;
            }
            default: {
                throw new ValidationException("FeedDefinition/DataSource: invalid attribute value:" + this.dataSource + "!");
            }
        }
        return s;
    }

    public void setOptDataSource(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dataSource = value;
    }

    public void setOptDataSourceValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.dataSource = null;
            return;
        }
        if ("RISK_EVENTS".equals(value)) {
            this.dataSource = RISK_EVENTS;
        } else if ("CLIENT_ACTIVITY".equals(value)) {
            this.dataSource = CLIENT_ACTIVITY;
        } else if ("CLIENT_SECURITY".equals(value)) {
            this.dataSource = CLIENT_SECURITY;
        } else if ("CLIENT_TRAFFIC".equals(value)) {
            this.dataSource = CLIENT_TRAFFIC;
        } else if ("CLIENT_PACKET".equals(value)) {
            this.dataSource = CLIENT_PACKET;
        } else if ("CLIENT_CONTROL".equals(value)) {
            this.dataSource = CLIENT_CONTROL;
        } else {
            throw new ValidationException("FeedDefinition/DataSource: invalid attribute value:" + value + "!");
        }
    }

    public AllowedWhereFilters getOptAllowedWhereFilters() {
        ChildGroup childGroup = (ChildGroup)this.children.get(794);
        if (childGroup.size() > 0) {
            return (AllowedWhereFilters)childGroup.get(0);
        }
        return null;
    }

    public void setOptAllowedWhereFilters(AllowedWhereFilters value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AllowedWhereFilters obj = this.getOptAllowedWhereFilters();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AllowedHavingFilters getOptAllowedHavingFilters() {
        ChildGroup childGroup = (ChildGroup)this.children.get(795);
        if (childGroup.size() > 0) {
            return (AllowedHavingFilters)childGroup.get(0);
        }
        return null;
    }

    public void setOptAllowedHavingFilters(AllowedHavingFilters value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AllowedHavingFilters obj = this.getOptAllowedHavingFilters();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AllowedSortingFilters getOptAllowedSortingFilters() {
        ChildGroup childGroup = (ChildGroup)this.children.get(796);
        if (childGroup.size() > 0) {
            return (AllowedSortingFilters)childGroup.get(0);
        }
        return null;
    }

    public void setOptAllowedSortingFilters(AllowedSortingFilters value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AllowedSortingFilters obj = this.getOptAllowedSortingFilters();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 793;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.feedID == null) {
            throw new ValidationException("FeedDefinition/FeedID: attribute is required!");
        }
        if (this.baseSQL == null) {
            throw new ValidationException("FeedDefinition/BaseSQL: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AllowedWhereFilters) {
            try {
                this.setOptAllowedWhereFilters((AllowedWhereFilters)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AllowedHavingFilters) {
            try {
                this.setOptAllowedHavingFilters((AllowedHavingFilters)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AllowedSortingFilters) {
            try {
                this.setOptAllowedSortingFilters((AllowedSortingFilters)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("FeedID");
            if (value == null) {
                throw new ValidationException("FeedDefinition/FeedID: attribute is required!");
            }
            this.feedID = value;
            value = attris.getValue("BaseSQL");
            if (value == null) {
                throw new ValidationException("FeedDefinition/BaseSQL: attribute is required!");
            }
            this.baseSQL = value;
            value = attris.getValue("SecuritySQL");
            if (value != null) {
                this.securitySQL = value;
            }
            if ((value = attris.getValue("DeltaFilterColumn")) != null) {
                this.deltaFilterColumn = value;
            }
            if ((value = attris.getValue("DataSource")) != null) {
                this.setOptDataSourceValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptAllowedWhereFilters() != null) {
            this.getOptAllowedWhereFilters().setReadonly();
        }
        if (this.getOptAllowedHavingFilters() != null) {
            this.getOptAllowedHavingFilters().setReadonly();
        }
        if (this.getOptAllowedSortingFilters() != null) {
            this.getOptAllowedSortingFilters().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"FeedDefinition".equals(element.getNodeName())) {
            throw new ValidationException("FeedDefinition: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "FeedID");
        if (value == null) {
            throw new ValidationException("FeedDefinition/FeedID: attribute is required!");
        }
        this.feedID = value;
        value = XMLHelper.getAttribute(element, "BaseSQL");
        if (value == null) {
            throw new ValidationException("FeedDefinition/BaseSQL: attribute is required!");
        }
        this.baseSQL = value;
        value = XMLHelper.getAttribute(element, "SecuritySQL");
        if (value != null) {
            this.securitySQL = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DeltaFilterColumn")) != null) {
            this.deltaFilterColumn = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DataSource")) != null) {
            this.setOptDataSourceValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AllowedWhereFilters")).size() > 0) {
            AllowedWhereFilters allowedWhereFiltersObj = new AllowedWhereFilters();
            allowedWhereFiltersObj.importFromElement(v.get(0));
            this.setOptAllowedWhereFilters(allowedWhereFiltersObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AllowedHavingFilters")).size() > 0) {
            AllowedHavingFilters allowedHavingFiltersObj = new AllowedHavingFilters();
            allowedHavingFiltersObj.importFromElement(v.get(0));
            this.setOptAllowedHavingFilters(allowedHavingFiltersObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AllowedSortingFilters")).size() > 0) {
            AllowedSortingFilters allowedSortingFiltersObj = new AllowedSortingFilters();
            allowedSortingFiltersObj.importFromElement(v.get(0));
            this.setOptAllowedSortingFilters(allowedSortingFiltersObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("FeedDefinition/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("FeedDefinition/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("FeedDefinition");
        if (this.feedID != null) {
            element.setAttribute("FeedID", this.feedID);
        }
        if (this.baseSQL != null) {
            element.setAttribute("BaseSQL", this.baseSQL);
        }
        if (this.securitySQL != null) {
            element.setAttribute("SecuritySQL", this.securitySQL);
        }
        if (this.deltaFilterColumn != null) {
            element.setAttribute("DeltaFilterColumn", this.deltaFilterColumn);
        }
        if (this.dataSource != null) {
            element.setAttribute("DataSource", this.getOptDataSourceValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<FeedDefinition ");
            if (this.feedID != null) {
                strAttrs.append("FeedID=\"").append(AbstractSchema.checkXMLContent(this.feedID)).append("\" ");
            }
            if (this.baseSQL != null) {
                strAttrs.append("BaseSQL=\"").append(AbstractSchema.checkXMLContent(this.baseSQL)).append("\" ");
            }
            if (this.securitySQL != null) {
                strAttrs.append("SecuritySQL=\"").append(AbstractSchema.checkXMLContent(this.securitySQL)).append("\" ");
            }
            if (this.deltaFilterColumn != null) {
                strAttrs.append("DeltaFilterColumn=\"").append(AbstractSchema.checkXMLContent(this.deltaFilterColumn)).append("\" ");
            }
            if (this.dataSource != null) {
                strAttrs.append("DataSource=\"").append(this.getOptDataSourceValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</FeedDefinition>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

