/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtendedOpDevice
extends ConfigObject {
    public static final Integer READONLY = 0;
    public static final Integer READWRITE = 1;
    public static final Integer READEXECUTE = 2;
    public static final Integer ALL = 3;
    private static final long serialVersionUID = 1L;
    private String vendor;
    private String model;
    private String serialNumber;
    private Integer permission;

    public ExtendedOpDevice() {
        this(true);
    }

    public ExtendedOpDevice(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ExtendedOpDevice";
    }

    public String getOptVendor() {
        return this.vendor;
    }

    public void setOptVendor(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.vendor = value;
    }

    public String getOptModel() {
        return this.model;
    }

    public void setOptModel(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.model = value;
    }

    public String getOptSerialNumber() {
        return this.serialNumber;
    }

    public void setOptSerialNumber(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serialNumber = value;
    }

    public Integer getDefPermission() {
        return ALL;
    }

    public Integer getOptPermission() {
        return this.permission;
    }

    public String getOptPermissionValue() throws ValidationException {
        if (this.permission == null) {
            return null;
        }
        String s = null;
        switch (this.permission) {
            case 0: {
                s = "READONLY";
                break;
            }
            case 1: {
                s = "READWRITE";
                break;
            }
            case 2: {
                s = "READEXECUTE";
                break;
            }
            case 3: {
                s = "ALL";
                break;
            }
            default: {
                throw new ValidationException("ExtendedOpDevice/Permission: invalid attribute value:" + this.permission + "!");
            }
        }
        return s;
    }

    public void setOptPermission(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.permission = value;
    }

    public void setOptPermissionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.permission = null;
            return;
        }
        if ("READONLY".equals(value)) {
            this.permission = READONLY;
        } else if ("READWRITE".equals(value)) {
            this.permission = READWRITE;
        } else if ("READEXECUTE".equals(value)) {
            this.permission = READEXECUTE;
        } else if ("ALL".equals(value)) {
            this.permission = ALL;
        } else {
            throw new ValidationException("ExtendedOpDevice/Permission: invalid attribute value:" + value + "!");
        }
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 481;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getObjReference() == null) {
            throw new ValidationException("ExtendedOpDevice/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Vendor");
            if (value != null) {
                this.vendor = value;
            }
            if ((value = attris.getValue("Model")) != null) {
                this.model = value;
            }
            if ((value = attris.getValue("SerialNumber")) != null) {
                this.serialNumber = value;
            }
            if ((value = attris.getValue("Permission")) != null) {
                this.setOptPermissionValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ExtendedOpDevice: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ExtendedOpDevice".equals(element.getNodeName())) {
            throw new ValidationException("ExtendedOpDevice: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Vendor");
        if (value != null) {
            this.vendor = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Model")) != null) {
            this.model = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SerialNumber")) != null) {
            this.serialNumber = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Permission")) != null) {
            this.setOptPermissionValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("ExtendedOpDevice/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ExtendedOpDevice/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ExtendedOpDevice/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ExtendedOpDevice");
        if (this.vendor != null) {
            element.setAttribute("Vendor", this.vendor);
        }
        if (this.model != null) {
            element.setAttribute("Model", this.model);
        }
        if (this.serialNumber != null) {
            element.setAttribute("SerialNumber", this.serialNumber);
        }
        if (this.permission != null) {
            element.setAttribute("Permission", this.getOptPermissionValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ExtendedOpDevice ");
            if (this.vendor != null) {
                strAttrs.append("Vendor=\"").append(AbstractSchema.checkXMLContent(this.vendor)).append("\" ");
            }
            if (this.model != null) {
                strAttrs.append("Model=\"").append(AbstractSchema.checkXMLContent(this.model)).append("\" ");
            }
            if (this.serialNumber != null) {
                strAttrs.append("SerialNumber=\"").append(AbstractSchema.checkXMLContent(this.serialNumber)).append("\" ");
            }
            if (this.permission != null) {
                strAttrs.append("Permission=\"").append(this.getOptPermissionValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ExtendedOpDevice>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

