/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AdditionalEpmpData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EpmpOAuth2Client
extends TopLevelObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String epmpCloudEnrollmentId;
    private String encryptedClientId;
    private String encryptedClientSecret;
    private String clientname;
    private String granttypes;
    private String scope;
    private String clientcredentialsprivs;
    private String accesstoken;
    private String tokentype;
    private String expiresin;
    private String powerSAuthToken;
    private String sepmSiteId;
    private String sepmServerId;

    public EpmpOAuth2Client() {
        this(true);
    }

    public EpmpOAuth2Client(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(822, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "EpmpOAuth2Client";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public String getEpmpCloudEnrollmentId() {
        return this.epmpCloudEnrollmentId;
    }

    public void setEpmpCloudEnrollmentId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.epmpCloudEnrollmentId = value;
    }

    public String getEncryptedClientId() {
        return this.encryptedClientId;
    }

    public void setEncryptedClientId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.encryptedClientId = value;
    }

    public String getEncryptedClientSecret() {
        return this.encryptedClientSecret;
    }

    public void setEncryptedClientSecret(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.encryptedClientSecret = value;
    }

    public String getOptclient_name() {
        return this.clientname;
    }

    public void setOptclient_name(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientname = value;
    }

    public String getOptgrant_types() {
        return this.granttypes;
    }

    public void setOptgrant_types(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.granttypes = value;
    }

    public String getOptscope() {
        return this.scope;
    }

    public void setOptscope(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scope = value;
    }

    public String getOptclient_credentials_privs() {
        return this.clientcredentialsprivs;
    }

    public void setOptclient_credentials_privs(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientcredentialsprivs = value;
    }

    public String getOptaccess_token() {
        return this.accesstoken;
    }

    public void setOptaccess_token(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.accesstoken = value;
    }

    public String getOpttoken_type() {
        return this.tokentype;
    }

    public void setOpttoken_type(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.tokentype = value;
    }

    public String getOptexpires_in() {
        return this.expiresin;
    }

    public void setOptexpires_in(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.expiresin = value;
    }

    public String getOptPowerSAuthToken() {
        return this.powerSAuthToken;
    }

    public void setOptPowerSAuthToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.powerSAuthToken = value;
    }

    public String getOptSepmSiteId() {
        return this.sepmSiteId;
    }

    public void setOptSepmSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sepmSiteId = value;
    }

    public String getOptSepmServerId() {
        return this.sepmServerId;
    }

    public void setOptSepmServerId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sepmServerId = value;
    }

    public void addAdditionalEpmpData(AdditionalEpmpData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addAdditionalEpmpData(int index, AdditionalEpmpData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<AdditionalEpmpData> getAdditionalEpmpData() {
        Vector<AdditionalEpmpData> v = new Vector<AdditionalEpmpData>();
        for (Transportable child : (ChildGroup)this.children.get(822)) {
            v.add((AdditionalEpmpData)child);
        }
        return v;
    }

    public int getAdditionalEpmpDataCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(822);
        return childGroup.size();
    }

    public AdditionalEpmpData getAdditionalEpmpData(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(822);
        return (AdditionalEpmpData)childGroup.get(index);
    }

    public void setAdditionalEpmpData(int index, AdditionalEpmpData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeAdditionalEpmpData(AdditionalEpmpData value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 821;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("EpmpOAuth2Client/Id: attribute is required!");
        }
        if (this.epmpCloudEnrollmentId == null) {
            throw new ValidationException("EpmpOAuth2Client/EpmpCloudEnrollmentId: attribute is required!");
        }
        if (this.encryptedClientId == null) {
            throw new ValidationException("EpmpOAuth2Client/EncryptedClientId: attribute is required!");
        }
        if (this.encryptedClientSecret == null) {
            throw new ValidationException("EpmpOAuth2Client/EncryptedClientSecret: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AdditionalEpmpData) {
            try {
                this.addAdditionalEpmpData((AdditionalEpmpData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("EpmpOAuth2Client/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("EpmpCloudEnrollmentId");
            if (value == null) {
                throw new ValidationException("EpmpOAuth2Client/EpmpCloudEnrollmentId: attribute is required!");
            }
            this.epmpCloudEnrollmentId = value;
            value = attris.getValue("EncryptedClientId");
            if (value == null) {
                throw new ValidationException("EpmpOAuth2Client/EncryptedClientId: attribute is required!");
            }
            this.encryptedClientId = value;
            value = attris.getValue("EncryptedClientSecret");
            if (value == null) {
                throw new ValidationException("EpmpOAuth2Client/EncryptedClientSecret: attribute is required!");
            }
            this.encryptedClientSecret = value;
            value = attris.getValue("client_name");
            if (value != null) {
                this.clientname = value;
            }
            if ((value = attris.getValue("grant_types")) != null) {
                this.granttypes = value;
            }
            if ((value = attris.getValue("scope")) != null) {
                this.scope = value;
            }
            if ((value = attris.getValue("client_credentials_privs")) != null) {
                this.clientcredentialsprivs = value;
            }
            if ((value = attris.getValue("access_token")) != null) {
                this.accesstoken = value;
            }
            if ((value = attris.getValue("token_type")) != null) {
                this.tokentype = value;
            }
            if ((value = attris.getValue("expires_in")) != null) {
                this.expiresin = value;
            }
            if ((value = attris.getValue("PowerSAuthToken")) != null) {
                this.powerSAuthToken = value;
            }
            if ((value = attris.getValue("SepmSiteId")) != null) {
                this.sepmSiteId = value;
            }
            if ((value = attris.getValue("SepmServerId")) != null) {
                this.sepmServerId = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getAdditionalEpmpDataCount();
        for (i = 0; i < objCnt; ++i) {
            this.getAdditionalEpmpData(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EpmpOAuth2Client".equals(element.getNodeName())) {
            throw new ValidationException("EpmpOAuth2Client: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("EpmpOAuth2Client/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "EpmpCloudEnrollmentId");
        if (value == null) {
            throw new ValidationException("EpmpOAuth2Client/EpmpCloudEnrollmentId: attribute is required!");
        }
        this.epmpCloudEnrollmentId = value;
        value = XMLHelper.getAttribute(element, "EncryptedClientId");
        if (value == null) {
            throw new ValidationException("EpmpOAuth2Client/EncryptedClientId: attribute is required!");
        }
        this.encryptedClientId = value;
        value = XMLHelper.getAttribute(element, "EncryptedClientSecret");
        if (value == null) {
            throw new ValidationException("EpmpOAuth2Client/EncryptedClientSecret: attribute is required!");
        }
        this.encryptedClientSecret = value;
        value = XMLHelper.getAttribute(element, "client_name");
        if (value != null) {
            this.clientname = value;
        }
        if ((value = XMLHelper.getAttribute(element, "grant_types")) != null) {
            this.granttypes = value;
        }
        if ((value = XMLHelper.getAttribute(element, "scope")) != null) {
            this.scope = value;
        }
        if ((value = XMLHelper.getAttribute(element, "client_credentials_privs")) != null) {
            this.clientcredentialsprivs = value;
        }
        if ((value = XMLHelper.getAttribute(element, "access_token")) != null) {
            this.accesstoken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "token_type")) != null) {
            this.tokentype = value;
        }
        if ((value = XMLHelper.getAttribute(element, "expires_in")) != null) {
            this.expiresin = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PowerSAuthToken")) != null) {
            this.powerSAuthToken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SepmSiteId")) != null) {
            this.sepmSiteId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SepmServerId")) != null) {
            this.sepmServerId = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "AdditionalEpmpData");
        for (int i = 0; i < v.size(); ++i) {
            AdditionalEpmpData additionalEpmpDataObj = new AdditionalEpmpData();
            additionalEpmpDataObj.importFromElement(v.get(i));
            this.addAdditionalEpmpData(additionalEpmpDataObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EpmpOAuth2Client/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EpmpOAuth2Client/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EpmpOAuth2Client");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.epmpCloudEnrollmentId != null) {
            element.setAttribute("EpmpCloudEnrollmentId", this.epmpCloudEnrollmentId);
        }
        if (this.encryptedClientId != null) {
            element.setAttribute("EncryptedClientId", this.encryptedClientId);
        }
        if (this.encryptedClientSecret != null) {
            element.setAttribute("EncryptedClientSecret", this.encryptedClientSecret);
        }
        if (this.clientname != null) {
            element.setAttribute("client_name", this.clientname);
        }
        if (this.granttypes != null) {
            element.setAttribute("grant_types", this.granttypes);
        }
        if (this.scope != null) {
            element.setAttribute("scope", this.scope);
        }
        if (this.clientcredentialsprivs != null) {
            element.setAttribute("client_credentials_privs", this.clientcredentialsprivs);
        }
        if (this.accesstoken != null) {
            element.setAttribute("access_token", this.accesstoken);
        }
        if (this.tokentype != null) {
            element.setAttribute("token_type", this.tokentype);
        }
        if (this.expiresin != null) {
            element.setAttribute("expires_in", this.expiresin);
        }
        if (this.powerSAuthToken != null) {
            element.setAttribute("PowerSAuthToken", this.powerSAuthToken);
        }
        if (this.sepmSiteId != null) {
            element.setAttribute("SepmSiteId", this.sepmSiteId);
        }
        if (this.sepmServerId != null) {
            element.setAttribute("SepmServerId", this.sepmServerId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EpmpOAuth2Client ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.epmpCloudEnrollmentId != null) {
                strAttrs.append("EpmpCloudEnrollmentId=\"").append(AbstractSchema.checkXMLContent(this.epmpCloudEnrollmentId)).append("\" ");
            }
            if (this.encryptedClientId != null) {
                strAttrs.append("EncryptedClientId=\"").append(AbstractSchema.checkXMLContent(this.encryptedClientId)).append("\" ");
            }
            if (this.encryptedClientSecret != null) {
                strAttrs.append("EncryptedClientSecret=\"").append(AbstractSchema.checkXMLContent(this.encryptedClientSecret)).append("\" ");
            }
            if (this.clientname != null) {
                strAttrs.append("client_name=\"").append(AbstractSchema.checkXMLContent(this.clientname)).append("\" ");
            }
            if (this.granttypes != null) {
                strAttrs.append("grant_types=\"").append(AbstractSchema.checkXMLContent(this.granttypes)).append("\" ");
            }
            if (this.scope != null) {
                strAttrs.append("scope=\"").append(AbstractSchema.checkXMLContent(this.scope)).append("\" ");
            }
            if (this.clientcredentialsprivs != null) {
                strAttrs.append("client_credentials_privs=\"").append(AbstractSchema.checkXMLContent(this.clientcredentialsprivs)).append("\" ");
            }
            if (this.accesstoken != null) {
                strAttrs.append("access_token=\"").append(AbstractSchema.checkXMLContent(this.accesstoken)).append("\" ");
            }
            if (this.tokentype != null) {
                strAttrs.append("token_type=\"").append(AbstractSchema.checkXMLContent(this.tokentype)).append("\" ");
            }
            if (this.expiresin != null) {
                strAttrs.append("expires_in=\"").append(AbstractSchema.checkXMLContent(this.expiresin)).append("\" ");
            }
            if (this.powerSAuthToken != null) {
                strAttrs.append("PowerSAuthToken=\"").append(AbstractSchema.checkXMLContent(this.powerSAuthToken)).append("\" ");
            }
            if (this.sepmSiteId != null) {
                strAttrs.append("SepmSiteId=\"").append(AbstractSchema.checkXMLContent(this.sepmSiteId)).append("\" ");
            }
            if (this.sepmServerId != null) {
                strAttrs.append("SepmServerId=\"").append(AbstractSchema.checkXMLContent(this.sepmServerId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EpmpOAuth2Client>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

