/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EpmpCloudEnrollmentId
extends ConfigObject {
    public static final Integer ENROLLED = 0;
    public static final Integer UNENROLLED = 1;
    public static final Integer UNENROLL_FAILED = 2;
    private static final long serialVersionUID = 1L;
    private String id;
    private String sepmDomainId;
    private Integer status;
    private String sepmSiteId;

    public EpmpCloudEnrollmentId() {
        this(true);
    }

    public EpmpCloudEnrollmentId(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "EpmpCloudEnrollmentId";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public String getSepmDomainId() {
        return this.sepmDomainId;
    }

    public void setSepmDomainId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sepmDomainId = value;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusValue() throws ValidationException {
        if (this.status == null) {
            return null;
        }
        String s = null;
        switch (this.status) {
            case 0: {
                s = "ENROLLED";
                break;
            }
            case 1: {
                s = "UNENROLLED";
                break;
            }
            case 2: {
                s = " UNENROLL_FAILED";
                break;
            }
            default: {
                throw new ValidationException("EpmpCloudEnrollmentId/Status: invalid attribute value:" + this.status + "!");
            }
        }
        return s;
    }

    public void setStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.status = value;
    }

    public void setStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ENROLLED".equals(value)) {
            this.status = ENROLLED;
        } else if ("UNENROLLED".equals(value)) {
            this.status = UNENROLLED;
        } else if (" UNENROLL_FAILED".equals(value)) {
            this.status = UNENROLL_FAILED;
        } else {
            throw new ValidationException("EpmpCloudEnrollmentId/Status: invalid attribute value:" + value + "!");
        }
    }

    public String getOptSepmSiteId() {
        return this.sepmSiteId;
    }

    public void setOptSepmSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sepmSiteId = value;
    }

    @Override
    public int getObjectType() {
        return 819;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/Id: attribute is required!");
        }
        if (this.sepmDomainId == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/SepmDomainId: attribute is required!");
        }
        if (this.status == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/Status: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("EpmpCloudEnrollmentId/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("SepmDomainId");
            if (value == null) {
                throw new ValidationException("EpmpCloudEnrollmentId/SepmDomainId: attribute is required!");
            }
            this.sepmDomainId = value;
            value = attris.getValue("Status");
            if (value == null) {
                throw new ValidationException("EpmpCloudEnrollmentId/Status: attribute is required!");
            }
            this.setStatusValue(value);
            value = attris.getValue("SepmSiteId");
            if (value != null) {
                this.sepmSiteId = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"EpmpCloudEnrollmentId".equals(element.getNodeName())) {
            throw new ValidationException("EpmpCloudEnrollmentId: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "SepmDomainId");
        if (value == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/SepmDomainId: attribute is required!");
        }
        this.sepmDomainId = value;
        value = XMLHelper.getAttribute(element, "Status");
        if (value == null) {
            throw new ValidationException("EpmpCloudEnrollmentId/Status: attribute is required!");
        }
        this.setStatusValue(value);
        value = XMLHelper.getAttribute(element, "SepmSiteId");
        if (value != null) {
            this.sepmSiteId = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("EpmpCloudEnrollmentId/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("EpmpCloudEnrollmentId/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("EpmpCloudEnrollmentId");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.sepmDomainId != null) {
            element.setAttribute("SepmDomainId", this.sepmDomainId);
        }
        if (this.status != null) {
            element.setAttribute("Status", this.getStatusValue());
        }
        if (this.sepmSiteId != null) {
            element.setAttribute("SepmSiteId", this.sepmSiteId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<EpmpCloudEnrollmentId ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.sepmDomainId != null) {
                strAttrs.append("SepmDomainId=\"").append(AbstractSchema.checkXMLContent(this.sepmDomainId)).append("\" ");
            }
            if (this.status != null) {
                strAttrs.append("Status=\"").append(this.getStatusValue()).append("\" ");
            }
            if (this.sepmSiteId != null) {
                strAttrs.append("SepmSiteId=\"").append(AbstractSchema.checkXMLContent(this.sepmSiteId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</EpmpCloudEnrollmentId>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

